/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.QueryCondition;
import software.amazon.awssdk.services.qconnect.model.QueryConditionExpressionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryAssistantRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, QueryAssistantRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(QueryAssistantRequest.getter(QueryAssistantRequest::assistantId)).setter(QueryAssistantRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(QueryAssistantRequest.getter(QueryAssistantRequest::maxResults)).setter(QueryAssistantRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(QueryAssistantRequest.getter(QueryAssistantRequest::nextToken)).setter(QueryAssistantRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<QueryCondition>> QUERY_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queryCondition").getter(QueryAssistantRequest.getter(QueryAssistantRequest::queryCondition)).setter(QueryAssistantRequest.setter(Builder::queryCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCondition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryText").getter(QueryAssistantRequest.getter(QueryAssistantRequest::queryText)).setter(QueryAssistantRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryText").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(QueryAssistantRequest.getter(QueryAssistantRequest::sessionId)).setter(QueryAssistantRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, QUERY_CONDITION_FIELD, QUERY_TEXT_FIELD, SESSION_ID_FIELD));
    private final String assistantId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<QueryCondition> queryCondition;
    private final String queryText;
    private final String sessionId;

    private QueryAssistantRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.queryCondition = builder.queryCondition;
        this.queryText = builder.queryText;
        this.sessionId = builder.sessionId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQueryCondition() {
        return this.queryCondition != null && !(this.queryCondition instanceof SdkAutoConstructList);
    }

    public final List<QueryCondition> queryCondition() {
        return this.queryCondition;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryCondition() ? this.queryCondition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryAssistantRequest)) {
            return false;
        }
        QueryAssistantRequest other = (QueryAssistantRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasQueryCondition() == other.hasQueryCondition() && Objects.equals(this.queryCondition(), other.queryCondition()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"QueryAssistantRequest").add("AssistantId", (Object)this.assistantId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("QueryCondition", this.hasQueryCondition() ? this.queryCondition() : null).add("QueryText", (Object)(this.queryText() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "queryCondition": {
                return Optional.ofNullable(clazz.cast(this.queryCondition()));
            }
            case "queryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryAssistantRequest, T> g) {
        return obj -> g.apply((QueryAssistantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private Integer maxResults;
        private String nextToken;
        private List<QueryCondition> queryCondition = DefaultSdkAutoConstructList.getInstance();
        private String queryText;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryAssistantRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.queryCondition(model.queryCondition);
            this.queryText(model.queryText);
            this.sessionId(model.sessionId);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueryCondition.Builder> getQueryCondition() {
            List<QueryCondition.Builder> result = QueryConditionExpressionCopier.copyToBuilder(this.queryCondition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryCondition(Collection<QueryCondition.BuilderImpl> queryCondition) {
            this.queryCondition = QueryConditionExpressionCopier.copyFromBuilder(queryCondition);
        }

        @Override
        public final Builder queryCondition(Collection<QueryCondition> queryCondition) {
            this.queryCondition = QueryConditionExpressionCopier.copy(queryCondition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryCondition(QueryCondition ... queryCondition) {
            this.queryCondition(Arrays.asList(queryCondition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryCondition(Consumer<QueryCondition.Builder> ... queryCondition) {
            this.queryCondition(Stream.of(queryCondition).map(c -> (QueryCondition)((QueryCondition.Builder)QueryCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryAssistantRequest build() {
            return new QueryAssistantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryAssistantRequest> {
        public Builder assistantId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder queryCondition(Collection<QueryCondition> var1);

        public Builder queryCondition(QueryCondition ... var1);

        public Builder queryCondition(Consumer<QueryCondition.Builder> ... var1);

        public Builder queryText(String var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

