/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContentSummaryRequest extends QConnectRequest implements
        ToCopyableBuilder<GetContentSummaryRequest.Builder, GetContentSummaryRequest> {
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(GetContentSummaryRequest::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("contentId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(GetContentSummaryRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ID_FIELD,
            KNOWLEDGE_BASE_ID_FIELD));

    private final String contentId;

    private final String knowledgeBaseId;

    private GetContentSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.contentId = builder.contentId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentSummaryRequest)) {
            return false;
        }
        GetContentSummaryRequest other = (GetContentSummaryRequest) obj;
        return Objects.equals(contentId(), other.contentId()) && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContentSummaryRequest").add("ContentId", contentId())
                .add("KnowledgeBaseId", knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContentSummaryRequest, T> g) {
        return obj -> g.apply((GetContentSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetContentSummaryRequest> {
        /**
         * <p>
         * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String contentId;

        private String knowledgeBaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentSummaryRequest model) {
            super(model);
            contentId(model.contentId);
            knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContentSummaryRequest build() {
            return new GetContentSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
