/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyRecommendationsReceivedResponse extends QConnectResponse implements
        ToCopyableBuilder<NotifyRecommendationsReceivedResponse.Builder, NotifyRecommendationsReceivedResponse> {
    private static final SdkField<List<NotifyRecommendationsReceivedError>> ERRORS_FIELD = SdkField
            .<List<NotifyRecommendationsReceivedError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(NotifyRecommendationsReceivedResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotifyRecommendationsReceivedError> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotifyRecommendationsReceivedError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendationIds")
            .getter(getter(NotifyRecommendationsReceivedResponse::recommendationIds))
            .setter(setter(Builder::recommendationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            RECOMMENDATION_IDS_FIELD));

    private final List<NotifyRecommendationsReceivedError> errors;

    private final List<String> recommendationIds;

    private NotifyRecommendationsReceivedResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.recommendationIds = builder.recommendationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of recommendations that are causing errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The identifiers of recommendations that are causing errors.
     */
    public final List<NotifyRecommendationsReceivedError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendationIds() {
        return recommendationIds != null && !(recommendationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationIds} method.
     * </p>
     * 
     * @return The identifiers of the recommendations.
     */
    public final List<String> recommendationIds() {
        return recommendationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationIds() ? recommendationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyRecommendationsReceivedResponse)) {
            return false;
        }
        NotifyRecommendationsReceivedResponse other = (NotifyRecommendationsReceivedResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasRecommendationIds() == other.hasRecommendationIds()
                && Objects.equals(recommendationIds(), other.recommendationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyRecommendationsReceivedResponse").add("Errors", hasErrors() ? errors() : null)
                .add("RecommendationIds", hasRecommendationIds() ? recommendationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "recommendationIds":
            return Optional.ofNullable(clazz.cast(recommendationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyRecommendationsReceivedResponse, T> g) {
        return obj -> g.apply((NotifyRecommendationsReceivedResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, NotifyRecommendationsReceivedResponse> {
        /**
         * <p>
         * The identifiers of recommendations that are causing errors.
         * </p>
         * 
         * @param errors
         *        The identifiers of recommendations that are causing errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<NotifyRecommendationsReceivedError> errors);

        /**
         * <p>
         * The identifiers of recommendations that are causing errors.
         * </p>
         * 
         * @param errors
         *        The identifiers of recommendations that are causing errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(NotifyRecommendationsReceivedError... errors);

        /**
         * <p>
         * The identifiers of recommendations that are causing errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedError.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<NotifyRecommendationsReceivedError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<NotifyRecommendationsReceivedError>)
         */
        Builder errors(Consumer<NotifyRecommendationsReceivedError.Builder>... errors);

        /**
         * <p>
         * The identifiers of the recommendations.
         * </p>
         * 
         * @param recommendationIds
         *        The identifiers of the recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(Collection<String> recommendationIds);

        /**
         * <p>
         * The identifiers of the recommendations.
         * </p>
         * 
         * @param recommendationIds
         *        The identifiers of the recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(String... recommendationIds);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<NotifyRecommendationsReceivedError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyRecommendationsReceivedResponse model) {
            super(model);
            errors(model.errors);
            recommendationIds(model.recommendationIds);
        }

        public final List<NotifyRecommendationsReceivedError.Builder> getErrors() {
            List<NotifyRecommendationsReceivedError.Builder> result = NotifyRecommendationsReceivedErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<NotifyRecommendationsReceivedError.BuilderImpl> errors) {
            this.errors = NotifyRecommendationsReceivedErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<NotifyRecommendationsReceivedError> errors) {
            this.errors = NotifyRecommendationsReceivedErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(NotifyRecommendationsReceivedError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<NotifyRecommendationsReceivedError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> NotifyRecommendationsReceivedError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String... recommendationIds) {
            recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        @Override
        public NotifyRecommendationsReceivedResponse build() {
            return new NotifyRecommendationsReceivedResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
