/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateSessionRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::assistantId)).setter(UpdateSessionRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSessionRequest.getter(UpdateSessionRequest::description)).setter(UpdateSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateSessionRequest.getter(UpdateSessionRequest::sessionId)).setter(UpdateSessionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(UpdateSessionRequest.getter(UpdateSessionRequest::tagFilter)).setter(UpdateSessionRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, DESCRIPTION_FIELD, SESSION_ID_FIELD, TAG_FILTER_FIELD));
    private final String assistantId;
    private final String description;
    private final String sessionId;
    private final TagFilter tagFilter;

    private UpdateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.description = builder.description;
        this.sessionId = builder.sessionId;
        this.tagFilter = builder.tagFilter;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String description() {
        return this.description;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionRequest)) {
            return false;
        }
        UpdateSessionRequest other = (UpdateSessionRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.tagFilter(), other.tagFilter());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionRequest").add("AssistantId", (Object)this.assistantId()).add("Description", (Object)this.description()).add("SessionId", (Object)this.sessionId()).add("TagFilter", (Object)this.tagFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionRequest, T> g) {
        return obj -> g.apply((UpdateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String description;
        private String sessionId;
        private TagFilter tagFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.description(model.description);
            this.sessionId(model.sessionId);
            this.tagFilter(model.tagFilter);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionRequest build() {
            return new UpdateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionRequest> {
        public Builder assistantId(String var1);

        public Builder description(String var1);

        public Builder sessionId(String var1);

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

