/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportJobRequest extends QConnectRequest implements
        ToCopyableBuilder<StartImportJobRequest.Builder, StartImportJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ExternalSourceConfiguration> EXTERNAL_SOURCE_CONFIGURATION_FIELD = SdkField
            .<ExternalSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("externalSourceConfiguration")
            .getter(getter(StartImportJobRequest::externalSourceConfiguration))
            .setter(setter(Builder::externalSourceConfiguration))
            .constructor(ExternalSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceConfiguration")
                    .build()).build();

    private static final SdkField<String> IMPORT_JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importJobType").getter(getter(StartImportJobRequest::importJobTypeAsString))
            .setter(setter(Builder::importJobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobType").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(StartImportJobRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(StartImportJobRequest::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(StartImportJobRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EXTERNAL_SOURCE_CONFIGURATION_FIELD, IMPORT_JOB_TYPE_FIELD,
                    KNOWLEDGE_BASE_ID_FIELD, METADATA_FIELD, UPLOAD_ID_FIELD));

    private final String clientToken;

    private final ExternalSourceConfiguration externalSourceConfiguration;

    private final String importJobType;

    private final String knowledgeBaseId;

    private final Map<String, String> metadata;

    private final String uploadId;

    private StartImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.externalSourceConfiguration = builder.externalSourceConfiguration;
        this.importJobType = builder.importJobType;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.metadata = builder.metadata;
        this.uploadId = builder.uploadId;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration information of the external source that the resource data are imported from.
     * </p>
     * 
     * @return The configuration information of the external source that the resource data are imported from.
     */
    public final ExternalSourceConfiguration externalSourceConfiguration() {
        return externalSourceConfiguration;
    }

    /**
     * <p>
     * The type of the import job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importJobType}
     * will return {@link ImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importJobTypeAsString}.
     * </p>
     * 
     * @return The type of the import job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
     *         </p>
     *         </li>
     * @see ImportJobType
     */
    public final ImportJobType importJobType() {
        return ImportJobType.fromValue(importJobType);
    }

    /**
     * <p>
     * The type of the import job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importJobType}
     * will return {@link ImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importJobTypeAsString}.
     * </p>
     * 
     * @return The type of the import job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
     *         </p>
     *         </li>
     * @see ImportJobType
     */
    public final String importJobTypeAsString() {
        return importJobType;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, this should be a <code>QUICK_RESPONSES</code> type knowledge
     * base.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For importing Amazon Q in Connect quick responses, this should be a <code>QUICK_RESPONSES</code> type
     *         knowledge base.
     *         </p>
     *         </li>
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata fields of the imported Amazon Q in Connect resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The metadata fields of the imported Amazon Q in Connect resources.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * A pointer to the uploaded asset. This value is returned by <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.
     * </p>
     * 
     * @return A pointer to the uploaded asset. This value is returned by <a
     *         href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
     *         >StartContentUpload</a>.
     */
    public final String uploadId() {
        return uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(externalSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(importJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportJobRequest)) {
            return false;
        }
        StartImportJobRequest other = (StartImportJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(externalSourceConfiguration(), other.externalSourceConfiguration())
                && Objects.equals(importJobTypeAsString(), other.importJobTypeAsString())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(uploadId(), other.uploadId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportJobRequest").add("ClientToken", clientToken())
                .add("ExternalSourceConfiguration", externalSourceConfiguration()).add("ImportJobType", importJobTypeAsString())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Metadata", hasMetadata() ? metadata() : null)
                .add("UploadId", uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "externalSourceConfiguration":
            return Optional.ofNullable(clazz.cast(externalSourceConfiguration()));
        case "importJobType":
            return Optional.ofNullable(clazz.cast(importJobTypeAsString()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportJobRequest, T> g) {
        return obj -> g.apply((StartImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportJobRequest> {
        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param clientToken
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration information of the external source that the resource data are imported from.
         * </p>
         * 
         * @param externalSourceConfiguration
         *        The configuration information of the external source that the resource data are imported from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration);

        /**
         * <p>
         * The configuration information of the external source that the resource data are imported from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalSourceConfiguration(ExternalSourceConfiguration)}.
         * 
         * @param externalSourceConfiguration
         *        a consumer that will call methods on {@link ExternalSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalSourceConfiguration(ExternalSourceConfiguration)
         */
        default Builder externalSourceConfiguration(Consumer<ExternalSourceConfiguration.Builder> externalSourceConfiguration) {
            return externalSourceConfiguration(ExternalSourceConfiguration.builder().applyMutation(externalSourceConfiguration)
                    .build());
        }

        /**
         * <p>
         * The type of the import job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param importJobType
         *        The type of the import job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
         *        </p>
         *        </li>
         * @see ImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobType
         */
        Builder importJobType(String importJobType);

        /**
         * <p>
         * The type of the import job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param importJobType
         *        The type of the import job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.
         *        </p>
         *        </li>
         * @see ImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobType
         */
        Builder importJobType(ImportJobType importJobType);

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For importing Amazon Q in Connect quick responses, this should be a <code>QUICK_RESPONSES</code> type
         * knowledge base.
         * </p>
         * </li>
         * </ul>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the
         *        ARN.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For importing Amazon Q in Connect quick responses, this should be a <code>QUICK_RESPONSES</code> type
         *        knowledge base.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The metadata fields of the imported Amazon Q in Connect resources.
         * </p>
         * 
         * @param metadata
         *        The metadata fields of the imported Amazon Q in Connect resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * A pointer to the uploaded asset. This value is returned by <a
         * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         * >StartContentUpload</a>.
         * </p>
         * 
         * @param uploadId
         *        A pointer to the uploaded asset. This value is returned by <a
         *        href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         *        >StartContentUpload</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private ExternalSourceConfiguration externalSourceConfiguration;

        private String importJobType;

        private String knowledgeBaseId;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            externalSourceConfiguration(model.externalSourceConfiguration);
            importJobType(model.importJobType);
            knowledgeBaseId(model.knowledgeBaseId);
            metadata(model.metadata);
            uploadId(model.uploadId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ExternalSourceConfiguration.Builder getExternalSourceConfiguration() {
            return externalSourceConfiguration != null ? externalSourceConfiguration.toBuilder() : null;
        }

        public final void setExternalSourceConfiguration(ExternalSourceConfiguration.BuilderImpl externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration != null ? externalSourceConfiguration.build() : null;
        }

        @Override
        public final Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration;
            return this;
        }

        public final String getImportJobType() {
            return importJobType;
        }

        public final void setImportJobType(String importJobType) {
            this.importJobType = importJobType;
        }

        @Override
        public final Builder importJobType(String importJobType) {
            this.importJobType = importJobType;
            return this;
        }

        @Override
        public final Builder importJobType(ImportJobType importJobType) {
            this.importJobType(importJobType == null ? null : importJobType.toString());
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportJobRequest build() {
            return new StartImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
