/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QuickResponseContentProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickResponseContents
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickResponseContents> {
    private static final SdkField<QuickResponseContentProvider> MARKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("markdown").getter(QuickResponseContents.getter(QuickResponseContents::markdown)).setter(QuickResponseContents.setter(Builder::markdown)).constructor(QuickResponseContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("markdown").build()}).build();
    private static final SdkField<QuickResponseContentProvider> PLAIN_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("plainText").getter(QuickResponseContents.getter(QuickResponseContents::plainText)).setter(QuickResponseContents.setter(Builder::plainText)).constructor(QuickResponseContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKDOWN_FIELD, PLAIN_TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final QuickResponseContentProvider markdown;
    private final QuickResponseContentProvider plainText;

    private QuickResponseContents(BuilderImpl builder) {
        this.markdown = builder.markdown;
        this.plainText = builder.plainText;
    }

    public final QuickResponseContentProvider markdown() {
        return this.markdown;
    }

    public final QuickResponseContentProvider plainText() {
        return this.plainText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.markdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.plainText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseContents)) {
            return false;
        }
        QuickResponseContents other = (QuickResponseContents)obj;
        return Objects.equals(this.markdown(), other.markdown()) && Objects.equals(this.plainText(), other.plainText());
    }

    public final String toString() {
        return ToString.builder((String)"QuickResponseContents").add("Markdown", (Object)this.markdown()).add("PlainText", (Object)this.plainText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "markdown": {
                return Optional.ofNullable(clazz.cast(this.markdown()));
            }
            case "plainText": {
                return Optional.ofNullable(clazz.cast(this.plainText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseContents, T> g) {
        return obj -> g.apply((QuickResponseContents)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private QuickResponseContentProvider markdown;
        private QuickResponseContentProvider plainText;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseContents model) {
            this.markdown(model.markdown);
            this.plainText(model.plainText);
        }

        public final QuickResponseContentProvider.Builder getMarkdown() {
            return this.markdown != null ? this.markdown.toBuilder() : null;
        }

        public final void setMarkdown(QuickResponseContentProvider.BuilderImpl markdown) {
            this.markdown = markdown != null ? markdown.build() : null;
        }

        @Override
        public final Builder markdown(QuickResponseContentProvider markdown) {
            this.markdown = markdown;
            return this;
        }

        public final QuickResponseContentProvider.Builder getPlainText() {
            return this.plainText != null ? this.plainText.toBuilder() : null;
        }

        public final void setPlainText(QuickResponseContentProvider.BuilderImpl plainText) {
            this.plainText = plainText != null ? plainText.build() : null;
        }

        @Override
        public final Builder plainText(QuickResponseContentProvider plainText) {
            this.plainText = plainText;
            return this;
        }

        public QuickResponseContents build() {
            return new QuickResponseContents(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickResponseContents> {
        public Builder markdown(QuickResponseContentProvider var1);

        default public Builder markdown(Consumer<QuickResponseContentProvider.Builder> markdown) {
            return this.markdown((QuickResponseContentProvider)((QuickResponseContentProvider.Builder)QuickResponseContentProvider.builder().applyMutation(markdown)).build());
        }

        public Builder plainText(QuickResponseContentProvider var1);

        default public Builder plainText(Consumer<QuickResponseContentProvider.Builder> plainText) {
            return this.plainText((QuickResponseContentProvider)((QuickResponseContentProvider.Builder)QuickResponseContentProvider.builder().applyMutation(plainText)).build());
        }
    }
}

