/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <note>
 * <p>
 * <b>Powered by Amazon Bedrock</b>: Amazon Web Services implements <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/abuse-detection.html">automated abuse detection</a>.
 * Because Amazon Q in Connect is built on Amazon Bedrock, users can take full advantage of the controls implemented in
 * Amazon Bedrock to enforce safety, security, and the responsible use of artificial intelligence (AI).
 * </p>
 * </note>
 * <p>
 * Amazon Q in Connect is a generative AI customer service assistant. It is an LLM-enhanced evolution of Amazon Connect
 * Wisdom that delivers real-time recommendations to help contact center agents resolve customer issues quickly and
 * accurately.
 * </p>
 * <p>
 * Amazon Q in Connect automatically detects customer intent during calls and chats using conversational analytics and
 * natural language understanding (NLU). It then provides agents with immediate, real-time generative responses and
 * suggested actions, and links to relevant documents and articles. Agents can also query Amazon Q in Connect directly
 * using natural language or keywords to answer customer requests.
 * </p>
 * <p>
 * Use the Amazon Q in Connect APIs to create an assistant and a knowledge base, for example, or manage content by
 * uploading custom files.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-q-connect.html">Use
 * Amazon Q in Connect for generative AI powered agent assistance in real-time</a> in the <i>Amazon Connect
 * Administrator Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.qconnect;