/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationSummary;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationSummaryListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContentAssociationsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, ListContentAssociationsResponse> {
    private static final SdkField<List<ContentAssociationSummary>> CONTENT_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contentAssociationSummaries").getter(ListContentAssociationsResponse.getter(ListContentAssociationsResponse::contentAssociationSummaries)).setter(ListContentAssociationsResponse.setter(Builder::contentAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContentAssociationsResponse.getter(ListContentAssociationsResponse::nextToken)).setter(ListContentAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ContentAssociationSummary> contentAssociationSummaries;
    private final String nextToken;

    private ListContentAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.contentAssociationSummaries = builder.contentAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContentAssociationSummaries() {
        return this.contentAssociationSummaries != null && !(this.contentAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<ContentAssociationSummary> contentAssociationSummaries() {
        return this.contentAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentAssociationSummaries() ? this.contentAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContentAssociationsResponse)) {
            return false;
        }
        ListContentAssociationsResponse other = (ListContentAssociationsResponse)((Object)obj);
        return this.hasContentAssociationSummaries() == other.hasContentAssociationSummaries() && Objects.equals(this.contentAssociationSummaries(), other.contentAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContentAssociationsResponse").add("ContentAssociationSummaries", this.hasContentAssociationSummaries() ? this.contentAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.contentAssociationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContentAssociationsResponse, T> g) {
        return obj -> g.apply((ListContentAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<ContentAssociationSummary> contentAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContentAssociationsResponse model) {
            super(model);
            this.contentAssociationSummaries(model.contentAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ContentAssociationSummary.Builder> getContentAssociationSummaries() {
            List<ContentAssociationSummary.Builder> result = ContentAssociationSummaryListCopier.copyToBuilder(this.contentAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentAssociationSummaries(Collection<ContentAssociationSummary.BuilderImpl> contentAssociationSummaries) {
            this.contentAssociationSummaries = ContentAssociationSummaryListCopier.copyFromBuilder(contentAssociationSummaries);
        }

        @Override
        public final Builder contentAssociationSummaries(Collection<ContentAssociationSummary> contentAssociationSummaries) {
            this.contentAssociationSummaries = ContentAssociationSummaryListCopier.copy(contentAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentAssociationSummaries(ContentAssociationSummary ... contentAssociationSummaries) {
            this.contentAssociationSummaries(Arrays.asList(contentAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentAssociationSummaries(Consumer<ContentAssociationSummary.Builder> ... contentAssociationSummaries) {
            this.contentAssociationSummaries(Stream.of(contentAssociationSummaries).map(c -> (ContentAssociationSummary)((ContentAssociationSummary.Builder)ContentAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContentAssociationsResponse build() {
            return new ListContentAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContentAssociationsResponse> {
        public Builder contentAssociationSummaries(Collection<ContentAssociationSummary> var1);

        public Builder contentAssociationSummaries(ContentAssociationSummary ... var1);

        public Builder contentAssociationSummaries(Consumer<ContentAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

