/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.qconnect.internal.QConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qconnect.model.AccessDeniedException;
import software.amazon.awssdk.services.qconnect.model.ConflictException;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.qconnect.model.GetImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.GetImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.qconnect.model.GetSessionRequest;
import software.amazon.awssdk.services.qconnect.model.GetSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.qconnect.model.PreconditionFailedException;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qconnect.model.QConnectException;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.RequestTimeoutException;
import software.amazon.awssdk.services.qconnect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qconnect.model.SearchContentRequest;
import software.amazon.awssdk.services.qconnect.model.SearchContentResponse;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse;
import software.amazon.awssdk.services.qconnect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadResponse;
import software.amazon.awssdk.services.qconnect.model.StartImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.StartImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.ThrottlingException;
import software.amazon.awssdk.services.qconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.qconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateContentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateContentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ValidationException;
import software.amazon.awssdk.services.qconnect.transform.CreateAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiAgentVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAiPromptVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.CreateSessionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiAgentVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAiPromptVersionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.DeleteQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAssistantAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentAssociationRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetContentSummaryRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetKnowledgeBaseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiAgentVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiAgentsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiPromptVersionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAiPromptsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAssistantAssociationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListAssistantsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListContentAssociationsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListContentsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListImportJobsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListKnowledgeBasesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListQuickResponsesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.NotifyRecommendationsReceivedRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.QueryAssistantRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.RemoveAssistantAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.RemoveKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchQuickResponsesRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.SearchSessionsRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.StartContentUploadRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.StartImportJobRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAiPromptRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateAssistantAiAgentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateContentRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateKnowledgeBaseTemplateUriRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateQuickResponseRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateSessionDataRequestMarshaller;
import software.amazon.awssdk.services.qconnect.transform.UpdateSessionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link QConnectAsyncClient}.
 *
 * @see QConnectAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQConnectAsyncClient implements QConnectAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultQConnectAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQConnectAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param createAiAgentRequest
     * @return A Java Future containing the result of the CreateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAiAgentResponse> createAIAgent(CreateAiAgentRequest createAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAiAgentRequest, CreateAiAgentResponse>()
                            .withOperationName("CreateAIAgent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAiAgentRequest));
            CompletableFuture<CreateAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     *
     * @param createAiAgentVersionRequest
     * @return A Java Future containing the result of the CreateAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAiAgentVersionResponse> createAIAgentVersion(
            CreateAiAgentVersionRequest createAiAgentVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiAgentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiAgentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIAgentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAiAgentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAiAgentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAiAgentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAiAgentVersionRequest, CreateAiAgentVersionResponse>()
                            .withOperationName("CreateAIAgentVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAiAgentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAiAgentVersionRequest));
            CompletableFuture<CreateAiAgentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param createAiPromptRequest
     * @return A Java Future containing the result of the CreateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAiPromptResponse> createAIPrompt(CreateAiPromptRequest createAiPromptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIPrompt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAiPromptResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAiPromptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAiPromptRequest, CreateAiPromptResponse>()
                            .withOperationName("CreateAIPrompt").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAiPromptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAiPromptRequest));
            CompletableFuture<CreateAiPromptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param createAiPromptVersionRequest
     * @return A Java Future containing the result of the CreateAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAiPromptVersionResponse> createAIPromptVersion(
            CreateAiPromptVersionRequest createAiPromptVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAiPromptVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAiPromptVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAIPromptVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAiPromptVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAiPromptVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAiPromptVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAiPromptVersionRequest, CreateAiPromptVersionResponse>()
                            .withOperationName("CreateAIPromptVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAiPromptVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAiPromptVersionRequest));
            CompletableFuture<CreateAiPromptVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     *
     * @param createAssistantRequest
     * @return A Java Future containing the result of the CreateAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssistantResponse> createAssistant(CreateAssistantRequest createAssistantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssistantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssistant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssistantResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssistantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssistantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssistantRequest, CreateAssistantResponse>()
                            .withOperationName("CreateAssistant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssistantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAssistantRequest));
            CompletableFuture<CreateAssistantResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     *
     * @param createAssistantAssociationRequest
     * @return A Java Future containing the result of the CreateAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssistantAssociationResponse> createAssistantAssociation(
            CreateAssistantAssociationRequest createAssistantAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssistantAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssistantAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssistantAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssistantAssociationRequest, CreateAssistantAssociationResponse>()
                            .withOperationName("CreateAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssistantAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAssistantAssociationRequest));
            CompletableFuture<CreateAssistantAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     *
     * @param createContentRequest
     * @return A Java Future containing the result of the CreateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContentResponse> createContent(CreateContentRequest createContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContentRequest, CreateContentResponse>()
                            .withOperationName("CreateContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContentRequest));
            CompletableFuture<CreateContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createContentAssociationRequest
     * @return A Java Future containing the result of the CreateContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContentAssociationResponse> createContentAssociation(
            CreateContentAssociationRequest createContentAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContentAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContentAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContentAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContentAssociationRequest, CreateContentAssociationResponse>()
                            .withOperationName("CreateContentAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContentAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContentAssociationRequest));
            CompletableFuture<CreateContentAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note>
     *
     * @param createKnowledgeBaseRequest
     * @return A Java Future containing the result of the CreateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKnowledgeBaseResponse> createKnowledgeBase(
            CreateKnowledgeBaseRequest createKnowledgeBaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKnowledgeBase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateKnowledgeBaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateKnowledgeBaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse>()
                            .withOperationName("CreateKnowledgeBase").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateKnowledgeBaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createKnowledgeBaseRequest));
            CompletableFuture<CreateKnowledgeBaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     *
     * @param createQuickResponseRequest
     * @return A Java Future containing the result of the CreateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQuickResponseResponse> createQuickResponse(
            CreateQuickResponseRequest createQuickResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQuickResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateQuickResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateQuickResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateQuickResponseRequest, CreateQuickResponseResponse>()
                            .withOperationName("CreateQuickResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateQuickResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createQuickResponseRequest));
            CompletableFuture<CreateQuickResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param createSessionRequest
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSessionResponse> createSession(CreateSessionRequest createSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSessionRequest, CreateSessionResponse>()
                            .withOperationName("CreateSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSessionRequest));
            CompletableFuture<CreateSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param deleteAiAgentRequest
     * @return A Java Future containing the result of the DeleteAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAiAgentResponse> deleteAIAgent(DeleteAiAgentRequest deleteAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAiAgentRequest, DeleteAiAgentResponse>()
                            .withOperationName("DeleteAIAgent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAiAgentRequest));
            CompletableFuture<DeleteAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     * @return A Java Future containing the result of the DeleteAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAiAgentVersionResponse> deleteAIAgentVersion(
            DeleteAiAgentVersionRequest deleteAiAgentVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiAgentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiAgentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIAgentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAiAgentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAiAgentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAiAgentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAiAgentVersionRequest, DeleteAiAgentVersionResponse>()
                            .withOperationName("DeleteAIAgentVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAiAgentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAiAgentVersionRequest));
            CompletableFuture<DeleteAiAgentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param deleteAiPromptRequest
     * @return A Java Future containing the result of the DeleteAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAiPromptResponse> deleteAIPrompt(DeleteAiPromptRequest deleteAiPromptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIPrompt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAiPromptResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAiPromptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAiPromptRequest, DeleteAiPromptResponse>()
                            .withOperationName("DeleteAIPrompt").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAiPromptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAiPromptRequest));
            CompletableFuture<DeleteAiPromptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     * @return A Java Future containing the result of the DeleteAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAiPromptVersionResponse> deleteAIPromptVersion(
            DeleteAiPromptVersionRequest deleteAiPromptVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAiPromptVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAiPromptVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAIPromptVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAiPromptVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAiPromptVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAiPromptVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAiPromptVersionRequest, DeleteAiPromptVersionResponse>()
                            .withOperationName("DeleteAIPromptVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAiPromptVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAiPromptVersionRequest));
            CompletableFuture<DeleteAiPromptVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     *
     * @param deleteAssistantRequest
     * @return A Java Future containing the result of the DeleteAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssistantResponse> deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssistantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssistant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssistantResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssistantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssistantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssistantRequest, DeleteAssistantResponse>()
                            .withOperationName("DeleteAssistant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssistantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssistantRequest));
            CompletableFuture<DeleteAssistantResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     * @return A Java Future containing the result of the DeleteAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssistantAssociationResponse> deleteAssistantAssociation(
            DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssistantAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssistantAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssistantAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssistantAssociationRequest, DeleteAssistantAssociationResponse>()
                            .withOperationName("DeleteAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssistantAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssistantAssociationRequest));
            CompletableFuture<DeleteAssistantAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     *
     * @param deleteContentRequest
     * @return A Java Future containing the result of the DeleteContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContentResponse> deleteContent(DeleteContentRequest deleteContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContentRequest, DeleteContentResponse>()
                            .withOperationName("DeleteContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContentRequest));
            CompletableFuture<DeleteContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteContentAssociationRequest
     * @return A Java Future containing the result of the DeleteContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContentAssociationResponse> deleteContentAssociation(
            DeleteContentAssociationRequest deleteContentAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContentAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContentAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContentAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContentAssociationRequest, DeleteContentAssociationResponse>()
                            .withOperationName("DeleteContentAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContentAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContentAssociationRequest));
            CompletableFuture<DeleteContentAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     *
     * @param deleteImportJobRequest
     * @return A Java Future containing the result of the DeleteImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImportJobResponse> deleteImportJob(DeleteImportJobRequest deleteImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImportJobRequest, DeleteImportJobResponse>()
                            .withOperationName("DeleteImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImportJobRequest));
            CompletableFuture<DeleteImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteKnowledgeBaseRequest
     * @return A Java Future containing the result of the DeleteKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(
            DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKnowledgeBase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteKnowledgeBaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKnowledgeBaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse>()
                            .withOperationName("DeleteKnowledgeBase").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteKnowledgeBaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteKnowledgeBaseRequest));
            CompletableFuture<DeleteKnowledgeBaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     *
     * @param deleteQuickResponseRequest
     * @return A Java Future containing the result of the DeleteQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQuickResponseResponse> deleteQuickResponse(
            DeleteQuickResponseRequest deleteQuickResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQuickResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteQuickResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteQuickResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQuickResponseRequest, DeleteQuickResponseResponse>()
                            .withOperationName("DeleteQuickResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQuickResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteQuickResponseRequest));
            CompletableFuture<DeleteQuickResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param getAiAgentRequest
     * @return A Java Future containing the result of the GetAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAiAgentResponse> getAIAgent(GetAiAgentRequest getAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAiAgentRequest, GetAiAgentResponse>().withOperationName("GetAIAgent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAiAgentRequest));
            CompletableFuture<GetAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param getAiPromptRequest
     * @return A Java Future containing the result of the GetAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAiPromptResponse> getAIPrompt(GetAiPromptRequest getAiPromptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAIPrompt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAiPromptResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAiPromptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAiPromptRequest, GetAiPromptResponse>()
                            .withOperationName("GetAIPrompt").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAiPromptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAiPromptRequest));
            CompletableFuture<GetAiPromptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     *
     * @param getAssistantRequest
     * @return A Java Future containing the result of the GetAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssistantResponse> getAssistant(GetAssistantRequest getAssistantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssistantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssistant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssistantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAssistantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssistantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssistantRequest, GetAssistantResponse>()
                            .withOperationName("GetAssistant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssistantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAssistantRequest));
            CompletableFuture<GetAssistantResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     *
     * @param getAssistantAssociationRequest
     * @return A Java Future containing the result of the GetAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssistantAssociationResponse> getAssistantAssociation(
            GetAssistantAssociationRequest getAssistantAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssistantAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssistantAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssistantAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssistantAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssistantAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssistantAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssistantAssociationRequest, GetAssistantAssociationResponse>()
                            .withOperationName("GetAssistantAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssistantAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAssistantAssociationRequest));
            CompletableFuture<GetAssistantAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     *
     * @param getContentRequest
     * @return A Java Future containing the result of the GetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetContentResponse> getContent(GetContentRequest getContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContentRequest, GetContentResponse>().withOperationName("GetContent")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContentRequest));
            CompletableFuture<GetContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getContentAssociationRequest
     * @return A Java Future containing the result of the GetContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContentAssociationResponse> getContentAssociation(
            GetContentAssociationRequest getContentAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContentAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContentAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContentAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContentAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContentAssociationRequest, GetContentAssociationResponse>()
                            .withOperationName("GetContentAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContentAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContentAssociationRequest));
            CompletableFuture<GetContentAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     *
     * @param getContentSummaryRequest
     * @return A Java Future containing the result of the GetContentSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContentSummaryResponse> getContentSummary(GetContentSummaryRequest getContentSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContentSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContentSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContentSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContentSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContentSummaryRequest, GetContentSummaryResponse>()
                            .withOperationName("GetContentSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContentSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContentSummaryRequest));
            CompletableFuture<GetContentSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     *
     * @param getImportJobRequest
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                            .withOperationName("GetImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImportJobRequest));
            CompletableFuture<GetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     *
     * @param getKnowledgeBaseRequest
     * @return A Java Future containing the result of the GetKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKnowledgeBaseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKnowledgeBaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKnowledgeBase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKnowledgeBaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetKnowledgeBaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKnowledgeBaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse>()
                            .withOperationName("GetKnowledgeBase").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetKnowledgeBaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getKnowledgeBaseRequest));
            CompletableFuture<GetKnowledgeBaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     *
     * @param getQuickResponseRequest
     * @return A Java Future containing the result of the GetQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetQuickResponseResponse> getQuickResponse(GetQuickResponseRequest getQuickResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQuickResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQuickResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQuickResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQuickResponseRequest, GetQuickResponseResponse>()
                            .withOperationName("GetQuickResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQuickResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQuickResponseRequest));
            CompletableFuture<GetQuickResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     *
     * @param getRecommendationsRequest
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecommendationsResponse> getRecommendations(GetRecommendationsRequest getRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecommendationsRequest, GetRecommendationsResponse>()
                            .withOperationName("GetRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRecommendationsRequest));
            CompletableFuture<GetRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>().withOperationName("GetSession")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSessionRequest));
            CompletableFuture<GetSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return A Java Future containing the result of the ListAIAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAiAgentVersionsResponse> listAIAgentVersions(
            ListAiAgentVersionsRequest listAiAgentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiAgentVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiAgentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIAgentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAiAgentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAiAgentVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAiAgentVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAiAgentVersionsRequest, ListAiAgentVersionsResponse>()
                            .withOperationName("ListAIAgentVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAiAgentVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAiAgentVersionsRequest));
            CompletableFuture<ListAiAgentVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     *
     * @param listAiAgentsRequest
     * @return A Java Future containing the result of the ListAIAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAiAgentsResponse> listAIAgents(ListAiAgentsRequest listAiAgentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiAgentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIAgents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAiAgentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAiAgentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAiAgentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAiAgentsRequest, ListAiAgentsResponse>()
                            .withOperationName("ListAIAgents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAiAgentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAiAgentsRequest));
            CompletableFuture<ListAiAgentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return A Java Future containing the result of the ListAIPromptVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAiPromptVersionsResponse> listAIPromptVersions(
            ListAiPromptVersionsRequest listAiPromptVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiPromptVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiPromptVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIPromptVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAiPromptVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAiPromptVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAiPromptVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAiPromptVersionsRequest, ListAiPromptVersionsResponse>()
                            .withOperationName("ListAIPromptVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAiPromptVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAiPromptVersionsRequest));
            CompletableFuture<ListAiPromptVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     *
     * @param listAiPromptsRequest
     * @return A Java Future containing the result of the ListAIPrompts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAiPromptsResponse> listAIPrompts(ListAiPromptsRequest listAiPromptsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAiPromptsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAiPromptsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAIPrompts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAiPromptsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAiPromptsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAiPromptsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAiPromptsRequest, ListAiPromptsResponse>()
                            .withOperationName("ListAIPrompts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAiPromptsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAiPromptsRequest));
            CompletableFuture<ListAiPromptsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return A Java Future containing the result of the ListAssistantAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssistantAssociationsResponse> listAssistantAssociations(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssistantAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssistantAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssistantAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssistantAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssistantAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssistantAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssistantAssociationsRequest, ListAssistantAssociationsResponse>()
                            .withOperationName("ListAssistantAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssistantAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssistantAssociationsRequest));
            CompletableFuture<ListAssistantAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     *
     * @param listAssistantsRequest
     * @return A Java Future containing the result of the ListAssistants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssistantsResponse> listAssistants(ListAssistantsRequest listAssistantsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssistantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssistantsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssistants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssistantsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssistantsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssistantsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssistantsRequest, ListAssistantsResponse>()
                            .withOperationName("ListAssistants").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssistantsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssistantsRequest));
            CompletableFuture<ListAssistantsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return A Java Future containing the result of the ListContentAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContentAssociationsResponse> listContentAssociations(
            ListContentAssociationsRequest listContentAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContentAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContentAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContentAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContentAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContentAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContentAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContentAssociationsRequest, ListContentAssociationsResponse>()
                            .withOperationName("ListContentAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContentAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContentAssociationsRequest));
            CompletableFuture<ListContentAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     *
     * @param listContentsRequest
     * @return A Java Future containing the result of the ListContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListContentsResponse> listContents(ListContentsRequest listContentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListContentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListContentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContentsRequest, ListContentsResponse>()
                            .withOperationName("ListContents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContentsRequest));
            CompletableFuture<ListContentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportJobsResponse> listImportJobs(ListImportJobsRequest listImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportJobsRequest, ListImportJobsResponse>()
                            .withOperationName("ListImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImportJobsRequest));
            CompletableFuture<ListImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A Java Future containing the result of the ListKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKnowledgeBasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKnowledgeBasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKnowledgeBases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListKnowledgeBasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListKnowledgeBasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListKnowledgeBasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse>()
                            .withOperationName("ListKnowledgeBases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListKnowledgeBasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listKnowledgeBasesRequest));
            CompletableFuture<ListKnowledgeBasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return A Java Future containing the result of the ListQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQuickResponsesResponse> listQuickResponses(ListQuickResponsesRequest listQuickResponsesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQuickResponsesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQuickResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQuickResponses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQuickResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQuickResponsesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListQuickResponsesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQuickResponsesRequest, ListQuickResponsesResponse>()
                            .withOperationName("ListQuickResponses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQuickResponsesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listQuickResponsesRequest));
            CompletableFuture<ListQuickResponsesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     * @return A Java Future containing the result of the NotifyRecommendationsReceived operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<NotifyRecommendationsReceivedResponse> notifyRecommendationsReceived(
            NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(notifyRecommendationsReceivedRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                notifyRecommendationsReceivedRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "NotifyRecommendationsReceived");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<NotifyRecommendationsReceivedResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, NotifyRecommendationsReceivedResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<NotifyRecommendationsReceivedResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<NotifyRecommendationsReceivedRequest, NotifyRecommendationsReceivedResponse>()
                            .withOperationName("NotifyRecommendationsReceived").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new NotifyRecommendationsReceivedRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(notifyRecommendationsReceivedRequest));
            CompletableFuture<NotifyRecommendationsReceivedResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutFeedbackRequest, PutFeedbackResponse>()
                            .withOperationName("PutFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putFeedbackRequest));
            CompletableFuture<PutFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     *
     * @param queryAssistantRequest
     * @return A Java Future containing the result of the QueryAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<QueryAssistantResponse> queryAssistant(QueryAssistantRequest queryAssistantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(queryAssistantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, queryAssistantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "QueryAssistant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<QueryAssistantResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, QueryAssistantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<QueryAssistantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<QueryAssistantRequest, QueryAssistantResponse>()
                            .withOperationName("QueryAssistant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new QueryAssistantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(queryAssistantRequest));
            CompletableFuture<QueryAssistantResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     * @return A Java Future containing the result of the RemoveAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveAssistantAiAgentResponse> removeAssistantAIAgent(
            RemoveAssistantAiAgentRequest removeAssistantAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeAssistantAiAgentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAssistantAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAssistantAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveAssistantAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveAssistantAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveAssistantAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveAssistantAiAgentRequest, RemoveAssistantAiAgentResponse>()
                            .withOperationName("RemoveAssistantAIAgent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveAssistantAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeAssistantAiAgentRequest));
            CompletableFuture<RemoveAssistantAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     * @return A Java Future containing the result of the RemoveKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveKnowledgeBaseTemplateUriResponse> removeKnowledgeBaseTemplateUri(
            RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeKnowledgeBaseTemplateUriRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveKnowledgeBaseTemplateUri");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveKnowledgeBaseTemplateUriResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveKnowledgeBaseTemplateUriResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveKnowledgeBaseTemplateUriResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveKnowledgeBaseTemplateUriRequest, RemoveKnowledgeBaseTemplateUriResponse>()
                            .withOperationName("RemoveKnowledgeBaseTemplateUri").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveKnowledgeBaseTemplateUriRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeKnowledgeBaseTemplateUriRequest));
            CompletableFuture<RemoveKnowledgeBaseTemplateUriResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     *
     * @param searchContentRequest
     * @return A Java Future containing the result of the SearchContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchContentResponse> searchContent(SearchContentRequest searchContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchContentRequest, SearchContentResponse>()
                            .withOperationName("SearchContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchContentRequest));
            CompletableFuture<SearchContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return A Java Future containing the result of the SearchQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchQuickResponsesResponse> searchQuickResponses(
            SearchQuickResponsesRequest searchQuickResponsesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchQuickResponsesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchQuickResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchQuickResponses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchQuickResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchQuickResponsesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchQuickResponsesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchQuickResponsesRequest, SearchQuickResponsesResponse>()
                            .withOperationName("SearchQuickResponses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchQuickResponsesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchQuickResponsesRequest));
            CompletableFuture<SearchQuickResponsesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     *
     * @param searchSessionsRequest
     * @return A Java Future containing the result of the SearchSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchSessionsResponse> searchSessions(SearchSessionsRequest searchSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchSessionsRequest, SearchSessionsResponse>()
                            .withOperationName("SearchSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchSessionsRequest));
            CompletableFuture<SearchSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     *
     * @param startContentUploadRequest
     * @return A Java Future containing the result of the StartContentUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartContentUploadResponse> startContentUpload(StartContentUploadRequest startContentUploadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startContentUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startContentUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartContentUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartContentUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartContentUploadResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartContentUploadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartContentUploadRequest, StartContentUploadResponse>()
                            .withOperationName("StartContentUpload").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartContentUploadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startContentUploadRequest));
            CompletableFuture<StartContentUploadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param startImportJobRequest
     * @return A Java Future containing the result of the StartImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartImportJobResponse> startImportJob(StartImportJobRequest startImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImportJobRequest, StartImportJobResponse>()
                            .withOperationName("StartImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startImportJobRequest));
            CompletableFuture<StartImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException Amazon Q in Connect throws this exception if you have too many tags in your tag
     *         set.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     *
     * @param updateAiAgentRequest
     * @return A Java Future containing the result of the UpdateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAiAgentResponse> updateAIAgent(UpdateAiAgentRequest updateAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAiAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAiAgentRequest, UpdateAiAgentResponse>()
                            .withOperationName("UpdateAIAgent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAiAgentRequest));
            CompletableFuture<UpdateAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     *
     * @param updateAiPromptRequest
     * @return A Java Future containing the result of the UpdateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAiPromptResponse> updateAIPrompt(UpdateAiPromptRequest updateAiPromptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAiPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAiPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAIPrompt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAiPromptResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAiPromptResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAiPromptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAiPromptRequest, UpdateAiPromptResponse>()
                            .withOperationName("UpdateAIPrompt").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAiPromptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAiPromptRequest));
            CompletableFuture<UpdateAiPromptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     * @return A Java Future containing the result of the UpdateAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssistantAiAgentResponse> updateAssistantAIAgent(
            UpdateAssistantAiAgentRequest updateAssistantAiAgentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssistantAiAgentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssistantAiAgentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssistantAIAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssistantAiAgentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssistantAiAgentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssistantAiAgentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssistantAiAgentRequest, UpdateAssistantAiAgentResponse>()
                            .withOperationName("UpdateAssistantAIAgent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssistantAiAgentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssistantAiAgentRequest));
            CompletableFuture<UpdateAssistantAiAgentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     *
     * @param updateContentRequest
     * @return A Java Future containing the result of the UpdateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContentResponse> updateContent(UpdateContentRequest updateContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateContentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContentRequest, UpdateContentResponse>()
                            .withOperationName("UpdateContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateContentRequest));
            CompletableFuture<UpdateContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     * @return A Java Future containing the result of the UpdateKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateKnowledgeBaseTemplateUriResponse> updateKnowledgeBaseTemplateUri(
            UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateKnowledgeBaseTemplateUriRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateKnowledgeBaseTemplateUriRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateKnowledgeBaseTemplateUri");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateKnowledgeBaseTemplateUriResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateKnowledgeBaseTemplateUriResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateKnowledgeBaseTemplateUriResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateKnowledgeBaseTemplateUriRequest, UpdateKnowledgeBaseTemplateUriResponse>()
                            .withOperationName("UpdateKnowledgeBaseTemplateUri").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateKnowledgeBaseTemplateUriRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateKnowledgeBaseTemplateUriRequest));
            CompletableFuture<UpdateKnowledgeBaseTemplateUriResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     *
     * @param updateQuickResponseRequest
     * @return A Java Future containing the result of the UpdateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQuickResponseResponse> updateQuickResponse(
            UpdateQuickResponseRequest updateQuickResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQuickResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQuickResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQuickResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQuickResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateQuickResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateQuickResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQuickResponseRequest, UpdateQuickResponseResponse>()
                            .withOperationName("UpdateQuickResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQuickResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateQuickResponseRequest));
            CompletableFuture<UpdateQuickResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param updateSessionRequest
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSessionResponse> updateSession(UpdateSessionRequest updateSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSessionRequest, UpdateSessionResponse>()
                            .withOperationName("UpdateSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSessionRequest));
            CompletableFuture<UpdateSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     *
     * @param updateSessionDataRequest
     * @return A Java Future containing the result of the UpdateSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSessionDataResponse> updateSessionData(UpdateSessionDataRequest updateSessionDataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSessionData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSessionDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSessionDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSessionDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSessionDataRequest, UpdateSessionDataResponse>()
                            .withOperationName("UpdateSessionData").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSessionDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSessionDataRequest));
            CompletableFuture<UpdateSessionDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final QConnectServiceClientConfiguration serviceClientConfiguration() {
        return new QConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(QConnectException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestTimeoutException")
                                .exceptionBuilderSupplier(RequestTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        QConnectServiceClientConfigurationBuilder serviceConfigBuilder = new QConnectServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
