/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.qconnect.model.GetImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.GetImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.qconnect.model.GetSessionRequest;
import software.amazon.awssdk.services.qconnect.model.GetSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.SearchContentRequest;
import software.amazon.awssdk.services.qconnect.model.SearchContentResponse;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadResponse;
import software.amazon.awssdk.services.qconnect.model.StartImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.StartImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateContentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateContentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionResponse;
import software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListAssistantsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListContentsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListImportJobsPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesPublisher;
import software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesPublisher;
import software.amazon.awssdk.services.qconnect.paginators.QueryAssistantPublisher;
import software.amazon.awssdk.services.qconnect.paginators.SearchContentPublisher;
import software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesPublisher;
import software.amazon.awssdk.services.qconnect.paginators.SearchSessionsPublisher;

/**
 * Service client for accessing Amazon Q Connect asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Q_Connect.html">Amazon Q
 * actions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Q_Connect.html">Amazon Q data
 * types</a>
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * <b>Powered by Amazon Bedrock</b>: Amazon Web Services implements <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/abuse-detection.html">automated abuse detection</a>.
 * Because Amazon Q in Connect is built on Amazon Bedrock, users can take full advantage of the controls implemented in
 * Amazon Bedrock to enforce safety, security, and the responsible use of artificial intelligence (AI).
 * </p>
 * </note>
 * <p>
 * Amazon Q in Connect is a generative AI customer service assistant. It is an LLM-enhanced evolution of Amazon Connect
 * Wisdom that delivers real-time recommendations to help contact center agents resolve customer issues quickly and
 * accurately.
 * </p>
 * <p>
 * Amazon Q in Connect automatically detects customer intent during calls and chats using conversational analytics and
 * natural language understanding (NLU). It then provides agents with immediate, real-time generative responses and
 * suggested actions, and links to relevant documents and articles. Agents can also query Amazon Q in Connect directly
 * using natural language or keywords to answer customer requests.
 * </p>
 * <p>
 * Use the Amazon Q in Connect APIs to create an assistant and a knowledge base, for example, or manage content by
 * uploading custom files.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-q-connect.html">Use
 * Amazon Q in Connect for generative AI powered agent assistance in real-time</a> in the <i>Amazon Connect
 * Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QConnectAsyncClient extends AwsClient {
    String SERVICE_NAME = "wisdom";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wisdom";

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param createAiAgentRequest
     * @return A Java Future containing the result of the CreateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAiAgentResponse> createAIAgent(CreateAiAgentRequest createAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAiAgentRequest#builder()}
     * </p>
     *
     * @param createAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAiAgentResponse> createAIAgent(Consumer<CreateAiAgentRequest.Builder> createAiAgentRequest) {
        return createAIAgent(CreateAiAgentRequest.builder().applyMutation(createAiAgentRequest).build());
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     *
     * @param createAiAgentVersionRequest
     * @return A Java Future containing the result of the CreateAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAiAgentVersionResponse> createAIAgentVersion(
            CreateAiAgentVersionRequest createAiAgentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiAgentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAiAgentVersionRequest#builder()}
     * </p>
     *
     * @param createAiAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAiAgentVersionResponse> createAIAgentVersion(
            Consumer<CreateAiAgentVersionRequest.Builder> createAiAgentVersionRequest) {
        return createAIAgentVersion(CreateAiAgentVersionRequest.builder().applyMutation(createAiAgentVersionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param createAiPromptRequest
     * @return A Java Future containing the result of the CreateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAiPromptResponse> createAIPrompt(CreateAiPromptRequest createAiPromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAiPromptRequest#builder()}
     * </p>
     *
     * @param createAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAiPromptResponse> createAIPrompt(Consumer<CreateAiPromptRequest.Builder> createAiPromptRequest) {
        return createAIPrompt(CreateAiPromptRequest.builder().applyMutation(createAiPromptRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param createAiPromptVersionRequest
     * @return A Java Future containing the result of the CreateAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAiPromptVersionResponse> createAIPromptVersion(
            CreateAiPromptVersionRequest createAiPromptVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiPromptVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAiPromptVersionRequest#builder()}
     * </p>
     *
     * @param createAiPromptVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAiPromptVersionResponse> createAIPromptVersion(
            Consumer<CreateAiPromptVersionRequest.Builder> createAiPromptVersionRequest) {
        return createAIPromptVersion(CreateAiPromptVersionRequest.builder().applyMutation(createAiPromptVersionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     *
     * @param createAssistantRequest
     * @return A Java Future containing the result of the CreateAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssistantResponse> createAssistant(CreateAssistantRequest createAssistantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssistantRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssistantRequest#builder()}
     * </p>
     *
     * @param createAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssistantResponse> createAssistant(
            Consumer<CreateAssistantRequest.Builder> createAssistantRequest) {
        return createAssistant(CreateAssistantRequest.builder().applyMutation(createAssistantRequest).build());
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     *
     * @param createAssistantAssociationRequest
     * @return A Java Future containing the result of the CreateAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssistantAssociationResponse> createAssistantAssociation(
            CreateAssistantAssociationRequest createAssistantAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param createAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssistantAssociationResponse> createAssistantAssociation(
            Consumer<CreateAssistantAssociationRequest.Builder> createAssistantAssociationRequest) {
        return createAssistantAssociation(CreateAssistantAssociationRequest.builder()
                .applyMutation(createAssistantAssociationRequest).build());
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     *
     * @param createContentRequest
     * @return A Java Future containing the result of the CreateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContentResponse> createContent(CreateContentRequest createContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContentRequest#builder()}
     * </p>
     *
     * @param createContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateContentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContentResponse> createContent(Consumer<CreateContentRequest.Builder> createContentRequest) {
        return createContent(CreateContentRequest.builder().applyMutation(createContentRequest).build());
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createContentAssociationRequest
     * @return A Java Future containing the result of the CreateContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContentAssociationResponse> createContentAssociation(
            CreateContentAssociationRequest createContentAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContentAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContentAssociationRequest#builder()}
     * </p>
     *
     * @param createContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContentAssociationResponse> createContentAssociation(
            Consumer<CreateContentAssociationRequest.Builder> createContentAssociationRequest) {
        return createContentAssociation(CreateContentAssociationRequest.builder().applyMutation(createContentAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note>
     *
     * @param createKnowledgeBaseRequest
     * @return A Java Future containing the result of the CreateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateKnowledgeBaseResponse> createKnowledgeBase(
            CreateKnowledgeBaseRequest createKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param createKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateKnowledgeBaseResponse> createKnowledgeBase(
            Consumer<CreateKnowledgeBaseRequest.Builder> createKnowledgeBaseRequest) {
        return createKnowledgeBase(CreateKnowledgeBaseRequest.builder().applyMutation(createKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     *
     * @param createQuickResponseRequest
     * @return A Java Future containing the result of the CreateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateQuickResponseResponse> createQuickResponse(
            CreateQuickResponseRequest createQuickResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQuickResponseRequest#builder()}
     * </p>
     *
     * @param createQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateQuickResponseResponse> createQuickResponse(
            Consumer<CreateQuickResponseRequest.Builder> createQuickResponseRequest) {
        return createQuickResponse(CreateQuickResponseRequest.builder().applyMutation(createQuickResponseRequest).build());
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param createSessionRequest
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(CreateSessionRequest createSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest) {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param deleteAiAgentRequest
     * @return A Java Future containing the result of the DeleteAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAiAgentResponse> deleteAIAgent(DeleteAiAgentRequest deleteAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAiAgentRequest#builder()}
     * </p>
     *
     * @param deleteAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAiAgentResponse> deleteAIAgent(Consumer<DeleteAiAgentRequest.Builder> deleteAiAgentRequest) {
        return deleteAIAgent(DeleteAiAgentRequest.builder().applyMutation(deleteAiAgentRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     * @return A Java Future containing the result of the DeleteAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAiAgentVersionResponse> deleteAIAgentVersion(
            DeleteAiAgentVersionRequest deleteAiAgentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiAgentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAiAgentVersionRequest#builder()}
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAIAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAiAgentVersionResponse> deleteAIAgentVersion(
            Consumer<DeleteAiAgentVersionRequest.Builder> deleteAiAgentVersionRequest) {
        return deleteAIAgentVersion(DeleteAiAgentVersionRequest.builder().applyMutation(deleteAiAgentVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param deleteAiPromptRequest
     * @return A Java Future containing the result of the DeleteAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAiPromptResponse> deleteAIPrompt(DeleteAiPromptRequest deleteAiPromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAiPromptRequest#builder()}
     * </p>
     *
     * @param deleteAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAiPromptResponse> deleteAIPrompt(Consumer<DeleteAiPromptRequest.Builder> deleteAiPromptRequest) {
        return deleteAIPrompt(DeleteAiPromptRequest.builder().applyMutation(deleteAiPromptRequest).build());
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     * @return A Java Future containing the result of the DeleteAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAiPromptVersionResponse> deleteAIPromptVersion(
            DeleteAiPromptVersionRequest deleteAiPromptVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiPromptVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAiPromptVersionRequest#builder()}
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAIPromptVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAiPromptVersionResponse> deleteAIPromptVersion(
            Consumer<DeleteAiPromptVersionRequest.Builder> deleteAiPromptVersionRequest) {
        return deleteAIPromptVersion(DeleteAiPromptVersionRequest.builder().applyMutation(deleteAiPromptVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     *
     * @param deleteAssistantRequest
     * @return A Java Future containing the result of the DeleteAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssistantResponse> deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssistantRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssistantRequest#builder()}
     * </p>
     *
     * @param deleteAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssistantResponse> deleteAssistant(
            Consumer<DeleteAssistantRequest.Builder> deleteAssistantRequest) {
        return deleteAssistant(DeleteAssistantRequest.builder().applyMutation(deleteAssistantRequest).build());
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     * @return A Java Future containing the result of the DeleteAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssistantAssociationResponse> deleteAssistantAssociation(
            DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssistantAssociationResponse> deleteAssistantAssociation(
            Consumer<DeleteAssistantAssociationRequest.Builder> deleteAssistantAssociationRequest) {
        return deleteAssistantAssociation(DeleteAssistantAssociationRequest.builder()
                .applyMutation(deleteAssistantAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     *
     * @param deleteContentRequest
     * @return A Java Future containing the result of the DeleteContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContentResponse> deleteContent(DeleteContentRequest deleteContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContentRequest#builder()}
     * </p>
     *
     * @param deleteContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteContentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContentResponse> deleteContent(Consumer<DeleteContentRequest.Builder> deleteContentRequest) {
        return deleteContent(DeleteContentRequest.builder().applyMutation(deleteContentRequest).build());
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteContentAssociationRequest
     * @return A Java Future containing the result of the DeleteContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContentAssociationResponse> deleteContentAssociation(
            DeleteContentAssociationRequest deleteContentAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContentAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContentAssociationRequest#builder()}
     * </p>
     *
     * @param deleteContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContentAssociationResponse> deleteContentAssociation(
            Consumer<DeleteContentAssociationRequest.Builder> deleteContentAssociationRequest) {
        return deleteContentAssociation(DeleteContentAssociationRequest.builder().applyMutation(deleteContentAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     *
     * @param deleteImportJobRequest
     * @return A Java Future containing the result of the DeleteImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImportJobResponse> deleteImportJob(DeleteImportJobRequest deleteImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteImportJobRequest#builder()}
     * </p>
     *
     * @param deleteImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImportJobResponse> deleteImportJob(
            Consumer<DeleteImportJobRequest.Builder> deleteImportJobRequest) {
        return deleteImportJob(DeleteImportJobRequest.builder().applyMutation(deleteImportJobRequest).build());
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteKnowledgeBaseRequest
     * @return A Java Future containing the result of the DeleteKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(
            DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param deleteKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(
            Consumer<DeleteKnowledgeBaseRequest.Builder> deleteKnowledgeBaseRequest) {
        return deleteKnowledgeBase(DeleteKnowledgeBaseRequest.builder().applyMutation(deleteKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     *
     * @param deleteQuickResponseRequest
     * @return A Java Future containing the result of the DeleteQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQuickResponseResponse> deleteQuickResponse(
            DeleteQuickResponseRequest deleteQuickResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQuickResponseRequest#builder()}
     * </p>
     *
     * @param deleteQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQuickResponseResponse> deleteQuickResponse(
            Consumer<DeleteQuickResponseRequest.Builder> deleteQuickResponseRequest) {
        return deleteQuickResponse(DeleteQuickResponseRequest.builder().applyMutation(deleteQuickResponseRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param getAiAgentRequest
     * @return A Java Future containing the result of the GetAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAiAgentResponse> getAIAgent(GetAiAgentRequest getAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAiAgentRequest#builder()}
     * </p>
     *
     * @param getAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAiAgentResponse> getAIAgent(Consumer<GetAiAgentRequest.Builder> getAiAgentRequest) {
        return getAIAgent(GetAiAgentRequest.builder().applyMutation(getAiAgentRequest).build());
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param getAiPromptRequest
     * @return A Java Future containing the result of the GetAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAiPromptResponse> getAIPrompt(GetAiPromptRequest getAiPromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link GetAiPromptRequest#builder()}
     * </p>
     *
     * @param getAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAiPromptResponse> getAIPrompt(Consumer<GetAiPromptRequest.Builder> getAiPromptRequest) {
        return getAIPrompt(GetAiPromptRequest.builder().applyMutation(getAiPromptRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     *
     * @param getAssistantRequest
     * @return A Java Future containing the result of the GetAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssistantResponse> getAssistant(GetAssistantRequest getAssistantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssistantRequest#builder()}
     * </p>
     *
     * @param getAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAssistantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssistantResponse> getAssistant(Consumer<GetAssistantRequest.Builder> getAssistantRequest) {
        return getAssistant(GetAssistantRequest.builder().applyMutation(getAssistantRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     *
     * @param getAssistantAssociationRequest
     * @return A Java Future containing the result of the GetAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssistantAssociationResponse> getAssistantAssociation(
            GetAssistantAssociationRequest getAssistantAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param getAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAssistantAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssistantAssociationResponse> getAssistantAssociation(
            Consumer<GetAssistantAssociationRequest.Builder> getAssistantAssociationRequest) {
        return getAssistantAssociation(GetAssistantAssociationRequest.builder().applyMutation(getAssistantAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     *
     * @param getContentRequest
     * @return A Java Future containing the result of the GetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContentResponse> getContent(GetContentRequest getContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentRequest.Builder} avoiding the need to
     * create one manually via {@link GetContentRequest#builder()}
     * </p>
     *
     * @param getContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContentResponse> getContent(Consumer<GetContentRequest.Builder> getContentRequest) {
        return getContent(GetContentRequest.builder().applyMutation(getContentRequest).build());
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getContentAssociationRequest
     * @return A Java Future containing the result of the GetContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContentAssociationResponse> getContentAssociation(
            GetContentAssociationRequest getContentAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetContentAssociationRequest#builder()}
     * </p>
     *
     * @param getContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContentAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContentAssociationResponse> getContentAssociation(
            Consumer<GetContentAssociationRequest.Builder> getContentAssociationRequest) {
        return getContentAssociation(GetContentAssociationRequest.builder().applyMutation(getContentAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     *
     * @param getContentSummaryRequest
     * @return A Java Future containing the result of the GetContentSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContentSummaryResponse> getContentSummary(GetContentSummaryRequest getContentSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetContentSummaryRequest#builder()}
     * </p>
     *
     * @param getContentSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContentSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContentSummaryResponse> getContentSummary(
            Consumer<GetContentSummaryRequest.Builder> getContentSummaryRequest) {
        return getContentSummary(GetContentSummaryRequest.builder().applyMutation(getContentSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     *
     * @param getImportJobRequest
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetImportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest) {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     *
     * @param getKnowledgeBaseRequest
     * @return A Java Future containing the result of the GetKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKnowledgeBaseRequest.Builder} avoiding the need
     * to create one manually via {@link GetKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param getKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKnowledgeBaseResponse> getKnowledgeBase(
            Consumer<GetKnowledgeBaseRequest.Builder> getKnowledgeBaseRequest) {
        return getKnowledgeBase(GetKnowledgeBaseRequest.builder().applyMutation(getKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     *
     * @param getQuickResponseRequest
     * @return A Java Future containing the result of the GetQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQuickResponseResponse> getQuickResponse(GetQuickResponseRequest getQuickResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQuickResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetQuickResponseRequest#builder()}
     * </p>
     *
     * @param getQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQuickResponseResponse> getQuickResponse(
            Consumer<GetQuickResponseRequest.Builder> getQuickResponseRequest) {
        return getQuickResponse(GetQuickResponseRequest.builder().applyMutation(getQuickResponseRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     *
     * @param getRecommendationsRequest
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses
     *             after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the
     *             Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(GetRecommendationsRequest getRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses
     *             after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the
     *             Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(
            Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest) {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return A Java Future containing the result of the ListAIAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAiAgentVersionsResponse> listAIAgentVersions(
            ListAiAgentVersionsRequest listAiAgentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAiAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAIAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAiAgentVersionsResponse> listAIAgentVersions(
            Consumer<ListAiAgentVersionsRequest.Builder> listAiAgentVersionsRequest) {
        return listAIAgentVersions(ListAiAgentVersionsRequest.builder().applyMutation(listAiAgentVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsPublisher publisher = client.listAIAgentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsPublisher publisher = client.listAIAgentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIAgentVersionsPublisher listAIAgentVersionsPaginator(ListAiAgentVersionsRequest listAiAgentVersionsRequest) {
        return new ListAIAgentVersionsPublisher(this, listAiAgentVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsPublisher publisher = client.listAIAgentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsPublisher publisher = client.listAIAgentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAiAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIAgentVersionsPublisher listAIAgentVersionsPaginator(
            Consumer<ListAiAgentVersionsRequest.Builder> listAiAgentVersionsRequest) {
        return listAIAgentVersionsPaginator(ListAiAgentVersionsRequest.builder().applyMutation(listAiAgentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     *
     * @param listAiAgentsRequest
     * @return A Java Future containing the result of the ListAIAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAiAgentsResponse> listAIAgents(ListAiAgentsRequest listAiAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiAgentsRequest#builder()}
     * </p>
     *
     * @param listAiAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAIAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAiAgentsResponse> listAIAgents(Consumer<ListAiAgentsRequest.Builder> listAiAgentsRequest) {
        return listAIAgents(ListAiAgentsRequest.builder().applyMutation(listAiAgentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsPublisher publisher = client.listAIAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsPublisher publisher = client.listAIAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)} operation.</b>
     * </p>
     *
     * @param listAiAgentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIAgentsPublisher listAIAgentsPaginator(ListAiAgentsRequest listAiAgentsRequest) {
        return new ListAIAgentsPublisher(this, listAiAgentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsPublisher publisher = client.listAIAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsPublisher publisher = client.listAIAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiAgentsRequest#builder()}
     * </p>
     *
     * @param listAiAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIAgentsPublisher listAIAgentsPaginator(Consumer<ListAiAgentsRequest.Builder> listAiAgentsRequest) {
        return listAIAgentsPaginator(ListAiAgentsRequest.builder().applyMutation(listAiAgentsRequest).build());
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return A Java Future containing the result of the ListAIPromptVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAiPromptVersionsResponse> listAIPromptVersions(
            ListAiPromptVersionsRequest listAiPromptVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiPromptVersionsRequest#builder()}
     * </p>
     *
     * @param listAiPromptVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAIPromptVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAiPromptVersionsResponse> listAIPromptVersions(
            Consumer<ListAiPromptVersionsRequest.Builder> listAiPromptVersionsRequest) {
        return listAIPromptVersions(ListAiPromptVersionsRequest.builder().applyMutation(listAiPromptVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsPublisher publisher = client.listAIPromptVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsPublisher publisher = client.listAIPromptVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIPromptVersionsPublisher listAIPromptVersionsPaginator(ListAiPromptVersionsRequest listAiPromptVersionsRequest) {
        return new ListAIPromptVersionsPublisher(this, listAiPromptVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsPublisher publisher = client.listAIPromptVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsPublisher publisher = client.listAIPromptVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiPromptVersionsRequest#builder()}
     * </p>
     *
     * @param listAiPromptVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIPromptVersionsPublisher listAIPromptVersionsPaginator(
            Consumer<ListAiPromptVersionsRequest.Builder> listAiPromptVersionsRequest) {
        return listAIPromptVersionsPaginator(ListAiPromptVersionsRequest.builder().applyMutation(listAiPromptVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     *
     * @param listAiPromptsRequest
     * @return A Java Future containing the result of the ListAIPrompts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAiPromptsResponse> listAIPrompts(ListAiPromptsRequest listAiPromptsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiPromptsRequest#builder()}
     * </p>
     *
     * @param listAiPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAIPrompts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAiPromptsResponse> listAIPrompts(Consumer<ListAiPromptsRequest.Builder> listAiPromptsRequest) {
        return listAIPrompts(ListAiPromptsRequest.builder().applyMutation(listAiPromptsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsPublisher publisher = client.listAIPromptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsPublisher publisher = client.listAIPromptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)} operation.</b>
     * </p>
     *
     * @param listAiPromptsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIPromptsPublisher listAIPromptsPaginator(ListAiPromptsRequest listAiPromptsRequest) {
        return new ListAIPromptsPublisher(this, listAiPromptsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsPublisher publisher = client.listAIPromptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsPublisher publisher = client.listAIPromptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiPromptsRequest#builder()}
     * </p>
     *
     * @param listAiPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIPromptsPublisher listAIPromptsPaginator(Consumer<ListAiPromptsRequest.Builder> listAiPromptsRequest) {
        return listAIPromptsPaginator(ListAiPromptsRequest.builder().applyMutation(listAiPromptsRequest).build());
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return A Java Future containing the result of the ListAssistantAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssistantAssociationsResponse> listAssistantAssociations(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssistantAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssistantAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAssistantAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssistantAssociationsResponse> listAssistantAssociations(
            Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) {
        return listAssistantAssociations(ListAssistantAssociationsRequest.builder()
                .applyMutation(listAssistantAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsPublisher publisher = client.listAssistantAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsPublisher publisher = client.listAssistantAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsPublisher listAssistantAssociationsPaginator(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) {
        return new ListAssistantAssociationsPublisher(this, listAssistantAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsPublisher publisher = client.listAssistantAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsPublisher publisher = client.listAssistantAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssistantAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssistantAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsPublisher listAssistantAssociationsPaginator(
            Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) {
        return listAssistantAssociationsPaginator(ListAssistantAssociationsRequest.builder()
                .applyMutation(listAssistantAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     *
     * @param listAssistantsRequest
     * @return A Java Future containing the result of the ListAssistants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssistantsResponse> listAssistants(ListAssistantsRequest listAssistantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssistantsRequest#builder()}
     * </p>
     *
     * @param listAssistantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssistants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssistantsResponse> listAssistants(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest) {
        return listAssistants(ListAssistantsRequest.builder().applyMutation(listAssistantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsPublisher publisher = client.listAssistantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsPublisher publisher = client.listAssistantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation.</b>
     * </p>
     *
     * @param listAssistantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsPublisher listAssistantsPaginator(ListAssistantsRequest listAssistantsRequest) {
        return new ListAssistantsPublisher(this, listAssistantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsPublisher publisher = client.listAssistantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsPublisher publisher = client.listAssistantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssistantsRequest#builder()}
     * </p>
     *
     * @param listAssistantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsPublisher listAssistantsPaginator(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest) {
        return listAssistantsPaginator(ListAssistantsRequest.builder().applyMutation(listAssistantsRequest).build());
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return A Java Future containing the result of the ListContentAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContentAssociationsResponse> listContentAssociations(
            ListContentAssociationsRequest listContentAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContentAssociationsRequest#builder()}
     * </p>
     *
     * @param listContentAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContentAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContentAssociationsResponse> listContentAssociations(
            Consumer<ListContentAssociationsRequest.Builder> listContentAssociationsRequest) {
        return listContentAssociations(ListContentAssociationsRequest.builder().applyMutation(listContentAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsPublisher publisher = client.listContentAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsPublisher publisher = client.listContentAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsPublisher listContentAssociationsPaginator(
            ListContentAssociationsRequest listContentAssociationsRequest) {
        return new ListContentAssociationsPublisher(this, listContentAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsPublisher publisher = client.listContentAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsPublisher publisher = client.listContentAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContentAssociationsRequest#builder()}
     * </p>
     *
     * @param listContentAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsPublisher listContentAssociationsPaginator(
            Consumer<ListContentAssociationsRequest.Builder> listContentAssociationsRequest) {
        return listContentAssociationsPaginator(ListContentAssociationsRequest.builder()
                .applyMutation(listContentAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     *
     * @param listContentsRequest
     * @return A Java Future containing the result of the ListContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContentsResponse> listContents(ListContentsRequest listContentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContentsRequest#builder()}
     * </p>
     *
     * @param listContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListContents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContentsResponse> listContents(Consumer<ListContentsRequest.Builder> listContentsRequest) {
        return listContents(ListContentsRequest.builder().applyMutation(listContentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsPublisher publisher = client.listContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsPublisher publisher = client.listContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)} operation.</b>
     * </p>
     *
     * @param listContentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsPublisher listContentsPaginator(ListContentsRequest listContentsRequest) {
        return new ListContentsPublisher(this, listContentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsPublisher publisher = client.listContentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsPublisher publisher = client.listContentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListContentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListContentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContentsRequest#builder()}
     * </p>
     *
     * @param listContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsPublisher listContentsPaginator(Consumer<ListContentsRequest.Builder> listContentsRequest) {
        return listContentsPaginator(ListContentsRequest.builder().applyMutation(listContentsRequest).build());
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportJobsResponse> listImportJobs(ListImportJobsRequest listImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportJobsResponse> listImportJobs(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest) {
        return listImportJobs(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsPublisher listImportJobsPaginator(ListImportJobsRequest listImportJobsRequest) {
        return new ListImportJobsPublisher(this, listImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsPublisher listImportJobsPaginator(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest) {
        return listImportJobsPaginator(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A Java Future containing the result of the ListKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListKnowledgeBasesResponse> listKnowledgeBases(
            Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) {
        return listKnowledgeBases(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesPublisher listKnowledgeBasesPaginator(ListKnowledgeBasesRequest listKnowledgeBasesRequest) {
        return new ListKnowledgeBasesPublisher(this, listKnowledgeBasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesPublisher listKnowledgeBasesPaginator(
            Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) {
        return listKnowledgeBasesPaginator(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return A Java Future containing the result of the ListQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListQuickResponsesResponse> listQuickResponses(ListQuickResponsesRequest listQuickResponsesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickResponsesRequest#builder()}
     * </p>
     *
     * @param listQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListQuickResponsesResponse> listQuickResponses(
            Consumer<ListQuickResponsesRequest.Builder> listQuickResponsesRequest) {
        return listQuickResponses(ListQuickResponsesRequest.builder().applyMutation(listQuickResponsesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesPublisher publisher = client.listQuickResponsesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesPublisher publisher = client.listQuickResponsesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesPublisher listQuickResponsesPaginator(ListQuickResponsesRequest listQuickResponsesRequest) {
        return new ListQuickResponsesPublisher(this, listQuickResponsesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesPublisher publisher = client.listQuickResponsesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesPublisher publisher = client.listQuickResponsesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickResponsesRequest#builder()}
     * </p>
     *
     * @param listQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesPublisher listQuickResponsesPaginator(
            Consumer<ListQuickResponsesRequest.Builder> listQuickResponsesRequest) {
        return listQuickResponsesPaginator(ListQuickResponsesRequest.builder().applyMutation(listQuickResponsesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     * @return A Java Future containing the result of the NotifyRecommendationsReceived operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyRecommendationsReceivedResponse> notifyRecommendationsReceived(
            NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyRecommendationsReceivedRequest.Builder}
     * avoiding the need to create one manually via {@link NotifyRecommendationsReceivedRequest#builder()}
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the NotifyRecommendationsReceived operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<NotifyRecommendationsReceivedResponse> notifyRecommendationsReceived(
            Consumer<NotifyRecommendationsReceivedRequest.Builder> notifyRecommendationsReceivedRequest) {
        return notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest.builder()
                .applyMutation(notifyRecommendationsReceivedRequest).build());
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     *
     * @param queryAssistantRequest
     * @return A Java Future containing the result of the QueryAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default CompletableFuture<QueryAssistantResponse> queryAssistant(QueryAssistantRequest queryAssistantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link QueryAssistantRequest#builder()}
     * </p>
     *
     * @param queryAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the QueryAssistant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default CompletableFuture<QueryAssistantResponse> queryAssistant(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest) {
        return queryAssistant(QueryAssistantRequest.builder().applyMutation(queryAssistantRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantPublisher publisher = client.queryAssistantPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantPublisher publisher = client.queryAssistantPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation.</b>
     * </p>
     *
     * @param queryAssistantRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantPublisher queryAssistantPaginator(QueryAssistantRequest queryAssistantRequest) {
        return new QueryAssistantPublisher(this, queryAssistantRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantPublisher publisher = client.queryAssistantPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantPublisher publisher = client.queryAssistantPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link QueryAssistantRequest#builder()}
     * </p>
     *
     * @param queryAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantPublisher queryAssistantPaginator(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest) {
        return queryAssistantPaginator(QueryAssistantRequest.builder().applyMutation(queryAssistantRequest).build());
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     * @return A Java Future containing the result of the RemoveAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAssistantAiAgentResponse> removeAssistantAIAgent(
            RemoveAssistantAiAgentRequest removeAssistantAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAssistantAiAgentRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveAssistantAiAgentRequest#builder()}
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAssistantAiAgentResponse> removeAssistantAIAgent(
            Consumer<RemoveAssistantAiAgentRequest.Builder> removeAssistantAiAgentRequest) {
        return removeAssistantAIAgent(RemoveAssistantAiAgentRequest.builder().applyMutation(removeAssistantAiAgentRequest)
                .build());
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     * @return A Java Future containing the result of the RemoveKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveKnowledgeBaseTemplateUriResponse> removeKnowledgeBaseTemplateUri(
            RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveKnowledgeBaseTemplateUriRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveKnowledgeBaseTemplateUriRequest#builder()}
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RemoveKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveKnowledgeBaseTemplateUriResponse> removeKnowledgeBaseTemplateUri(
            Consumer<RemoveKnowledgeBaseTemplateUriRequest.Builder> removeKnowledgeBaseTemplateUriRequest) {
        return removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest.builder()
                .applyMutation(removeKnowledgeBaseTemplateUriRequest).build());
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     *
     * @param searchContentRequest
     * @return A Java Future containing the result of the SearchContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchContentResponse> searchContent(SearchContentRequest searchContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContentRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContentRequest#builder()}
     * </p>
     *
     * @param searchContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchContentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchContentResponse> searchContent(Consumer<SearchContentRequest.Builder> searchContentRequest) {
        return searchContent(SearchContentRequest.builder().applyMutation(searchContentRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentPublisher publisher = client.searchContentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentPublisher publisher = client.searchContentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchContentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchContentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)} operation.</b>
     * </p>
     *
     * @param searchContentRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentPublisher searchContentPaginator(SearchContentRequest searchContentRequest) {
        return new SearchContentPublisher(this, searchContentRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentPublisher publisher = client.searchContentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentPublisher publisher = client.searchContentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchContentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchContentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContentRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContentRequest#builder()}
     * </p>
     *
     * @param searchContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchContentRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentPublisher searchContentPaginator(Consumer<SearchContentRequest.Builder> searchContentRequest) {
        return searchContentPaginator(SearchContentRequest.builder().applyMutation(searchContentRequest).build());
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return A Java Future containing the result of the SearchQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchQuickResponsesResponse> searchQuickResponses(
            SearchQuickResponsesRequest searchQuickResponsesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuickResponsesRequest#builder()}
     * </p>
     *
     * @param searchQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchQuickResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchQuickResponsesResponse> searchQuickResponses(
            Consumer<SearchQuickResponsesRequest.Builder> searchQuickResponsesRequest) {
        return searchQuickResponses(SearchQuickResponsesRequest.builder().applyMutation(searchQuickResponsesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesPublisher publisher = client.searchQuickResponsesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesPublisher publisher = client.searchQuickResponsesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesPublisher searchQuickResponsesPaginator(SearchQuickResponsesRequest searchQuickResponsesRequest) {
        return new SearchQuickResponsesPublisher(this, searchQuickResponsesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesPublisher publisher = client.searchQuickResponsesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesPublisher publisher = client.searchQuickResponsesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuickResponsesRequest#builder()}
     * </p>
     *
     * @param searchQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestTimeoutException The request reached the service more than 15 minutes after the date stamp on
     *         the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or
     *         the date stamp on the request is more than 15 minutes in the future.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesPublisher searchQuickResponsesPaginator(
            Consumer<SearchQuickResponsesRequest.Builder> searchQuickResponsesRequest) {
        return searchQuickResponsesPaginator(SearchQuickResponsesRequest.builder().applyMutation(searchQuickResponsesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     *
     * @param searchSessionsRequest
     * @return A Java Future containing the result of the SearchSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchSessionsResponse> searchSessions(SearchSessionsRequest searchSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSessionsRequest#builder()}
     * </p>
     *
     * @param searchSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchSessionsResponse> searchSessions(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest) {
        return searchSessions(SearchSessionsRequest.builder().applyMutation(searchSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsPublisher publisher = client.searchSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsPublisher publisher = client.searchSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation.</b>
     * </p>
     *
     * @param searchSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsPublisher searchSessionsPaginator(SearchSessionsRequest searchSessionsRequest) {
        return new SearchSessionsPublisher(this, searchSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsPublisher publisher = client.searchSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsPublisher publisher = client.searchSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSessionsRequest#builder()}
     * </p>
     *
     * @param searchSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsPublisher searchSessionsPaginator(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest) {
        return searchSessionsPaginator(SearchSessionsRequest.builder().applyMutation(searchSessionsRequest).build());
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     *
     * @param startContentUploadRequest
     * @return A Java Future containing the result of the StartContentUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartContentUploadResponse> startContentUpload(StartContentUploadRequest startContentUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContentUploadRequest.Builder} avoiding the
     * need to create one manually via {@link StartContentUploadRequest#builder()}
     * </p>
     *
     * @param startContentUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartContentUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartContentUploadResponse> startContentUpload(
            Consumer<StartContentUploadRequest.Builder> startContentUploadRequest) {
        return startContentUpload(StartContentUploadRequest.builder().applyMutation(startContentUploadRequest).build());
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param startImportJobRequest
     * @return A Java Future containing the result of the StartImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportJobResponse> startImportJob(StartImportJobRequest startImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportJobRequest#builder()}
     * </p>
     *
     * @param startImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.StartImportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>ServiceQuotaExceededException You've exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use service quotas to request a service quota increase.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportJobResponse> startImportJob(Consumer<StartImportJobRequest.Builder> startImportJobRequest) {
        return startImportJob(StartImportJobRequest.builder().applyMutation(startImportJobRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException Amazon Q in Connect throws this exception if you have too many tags in your tag
     *         set.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagsException Amazon Q in Connect throws this exception if you have too many tags in your tag
     *         set.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     *
     * @param updateAiAgentRequest
     * @return A Java Future containing the result of the UpdateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAiAgentResponse> updateAIAgent(UpdateAiAgentRequest updateAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAiAgentRequest#builder()}
     * </p>
     *
     * @param updateAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAiAgentResponse> updateAIAgent(Consumer<UpdateAiAgentRequest.Builder> updateAiAgentRequest) {
        return updateAIAgent(UpdateAiAgentRequest.builder().applyMutation(updateAiAgentRequest).build());
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     *
     * @param updateAiPromptRequest
     * @return A Java Future containing the result of the UpdateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAiPromptResponse> updateAIPrompt(UpdateAiPromptRequest updateAiPromptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAiPromptRequest#builder()}
     * </p>
     *
     * @param updateAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAIPrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAiPromptResponse> updateAIPrompt(Consumer<UpdateAiPromptRequest.Builder> updateAiPromptRequest) {
        return updateAIPrompt(UpdateAiPromptRequest.builder().applyMutation(updateAiPromptRequest).build());
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     * @return A Java Future containing the result of the UpdateAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssistantAiAgentResponse> updateAssistantAIAgent(
            UpdateAssistantAiAgentRequest updateAssistantAiAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssistantAiAgentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssistantAiAgentRequest#builder()}
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAssistantAIAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssistantAiAgentResponse> updateAssistantAIAgent(
            Consumer<UpdateAssistantAiAgentRequest.Builder> updateAssistantAiAgentRequest) {
        return updateAssistantAIAgent(UpdateAssistantAiAgentRequest.builder().applyMutation(updateAssistantAiAgentRequest)
                .build());
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     *
     * @param updateContentRequest
     * @return A Java Future containing the result of the UpdateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContentResponse> updateContent(UpdateContentRequest updateContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContentRequest#builder()}
     * </p>
     *
     * @param updateContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateContentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContentResponse> updateContent(Consumer<UpdateContentRequest.Builder> updateContentRequest) {
        return updateContent(UpdateContentRequest.builder().applyMutation(updateContentRequest).build());
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     * @return A Java Future containing the result of the UpdateKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKnowledgeBaseTemplateUriResponse> updateKnowledgeBaseTemplateUri(
            UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKnowledgeBaseTemplateUriRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateKnowledgeBaseTemplateUriRequest#builder()}
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateKnowledgeBaseTemplateUri operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKnowledgeBaseTemplateUriResponse> updateKnowledgeBaseTemplateUri(
            Consumer<UpdateKnowledgeBaseTemplateUriRequest.Builder> updateKnowledgeBaseTemplateUriRequest) {
        return updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest.builder()
                .applyMutation(updateKnowledgeBaseTemplateUriRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     *
     * @param updateQuickResponseRequest
     * @return A Java Future containing the result of the UpdateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateQuickResponseResponse> updateQuickResponse(
            UpdateQuickResponseRequest updateQuickResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQuickResponseRequest#builder()}
     * </p>
     *
     * @param updateQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateQuickResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. For example, if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>)
     *         that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>PreconditionFailedException The provided <code>revisionId</code> does not match, indicating the
     *         content has been modified since it was last read.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateQuickResponseResponse> updateQuickResponse(
            Consumer<UpdateQuickResponseRequest.Builder> updateQuickResponseRequest) {
        return updateQuickResponse(UpdateQuickResponseRequest.builder().applyMutation(updateQuickResponseRequest).build());
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param updateSessionRequest
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(UpdateSessionRequest updateSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest) {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     *
     * @param updateSessionDataRequest
     * @return A Java Future containing the result of the UpdateSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSessionDataResponse> updateSessionData(UpdateSessionDataRequest updateSessionDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionDataRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSessionDataRequest#builder()}
     * </p>
     *
     * @param updateSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QConnectAsyncClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSessionDataResponse> updateSessionData(
            Consumer<UpdateSessionDataRequest.Builder> updateSessionDataRequest) {
        return updateSessionData(UpdateSessionDataRequest.builder().applyMutation(updateSessionDataRequest).build());
    }

    @Override
    default QConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link QConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QConnectAsyncClient}.
     */
    static QConnectAsyncClientBuilder builder() {
        return new DefaultQConnectAsyncClientBuilder();
    }
}
