/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.qconnect.model.AccessDeniedException;
import software.amazon.awssdk.services.qconnect.model.ConflictException;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.CreateAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.CreateContentRequest;
import software.amazon.awssdk.services.qconnect.model.CreateContentResponse;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.CreateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.CreateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.CreateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteContentRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteContentResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.GetAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.GetAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentAssociationResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentResponse;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.qconnect.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.qconnect.model.GetImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.GetImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.GetQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.qconnect.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.qconnect.model.GetSessionRequest;
import software.amazon.awssdk.services.qconnect.model.GetSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;
import software.amazon.awssdk.services.qconnect.model.ListContentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentsResponse;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest;
import software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.qconnect.model.PreconditionFailedException;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qconnect.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qconnect.model.QConnectException;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.RequestTimeoutException;
import software.amazon.awssdk.services.qconnect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qconnect.model.SearchContentRequest;
import software.amazon.awssdk.services.qconnect.model.SearchContentResponse;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse;
import software.amazon.awssdk.services.qconnect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest;
import software.amazon.awssdk.services.qconnect.model.StartContentUploadResponse;
import software.amazon.awssdk.services.qconnect.model.StartImportJobRequest;
import software.amazon.awssdk.services.qconnect.model.StartImportJobResponse;
import software.amazon.awssdk.services.qconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.ThrottlingException;
import software.amazon.awssdk.services.qconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.qconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.qconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAiPromptResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateContentRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateContentResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionDataResponse;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest;
import software.amazon.awssdk.services.qconnect.model.UpdateSessionResponse;
import software.amazon.awssdk.services.qconnect.model.ValidationException;
import software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable;
import software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable;
import software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable;
import software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable;
import software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable;
import software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable;

/**
 * Service client for accessing Amazon Q Connect. This can be created using the static {@link #builder()} method.
 *
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Q_Connect.html">Amazon Q
 * actions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Q_Connect.html">Amazon Q data
 * types</a>
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * <b>Powered by Amazon Bedrock</b>: Amazon Web Services implements <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/abuse-detection.html">automated abuse detection</a>.
 * Because Amazon Q in Connect is built on Amazon Bedrock, users can take full advantage of the controls implemented in
 * Amazon Bedrock to enforce safety, security, and the responsible use of artificial intelligence (AI).
 * </p>
 * </note>
 * <p>
 * Amazon Q in Connect is a generative AI customer service assistant. It is an LLM-enhanced evolution of Amazon Connect
 * Wisdom that delivers real-time recommendations to help contact center agents resolve customer issues quickly and
 * accurately.
 * </p>
 * <p>
 * Amazon Q in Connect automatically detects customer intent during calls and chats using conversational analytics and
 * natural language understanding (NLU). It then provides agents with immediate, real-time generative responses and
 * suggested actions, and links to relevant documents and articles. Agents can also query Amazon Q in Connect directly
 * using natural language or keywords to answer customer requests.
 * </p>
 * <p>
 * Use the Amazon Q in Connect APIs to create an assistant and a knowledge base, for example, or manage content by
 * uploading custom files.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-q-connect.html">Use
 * Amazon Q in Connect for generative AI powered agent assistance in real-time</a> in the <i>Amazon Connect
 * Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QConnectClient extends AwsClient {
    String SERVICE_NAME = "wisdom";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wisdom";

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param createAiAgentRequest
     * @return Result of the CreateAIAgent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAiAgentResponse createAIAgent(CreateAiAgentRequest createAiAgentRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAiAgentRequest#builder()}
     * </p>
     *
     * @param createAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiAgentRequest.Builder} to create a request.
     * @return Result of the CreateAIAgent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAiAgentResponse createAIAgent(Consumer<CreateAiAgentRequest.Builder> createAiAgentRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        return createAIAgent(CreateAiAgentRequest.builder().applyMutation(createAiAgentRequest).build());
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     *
     * @param createAiAgentVersionRequest
     * @return Result of the CreateAIAgentVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAiAgentVersionResponse createAIAgentVersion(CreateAiAgentVersionRequest createAiAgentVersionRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and Amazon Q in Connect AI Agent version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiAgentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAiAgentVersionRequest#builder()}
     * </p>
     *
     * @param createAiAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiAgentVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAIAgentVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAiAgentVersionResponse createAIAgentVersion(
            Consumer<CreateAiAgentVersionRequest.Builder> createAiAgentVersionRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        return createAIAgentVersion(CreateAiAgentVersionRequest.builder().applyMutation(createAiAgentVersionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param createAiPromptRequest
     * @return Result of the CreateAIPrompt operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAiPromptResponse createAIPrompt(CreateAiPromptRequest createAiPromptRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAiPromptRequest#builder()}
     * </p>
     *
     * @param createAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiPromptRequest.Builder} to create a request.
     * @return Result of the CreateAIPrompt operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAiPromptResponse createAIPrompt(Consumer<CreateAiPromptRequest.Builder> createAiPromptRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        return createAIPrompt(CreateAiPromptRequest.builder().applyMutation(createAiPromptRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param createAiPromptVersionRequest
     * @return Result of the CreateAIPromptVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAiPromptVersionResponse createAIPromptVersion(CreateAiPromptVersionRequest createAiPromptVersionRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect AI Prompt version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAiPromptVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAiPromptVersionRequest#builder()}
     * </p>
     *
     * @param createAiPromptVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAiPromptVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAIPromptVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAiPromptVersionResponse createAIPromptVersion(
            Consumer<CreateAiPromptVersionRequest.Builder> createAiPromptVersionRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        return createAIPromptVersion(CreateAiPromptVersionRequest.builder().applyMutation(createAiPromptVersionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     *
     * @param createAssistantRequest
     * @return Result of the CreateAssistant operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssistantResponse createAssistant(CreateAssistantRequest createAssistantRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssistantRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssistantRequest#builder()}
     * </p>
     *
     * @param createAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAssistantRequest.Builder} to create a request.
     * @return Result of the CreateAssistant operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssistantResponse createAssistant(Consumer<CreateAssistantRequest.Builder> createAssistantRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, QConnectException {
        return createAssistant(CreateAssistantRequest.builder().applyMutation(createAssistantRequest).build());
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     *
     * @param createAssistantAssociationRequest
     * @return Result of the CreateAssistantAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssistantAssociationResponse createAssistantAssociation(
            CreateAssistantAssociationRequest createAssistantAssociationRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only
     * supported association is with a knowledge base. An assistant can have only a single association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param createAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateAssistantAssociationRequest.Builder} to create
     *        a request.
     * @return Result of the CreateAssistantAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssistantAssociationResponse createAssistantAssociation(
            Consumer<CreateAssistantAssociationRequest.Builder> createAssistantAssociationRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return createAssistantAssociation(CreateAssistantAssociationRequest.builder()
                .applyMutation(createAssistantAssociationRequest).build());
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     *
     * @param createContentRequest
     * @return Result of the CreateContent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContentResponse createContent(CreateContentRequest createContentRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Amazon Q in Connect content. Before to calling this API, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html"
     * >StartContentUpload</a> to upload an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContentRequest#builder()}
     * </p>
     *
     * @param createContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateContentRequest.Builder} to create a request.
     * @return Result of the CreateContent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContentResponse createContent(Consumer<CreateContentRequest.Builder> createContentRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return createContent(CreateContentRequest.builder().applyMutation(createContentRequest).build());
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createContentAssociationRequest
     * @return Result of the CreateContentAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContentAssociationResponse createContentAssociation(
            CreateContentAssociationRequest createContentAssociationRequest) throws ConflictException, ValidationException,
            ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a content resource in a knowledge base and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html">step-by-step
     * guides</a>. Step-by-step guides offer instructions to agents for resolving common customer issues. You create a
     * content association to integrate Amazon Q in Connect and step-by-step guides.
     * </p>
     * <p>
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based
     * on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you
     * have associated with the content.
     * </p>
     * <p>
     * Note the following limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can create only one content association for each content resource in a knowledge base.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate a step-by-step guide with multiple content resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContentAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContentAssociationRequest#builder()}
     * </p>
     *
     * @param createContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateContentAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContentAssociation operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContentAssociationResponse createContentAssociation(
            Consumer<CreateContentAssociationRequest.Builder> createContentAssociationRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        return createContentAssociation(CreateContentAssociationRequest.builder().applyMutation(createContentAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note>
     *
     * @param createKnowledgeBaseRequest
     * @return Result of the CreateKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest createKnowledgeBaseRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a knowledge base.
     * </p>
     * <note>
     * <p>
     * When using this API, you cannot reuse <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a>
     * DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an
     * <code>InvalidRequestException</code> error.
     * </p>
     * <p>
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of
     * the fields that is being ingested from Salesforce. Do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html">
     * DeleteKnowledgeBase</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">
     * DeleteDataIntegration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">
     * CreateDataIntegration</a> to recreate the DataIntegration or a create different one.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call CreateKnowledgeBase.
     * </p>
     * </li>
     * </ol>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param createKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKnowledgeBaseResponse createKnowledgeBase(
            Consumer<CreateKnowledgeBaseRequest.Builder> createKnowledgeBaseRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            QConnectException {
        return createKnowledgeBase(CreateKnowledgeBaseRequest.builder().applyMutation(createKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     *
     * @param createQuickResponseRequest
     * @return Result of the CreateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickResponseResponse createQuickResponse(CreateQuickResponseRequest createQuickResponseRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q in Connect quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQuickResponseRequest#builder()}
     * </p>
     *
     * @param createQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateQuickResponseRequest.Builder} to create a
     *        request.
     * @return Result of the CreateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickResponseResponse createQuickResponse(
            Consumer<CreateQuickResponseRequest.Builder> createQuickResponseRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return createQuickResponse(CreateQuickResponseRequest.builder().applyMutation(createQuickResponseRequest).build());
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param createSessionRequest
     * @return Result of the CreateSession operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.CreateSessionRequest.Builder} to create a request.
     * @return Result of the CreateSession operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSessionResponse createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param deleteAiAgentRequest
     * @return Result of the DeleteAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAiAgentResponse deleteAIAgent(DeleteAiAgentRequest deleteAiAgentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAiAgentRequest#builder()}
     * </p>
     *
     * @param deleteAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiAgentRequest.Builder} to create a request.
     * @return Result of the DeleteAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAiAgentResponse deleteAIAgent(Consumer<DeleteAiAgentRequest.Builder> deleteAiAgentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return deleteAIAgent(DeleteAiAgentRequest.builder().applyMutation(deleteAiAgentRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     * @return Result of the DeleteAIAgentVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAiAgentVersionResponse deleteAIAgentVersion(DeleteAiAgentVersionRequest deleteAiAgentVersionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Agent Version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiAgentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAiAgentVersionRequest#builder()}
     * </p>
     *
     * @param deleteAiAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiAgentVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAIAgentVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAiAgentVersionResponse deleteAIAgentVersion(
            Consumer<DeleteAiAgentVersionRequest.Builder> deleteAiAgentVersionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        return deleteAIAgentVersion(DeleteAiAgentVersionRequest.builder().applyMutation(deleteAiAgentVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param deleteAiPromptRequest
     * @return Result of the DeleteAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAiPromptResponse deleteAIPrompt(DeleteAiPromptRequest deleteAiPromptRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAiPromptRequest#builder()}
     * </p>
     *
     * @param deleteAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiPromptRequest.Builder} to create a request.
     * @return Result of the DeleteAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAiPromptResponse deleteAIPrompt(Consumer<DeleteAiPromptRequest.Builder> deleteAiPromptRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return deleteAIPrompt(DeleteAiPromptRequest.builder().applyMutation(deleteAiPromptRequest).build());
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     * @return Result of the DeleteAIPromptVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAiPromptVersionResponse deleteAIPromptVersion(DeleteAiPromptVersionRequest deleteAiPromptVersionRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete and Amazon Q in Connect AI Prompt version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAiPromptVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAiPromptVersionRequest#builder()}
     * </p>
     *
     * @param deleteAiPromptVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAiPromptVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAIPromptVersion operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAIPromptVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAIPromptVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAiPromptVersionResponse deleteAIPromptVersion(
            Consumer<DeleteAiPromptVersionRequest.Builder> deleteAiPromptVersionRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        return deleteAIPromptVersion(DeleteAiPromptVersionRequest.builder().applyMutation(deleteAiPromptVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     *
     * @param deleteAssistantRequest
     * @return Result of the DeleteAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssistantResponse deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssistantRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssistantRequest#builder()}
     * </p>
     *
     * @param deleteAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAssistantRequest.Builder} to create a request.
     * @return Result of the DeleteAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssistantResponse deleteAssistant(Consumer<DeleteAssistantRequest.Builder> deleteAssistantRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return deleteAssistant(DeleteAssistantRequest.builder().applyMutation(deleteAssistantRequest).build());
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     * @return Result of the DeleteAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssistantAssociationResponse deleteAssistantAssociation(
            DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an assistant association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteAssistantAssociationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssistantAssociationResponse deleteAssistantAssociation(
            Consumer<DeleteAssistantAssociationRequest.Builder> deleteAssistantAssociationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return deleteAssistantAssociation(DeleteAssistantAssociationRequest.builder()
                .applyMutation(deleteAssistantAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     *
     * @param deleteContentRequest
     * @return Result of the DeleteContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContentResponse deleteContent(DeleteContentRequest deleteContentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContentRequest#builder()}
     * </p>
     *
     * @param deleteContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteContentRequest.Builder} to create a request.
     * @return Result of the DeleteContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContentResponse deleteContent(Consumer<DeleteContentRequest.Builder> deleteContentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return deleteContent(DeleteContentRequest.builder().applyMutation(deleteContentRequest).build());
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteContentAssociationRequest
     * @return Result of the DeleteContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContentAssociationResponse deleteContentAssociation(
            DeleteContentAssociationRequest deleteContentAssociationRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContentAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContentAssociationRequest#builder()}
     * </p>
     *
     * @param deleteContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteContentAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContentAssociationResponse deleteContentAssociation(
            Consumer<DeleteContentAssociationRequest.Builder> deleteContentAssociationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return deleteContentAssociation(DeleteContentAssociationRequest.builder().applyMutation(deleteContentAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     *
     * @param deleteImportJobRequest
     * @return Result of the DeleteImportJob operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImportJobResponse deleteImportJob(DeleteImportJobRequest deleteImportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the quick response import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteImportJobRequest#builder()}
     * </p>
     *
     * @param deleteImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteImportJobRequest.Builder} to create a request.
     * @return Result of the DeleteImportJob operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImportJobResponse deleteImportJob(Consumer<DeleteImportJobRequest.Builder> deleteImportJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return deleteImportJob(DeleteImportJobRequest.builder().applyMutation(deleteImportJobRequest).build());
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteKnowledgeBaseRequest
     * @return Result of the DeleteKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the knowledge base.
     * </p>
     * <note>
     * <p>
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete
     * the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon
     * AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been
     * associated with an external knowledge base. However, you can delete and recreate it. See <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html"
     * >DeleteDataIntegration</a> and <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param deleteKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKnowledgeBase operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteKnowledgeBase" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKnowledgeBaseResponse deleteKnowledgeBase(
            Consumer<DeleteKnowledgeBaseRequest.Builder> deleteKnowledgeBaseRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        return deleteKnowledgeBase(DeleteKnowledgeBaseRequest.builder().applyMutation(deleteKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     *
     * @param deleteQuickResponseRequest
     * @return Result of the DeleteQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickResponseResponse deleteQuickResponse(DeleteQuickResponseRequest deleteQuickResponseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQuickResponseRequest#builder()}
     * </p>
     *
     * @param deleteQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.DeleteQuickResponseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.DeleteQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/DeleteQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickResponseResponse deleteQuickResponse(
            Consumer<DeleteQuickResponseRequest.Builder> deleteQuickResponseRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return deleteQuickResponse(DeleteQuickResponseRequest.builder().applyMutation(deleteQuickResponseRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     *
     * @param getAiAgentRequest
     * @return Result of the GetAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAiAgentResponse getAIAgent(GetAiAgentRequest getAiAgentRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Q in Connect AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAiAgentRequest#builder()}
     * </p>
     *
     * @param getAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAiAgentRequest.Builder} to create a request.
     * @return Result of the GetAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAiAgentResponse getAIAgent(Consumer<GetAiAgentRequest.Builder> getAiAgentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return getAIAgent(GetAiAgentRequest.builder().applyMutation(getAiAgentRequest).build());
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     *
     * @param getAiPromptRequest
     * @return Result of the GetAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAiPromptResponse getAIPrompt(GetAiPromptRequest getAiPromptRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets and Amazon Q in Connect AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link GetAiPromptRequest#builder()}
     * </p>
     *
     * @param getAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAiPromptRequest.Builder} to create a request.
     * @return Result of the GetAIPrompt operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAiPromptResponse getAIPrompt(Consumer<GetAiPromptRequest.Builder> getAiPromptRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return getAIPrompt(GetAiPromptRequest.builder().applyMutation(getAiPromptRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     *
     * @param getAssistantRequest
     * @return Result of the GetAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssistantResponse getAssistant(GetAssistantRequest getAssistantRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssistantRequest#builder()}
     * </p>
     *
     * @param getAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAssistantRequest.Builder} to create a request.
     * @return Result of the GetAssistant operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistant" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssistantResponse getAssistant(Consumer<GetAssistantRequest.Builder> getAssistantRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getAssistant(GetAssistantRequest.builder().applyMutation(getAssistantRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     *
     * @param getAssistantAssociationRequest
     * @return Result of the GetAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssistantAssociationResponse getAssistantAssociation(GetAssistantAssociationRequest getAssistantAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an assistant association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssistantAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssistantAssociationRequest#builder()}
     * </p>
     *
     * @param getAssistantAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetAssistantAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssistantAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetAssistantAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetAssistantAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssistantAssociationResponse getAssistantAssociation(
            Consumer<GetAssistantAssociationRequest.Builder> getAssistantAssociationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return getAssistantAssociation(GetAssistantAssociationRequest.builder().applyMutation(getAssistantAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     *
     * @param getContentRequest
     * @return Result of the GetContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContentResponse getContent(GetContentRequest getContentRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves content, including a pre-signed URL to download the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentRequest.Builder} avoiding the need to
     * create one manually via {@link GetContentRequest#builder()}
     * </p>
     *
     * @param getContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentRequest.Builder} to create a request.
     * @return Result of the GetContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContentResponse getContent(Consumer<GetContentRequest.Builder> getContentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return getContent(GetContentRequest.builder().applyMutation(getContentRequest).build());
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getContentAssociationRequest
     * @return Result of the GetContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContentAssociationResponse getContentAssociation(GetContentAssociationRequest getContentAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the content association.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetContentAssociationRequest#builder()}
     * </p>
     *
     * @param getContentAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetContentAssociation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContentAssociationResponse getContentAssociation(
            Consumer<GetContentAssociationRequest.Builder> getContentAssociationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return getContentAssociation(GetContentAssociationRequest.builder().applyMutation(getContentAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     *
     * @param getContentSummaryRequest
     * @return Result of the GetContentSummary operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContentSummaryResponse getContentSummary(GetContentSummaryRequest getContentSummaryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves summary information about the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetContentSummaryRequest#builder()}
     * </p>
     *
     * @param getContentSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetContentSummaryRequest.Builder} to create a
     *        request.
     * @return Result of the GetContentSummary operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetContentSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetContentSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContentSummaryResponse getContentSummary(Consumer<GetContentSummaryRequest.Builder> getContentSummaryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getContentSummary(GetContentSummaryRequest.builder().applyMutation(getContentSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     *
     * @param getImportJobRequest
     * @return Result of the GetImportJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the started import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetImportJobRequest.Builder} to create a request.
     * @return Result of the GetImportJob operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     *
     * @param getKnowledgeBaseRequest
     * @return Result of the GetKnowledgeBase operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKnowledgeBaseRequest.Builder} avoiding the need
     * to create one manually via {@link GetKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param getKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return Result of the GetKnowledgeBase operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetKnowledgeBase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKnowledgeBaseResponse getKnowledgeBase(Consumer<GetKnowledgeBaseRequest.Builder> getKnowledgeBaseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getKnowledgeBase(GetKnowledgeBaseRequest.builder().applyMutation(getKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     *
     * @param getQuickResponseRequest
     * @return Result of the GetQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQuickResponseResponse getQuickResponse(GetQuickResponseRequest getQuickResponseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQuickResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetQuickResponseRequest#builder()}
     * </p>
     *
     * @param getQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetQuickResponseRequest.Builder} to create a
     *        request.
     * @return Result of the GetQuickResponse operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetQuickResponse" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQuickResponseResponse getQuickResponse(Consumer<GetQuickResponseRequest.Builder> getQuickResponseRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getQuickResponse(GetQuickResponseRequest.builder().applyMutation(getQuickResponseRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     *
     * @param getRecommendationsRequest
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses
     *             after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the
     *             Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent
     * calls, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html"
     * >NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code>
     * parameter. Short poll is the default behavior and only returns recommendations already available. To perform a
     * manual query against an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html"
     * >QueryAssistant</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetRecommendations" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses
     *             after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the
     *             Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default GetRecommendationsResponse getRecommendations(Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information for a specified session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.GetSessionRequest.Builder} to create a request.
     * @return Result of the GetSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return Result of the ListAIAgentVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAiAgentVersionsResponse listAIAgentVersions(ListAiAgentVersionsRequest listAiAgentVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List AI Agent versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAiAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAIAgentVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAiAgentVersionsResponse listAIAgentVersions(
            Consumer<ListAiAgentVersionsRequest.Builder> listAiAgentVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return listAIAgentVersions(ListAiAgentVersionsRequest.builder().applyMutation(listAiAgentVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client.listAIAgentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client
     *             .listAIAgentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client.listAIAgentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAiAgentVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIAgentVersionsIterable listAIAgentVersionsPaginator(ListAiAgentVersionsRequest listAiAgentVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return new ListAIAgentVersionsIterable(this, listAiAgentVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client.listAIAgentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client
     *             .listAIAgentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentVersionsIterable responses = client.listAIAgentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgentVersions(software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAiAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIAgentVersionsIterable listAIAgentVersionsPaginator(
            Consumer<ListAiAgentVersionsRequest.Builder> listAiAgentVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return listAIAgentVersionsPaginator(ListAiAgentVersionsRequest.builder().applyMutation(listAiAgentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     *
     * @param listAiAgentsRequest
     * @return Result of the ListAIAgents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAiAgentsResponse listAIAgents(ListAiAgentsRequest listAiAgentsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists AI Agents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiAgentsRequest#builder()}
     * </p>
     *
     * @param listAiAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest.Builder} to create a request.
     * @return Result of the ListAIAgents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAiAgentsResponse listAIAgents(Consumer<ListAiAgentsRequest.Builder> listAiAgentsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return listAIAgents(ListAiAgentsRequest.builder().applyMutation(listAiAgentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)} operation.</b>
     * </p>
     *
     * @param listAiAgentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIAgentsIterable listAIAgentsPaginator(ListAiAgentsRequest listAiAgentsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return new ListAIAgentsIterable(this, listAiAgentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIAgentsIterable responses = client.listAIAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIAgents(software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiAgentsRequest#builder()}
     * </p>
     *
     * @param listAiAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIAgentsIterable listAIAgentsPaginator(Consumer<ListAiAgentsRequest.Builder> listAiAgentsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return listAIAgentsPaginator(ListAiAgentsRequest.builder().applyMutation(listAiAgentsRequest).build());
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return Result of the ListAIPromptVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAiPromptVersionsResponse listAIPromptVersions(ListAiPromptVersionsRequest listAiPromptVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists AI Prompt versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiPromptVersionsRequest#builder()}
     * </p>
     *
     * @param listAiPromptVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAIPromptVersions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAiPromptVersionsResponse listAIPromptVersions(
            Consumer<ListAiPromptVersionsRequest.Builder> listAiPromptVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return listAIPromptVersions(ListAiPromptVersionsRequest.builder().applyMutation(listAiPromptVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client.listAIPromptVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client
     *             .listAIPromptVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client.listAIPromptVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAiPromptVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIPromptVersionsIterable listAIPromptVersionsPaginator(ListAiPromptVersionsRequest listAiPromptVersionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return new ListAIPromptVersionsIterable(this, listAiPromptVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client.listAIPromptVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client
     *             .listAIPromptVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptVersionsIterable responses = client.listAIPromptVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPromptVersions(software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAiPromptVersionsRequest#builder()}
     * </p>
     *
     * @param listAiPromptVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPromptVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPromptVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAIPromptVersionsIterable listAIPromptVersionsPaginator(
            Consumer<ListAiPromptVersionsRequest.Builder> listAiPromptVersionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return listAIPromptVersionsPaginator(ListAiPromptVersionsRequest.builder().applyMutation(listAiPromptVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     *
     * @param listAiPromptsRequest
     * @return Result of the ListAIPrompts operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAiPromptsResponse listAIPrompts(ListAiPromptsRequest listAiPromptsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiPromptsRequest#builder()}
     * </p>
     *
     * @param listAiPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest.Builder} to create a request.
     * @return Result of the ListAIPrompts operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAiPromptsResponse listAIPrompts(Consumer<ListAiPromptsRequest.Builder> listAiPromptsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return listAIPrompts(ListAiPromptsRequest.builder().applyMutation(listAiPromptsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)} operation.</b>
     * </p>
     *
     * @param listAiPromptsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIPromptsIterable listAIPromptsPaginator(ListAiPromptsRequest listAiPromptsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return new ListAIPromptsIterable(this, listAiPromptsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAIPromptsIterable responses = client.listAIPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAIPrompts(software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAiPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAiPromptsRequest#builder()}
     * </p>
     *
     * @param listAiPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAIPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAIPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAIPromptsIterable listAIPromptsPaginator(Consumer<ListAiPromptsRequest.Builder> listAiPromptsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return listAIPromptsPaginator(ListAiPromptsRequest.builder().applyMutation(listAiPromptsRequest).build());
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return Result of the ListAssistantAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsResponse listAssistantAssociations(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about assistant associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssistantAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssistantAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAssistantAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsResponse listAssistantAssociations(
            Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return listAssistantAssociations(ListAssistantAssociationsRequest.builder()
                .applyMutation(listAssistantAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client.listAssistantAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client
     *             .listAssistantAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client.listAssistantAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssistantAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsIterable listAssistantAssociationsPaginator(
            ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return new ListAssistantAssociationsIterable(this, listAssistantAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client.listAssistantAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client
     *             .listAssistantAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantAssociationsIterable responses = client.listAssistantAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistantAssociations(software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssistantAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssistantAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistantAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistantAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssistantAssociationsIterable listAssistantAssociationsPaginator(
            Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return listAssistantAssociationsPaginator(ListAssistantAssociationsRequest.builder()
                .applyMutation(listAssistantAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     *
     * @param listAssistantsRequest
     * @return Result of the ListAssistants operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsResponse listAssistants(ListAssistantsRequest listAssistantsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about assistants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssistantsRequest#builder()}
     * </p>
     *
     * @param listAssistantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest.Builder} to create a request.
     * @return Result of the ListAssistants operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsResponse listAssistants(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listAssistants(ListAssistantsRequest.builder().applyMutation(listAssistantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client.listAssistantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client
     *             .listAssistantsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client.listAssistantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation.</b>
     * </p>
     *
     * @param listAssistantsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsIterable listAssistantsPaginator(ListAssistantsRequest listAssistantsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return new ListAssistantsIterable(this, listAssistantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client.listAssistantsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client
     *             .listAssistantsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListAssistantsIterable responses = client.listAssistantsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssistants(software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssistantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssistantsRequest#builder()}
     * </p>
     *
     * @param listAssistantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListAssistants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListAssistants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssistantsIterable listAssistantsPaginator(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listAssistantsPaginator(ListAssistantsRequest.builder().applyMutation(listAssistantsRequest).build());
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return Result of the ListContentAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsResponse listContentAssociations(ListContentAssociationsRequest listContentAssociationsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the content associations.
     * </p>
     * <p>
     * For more information about content associations--what they are and when they are used--see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html">Integrate Amazon Q in
     * Connect with step-by-step guides</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContentAssociationsRequest#builder()}
     * </p>
     *
     * @param listContentAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListContentAssociations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsResponse listContentAssociations(
            Consumer<ListContentAssociationsRequest.Builder> listContentAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return listContentAssociations(ListContentAssociationsRequest.builder().applyMutation(listContentAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client.listContentAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client
     *             .listContentAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client.listContentAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContentAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsIterable listContentAssociationsPaginator(
            ListContentAssociationsRequest listContentAssociationsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return new ListContentAssociationsIterable(this, listContentAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client.listContentAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client
     *             .listContentAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentAssociationsIterable responses = client.listContentAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContentAssociations(software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContentAssociationsRequest#builder()}
     * </p>
     *
     * @param listContentAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContentAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContentAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContentAssociationsIterable listContentAssociationsPaginator(
            Consumer<ListContentAssociationsRequest.Builder> listContentAssociationsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return listContentAssociationsPaginator(ListContentAssociationsRequest.builder()
                .applyMutation(listContentAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     *
     * @param listContentsRequest
     * @return Result of the ListContents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsResponse listContents(ListContentsRequest listContentsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContentsRequest#builder()}
     * </p>
     *
     * @param listContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentsRequest.Builder} to create a request.
     * @return Result of the ListContents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsResponse listContents(Consumer<ListContentsRequest.Builder> listContentsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return listContents(ListContentsRequest.builder().applyMutation(listContentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListContentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)} operation.</b>
     * </p>
     *
     * @param listContentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsIterable listContentsPaginator(ListContentsRequest listContentsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return new ListContentsIterable(this, listContentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListContentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListContentsIterable responses = client.listContentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContents(software.amazon.awssdk.services.qconnect.model.ListContentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContentsRequest#builder()}
     * </p>
     *
     * @param listContentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListContentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListContents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListContents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContentsIterable listContentsPaginator(Consumer<ListContentsRequest.Builder> listContentsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return listContentsPaginator(ListContentsRequest.builder().applyMutation(listContentsRequest).build());
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     * @return Result of the ListImportJobs operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsResponse listImportJobs(ListImportJobsRequest listImportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest.Builder} to create a request.
     * @return Result of the ListImportJobs operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsResponse listImportJobs(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listImportJobs(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client
     *             .listImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsIterable listImportJobsPaginator(ListImportJobsRequest listImportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return new ListImportJobsIterable(this, listImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client
     *             .listImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListImportJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsIterable listImportJobsPaginator(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listImportJobsPaginator(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return Result of the ListKnowledgeBases operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the knowledge bases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListKnowledgeBases operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesResponse listKnowledgeBases(Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listKnowledgeBases(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client.listKnowledgeBasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client
     *             .listKnowledgeBasesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client.listKnowledgeBasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesIterable listKnowledgeBasesPaginator(ListKnowledgeBasesRequest listKnowledgeBasesRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return new ListKnowledgeBasesIterable(this, listKnowledgeBasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client.listKnowledgeBasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client
     *             .listKnowledgeBasesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListKnowledgeBasesIterable responses = client.listKnowledgeBasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListKnowledgeBases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKnowledgeBasesIterable listKnowledgeBasesPaginator(
            Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QConnectException {
        return listKnowledgeBasesPaginator(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return Result of the ListQuickResponses operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesResponse listQuickResponses(ListQuickResponsesRequest listQuickResponsesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickResponsesRequest#builder()}
     * </p>
     *
     * @param listQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest.Builder} to create a
     *        request.
     * @return Result of the ListQuickResponses operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesResponse listQuickResponses(Consumer<ListQuickResponsesRequest.Builder> listQuickResponsesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return listQuickResponses(ListQuickResponsesRequest.builder().applyMutation(listQuickResponsesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client.listQuickResponsesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client
     *             .listQuickResponsesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client.listQuickResponsesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQuickResponsesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesIterable listQuickResponsesPaginator(ListQuickResponsesRequest listQuickResponsesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return new ListQuickResponsesIterable(this, listQuickResponsesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client.listQuickResponsesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client
     *             .listQuickResponsesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.ListQuickResponsesIterable responses = client.listQuickResponsesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickResponses(software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickResponsesRequest#builder()}
     * </p>
     *
     * @param listQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQuickResponsesIterable listQuickResponsesPaginator(
            Consumer<ListQuickResponsesRequest.Builder> listQuickResponsesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return listQuickResponsesPaginator(ListQuickResponsesRequest.builder().applyMutation(listQuickResponsesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     * @return Result of the NotifyRecommendationsReceived operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(
            NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations.
     * You can use this API in conjunction with <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html"
     * >GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyRecommendationsReceivedRequest.Builder}
     * avoiding the need to create one manually via {@link NotifyRecommendationsReceivedRequest#builder()}
     * </p>
     *
     * @param notifyRecommendationsReceivedRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.NotifyRecommendationsReceivedRequest.Builder} to
     *        create a request.
     * @return Result of the NotifyRecommendationsReceived operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.NotifyRecommendationsReceived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/NotifyRecommendationsReceived"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(
            Consumer<NotifyRecommendationsReceivedRequest.Builder> notifyRecommendationsReceivedRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest.builder()
                .applyMutation(notifyRecommendationsReceivedRequest).build());
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides feedback against the specified assistant for the specified target. This API only supports generative
     * targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.PutFeedbackRequest.Builder} to create a request.
     * @return Result of the PutFeedback operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     *
     * @param queryAssistantRequest
     * @return Result of the QueryAssistant operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantResponse queryAssistant(QueryAssistantRequest queryAssistantRequest) throws RequestTimeoutException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you
     * will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect
     * JavaScript library (amazon-q-connectjs) into your applications.
     * </p>
     * </important>
     * <p>
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html">
     * GetRecommendations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link QueryAssistantRequest#builder()}
     * </p>
     *
     * @param queryAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest.Builder} to create a request.
     * @return Result of the QueryAssistant operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantResponse queryAssistant(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest)
            throws RequestTimeoutException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return queryAssistant(QueryAssistantRequest.builder().applyMutation(queryAssistantRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client.queryAssistantPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client
     *             .queryAssistantPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client.queryAssistantPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation.</b>
     * </p>
     *
     * @param queryAssistantRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantIterable queryAssistantPaginator(QueryAssistantRequest queryAssistantRequest)
            throws RequestTimeoutException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return new QueryAssistantIterable(this, queryAssistantRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client.queryAssistantPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client
     *             .queryAssistantPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.QueryAssistantIterable responses = client.queryAssistantPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryAssistant(software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryAssistantRequest.Builder} avoiding the need to
     * create one manually via {@link QueryAssistantRequest#builder()}
     * </p>
     *
     * @param queryAssistantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.QueryAssistant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/QueryAssistant" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after
     *             March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon
     *             Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     */
    @Deprecated
    default QueryAssistantIterable queryAssistantPaginator(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest)
            throws RequestTimeoutException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return queryAssistantPaginator(QueryAssistantRequest.builder().applyMutation(queryAssistantRequest).build());
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     * @return Result of the RemoveAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAssistantAiAgentResponse removeAssistantAIAgent(RemoveAssistantAiAgentRequest removeAssistantAiAgentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAssistantAiAgentRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveAssistantAiAgentRequest#builder()}
     * </p>
     *
     * @param removeAssistantAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.RemoveAssistantAiAgentRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAssistantAiAgentResponse removeAssistantAIAgent(
            Consumer<RemoveAssistantAiAgentRequest.Builder> removeAssistantAiAgentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return removeAssistantAIAgent(RemoveAssistantAiAgentRequest.builder().applyMutation(removeAssistantAiAgentRequest)
                .build());
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     * @return Result of the RemoveKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(
            RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a URI template from a knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveKnowledgeBaseTemplateUriRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveKnowledgeBaseTemplateUriRequest#builder()}
     * </p>
     *
     * @param removeKnowledgeBaseTemplateUriRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest.Builder} to
     *        create a request.
     * @return Result of the RemoveKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.RemoveKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/RemoveKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(
            Consumer<RemoveKnowledgeBaseTemplateUriRequest.Builder> removeKnowledgeBaseTemplateUriRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest.builder()
                .applyMutation(removeKnowledgeBaseTemplateUriRequest).build());
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     *
     * @param searchContentRequest
     * @return Result of the SearchContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentResponse searchContent(SearchContentRequest searchContentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContentRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContentRequest#builder()}
     * </p>
     *
     * @param searchContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchContentRequest.Builder} to create a request.
     * @return Result of the SearchContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentResponse searchContent(Consumer<SearchContentRequest.Builder> searchContentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return searchContent(SearchContentRequest.builder().applyMutation(searchContentRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchContentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)} operation.</b>
     * </p>
     *
     * @param searchContentRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentIterable searchContentPaginator(SearchContentRequest searchContentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return new SearchContentIterable(this, searchContentRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchContentResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchContentIterable responses = client.searchContentPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContent(software.amazon.awssdk.services.qconnect.model.SearchContentRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContentRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContentRequest#builder()}
     * </p>
     *
     * @param searchContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchContentRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchContent" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchContentIterable searchContentPaginator(Consumer<SearchContentRequest.Builder> searchContentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return searchContentPaginator(SearchContentRequest.builder().applyMutation(searchContentRequest).build());
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return Result of the SearchQuickResponses operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesResponse searchQuickResponses(SearchQuickResponsesRequest searchQuickResponsesRequest)
            throws RequestTimeoutException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuickResponsesRequest#builder()}
     * </p>
     *
     * @param searchQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchQuickResponses operation returned by the service.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesResponse searchQuickResponses(
            Consumer<SearchQuickResponsesRequest.Builder> searchQuickResponsesRequest) throws RequestTimeoutException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        return searchQuickResponses(SearchQuickResponsesRequest.builder().applyMutation(searchQuickResponsesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client.searchQuickResponsesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client
     *             .searchQuickResponsesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client.searchQuickResponsesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchQuickResponsesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesIterable searchQuickResponsesPaginator(SearchQuickResponsesRequest searchQuickResponsesRequest)
            throws RequestTimeoutException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return new SearchQuickResponsesIterable(this, searchQuickResponsesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client.searchQuickResponsesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client
     *             .searchQuickResponsesPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchQuickResponsesIterable responses = client.searchQuickResponsesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuickResponses(software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuickResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuickResponsesRequest#builder()}
     * </p>
     *
     * @param searchQuickResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RequestTimeoutException
     *         The request reached the service more than 15 minutes after the date stamp on the request or more than 15
     *         minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request
     *         is more than 15 minutes in the future.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchQuickResponses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchQuickResponses" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchQuickResponsesIterable searchQuickResponsesPaginator(
            Consumer<SearchQuickResponsesRequest.Builder> searchQuickResponsesRequest) throws RequestTimeoutException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            QConnectException {
        return searchQuickResponsesPaginator(SearchQuickResponsesRequest.builder().applyMutation(searchQuickResponsesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     *
     * @param searchSessionsRequest
     * @return Result of the SearchSessions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsResponse searchSessions(SearchSessionsRequest searchSessionsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSessionsRequest#builder()}
     * </p>
     *
     * @param searchSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest.Builder} to create a request.
     * @return Result of the SearchSessions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsResponse searchSessions(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return searchSessions(SearchSessionsRequest.builder().applyMutation(searchSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client.searchSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client
     *             .searchSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client.searchSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation.</b>
     * </p>
     *
     * @param searchSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsIterable searchSessionsPaginator(SearchSessionsRequest searchSessionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return new SearchSessionsIterable(this, searchSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client.searchSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client
     *             .searchSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qconnect.paginators.SearchSessionsIterable responses = client.searchSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSessions(software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSessionsRequest#builder()}
     * </p>
     *
     * @param searchSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.SearchSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/SearchSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSessionsIterable searchSessionsPaginator(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return searchSessionsPaginator(SearchSessionsRequest.builder().applyMutation(searchSessionsRequest).build());
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     *
     * @param startContentUploadRequest
     * @return Result of the StartContentUpload operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContentUploadResponse startContentUpload(StartContentUploadRequest startContentUploadRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL
     * with your file, making sure to include the required headers. Then use <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html">CreateContent</a>
     * to finalize the content creation process or <a
     * href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html">UpdateContent</a>
     * to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContentUploadRequest.Builder} avoiding the
     * need to create one manually via {@link StartContentUploadRequest#builder()}
     * </p>
     *
     * @param startContentUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.StartContentUploadRequest.Builder} to create a
     *        request.
     * @return Result of the StartContentUpload operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartContentUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartContentUpload" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContentUploadResponse startContentUpload(Consumer<StartContentUploadRequest.Builder> startContentUploadRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return startContentUpload(StartContentUploadRequest.builder().applyMutation(startContentUploadRequest).build());
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param startImportJobRequest
     * @return Result of the StartImportJob operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportJobResponse startImportJob(StartImportJobRequest startImportJobRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling
     * this API, use <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>
     * to upload an asset that contains the resource data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses.
     * For information about how to format the csv file for importing quick responses, see <a
     * href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportJobRequest#builder()}
     * </p>
     *
     * @param startImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.StartImportJobRequest.Builder} to create a request.
     * @return Result of the StartImportJob operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws ServiceQuotaExceededException
     *         You've exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use service quotas to request a service quota increase.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.StartImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/StartImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportJobResponse startImportJob(Consumer<StartImportJobRequest.Builder> startImportJobRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return startImportJob(StartImportJobRequest.builder().applyMutation(startImportJobRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         Amazon Q in Connect throws this exception if you have too many tags in your tag set.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         Amazon Q in Connect throws this exception if you have too many tags in your tag set.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws TooManyTagsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     *
     * @param updateAiAgentRequest
     * @return Result of the UpdateAIAgent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAiAgentResponse updateAIAgent(UpdateAiAgentRequest updateAiAgentRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AI Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAiAgentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAiAgentRequest#builder()}
     * </p>
     *
     * @param updateAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAiAgentRequest.Builder} to create a request.
     * @return Result of the UpdateAIAgent operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAiAgentResponse updateAIAgent(Consumer<UpdateAiAgentRequest.Builder> updateAiAgentRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return updateAIAgent(UpdateAiAgentRequest.builder().applyMutation(updateAiAgentRequest).build());
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     *
     * @param updateAiPromptRequest
     * @return Result of the UpdateAIPrompt operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAiPromptResponse updateAIPrompt(UpdateAiPromptRequest updateAiPromptRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AI Prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAiPromptRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAiPromptRequest#builder()}
     * </p>
     *
     * @param updateAiPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAiPromptRequest.Builder} to create a request.
     * @return Result of the UpdateAIPrompt operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAIPrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAIPrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAiPromptResponse updateAIPrompt(Consumer<UpdateAiPromptRequest.Builder> updateAiPromptRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        return updateAIPrompt(UpdateAiPromptRequest.builder().applyMutation(updateAiPromptRequest).build());
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     * @return Result of the UpdateAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssistantAiAgentResponse updateAssistantAIAgent(UpdateAssistantAiAgentRequest updateAssistantAiAgentRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the AI Agent that is set for use by defafult on an Amazon Q in Connect Assistant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssistantAiAgentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssistantAiAgentRequest#builder()}
     * </p>
     *
     * @param updateAssistantAiAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateAssistantAiAgentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssistantAIAgent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateAssistantAIAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateAssistantAIAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssistantAiAgentResponse updateAssistantAIAgent(
            Consumer<UpdateAssistantAiAgentRequest.Builder> updateAssistantAiAgentRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            QConnectException {
        return updateAssistantAIAgent(UpdateAssistantAiAgentRequest.builder().applyMutation(updateAssistantAiAgentRequest)
                .build());
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     *
     * @param updateContentRequest
     * @return Result of the UpdateContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContentResponse updateContent(UpdateContentRequest updateContentRequest) throws ValidationException,
            AccessDeniedException, PreconditionFailedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContentRequest#builder()}
     * </p>
     *
     * @param updateContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateContentRequest.Builder} to create a request.
     * @return Result of the UpdateContent operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateContent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContentResponse updateContent(Consumer<UpdateContentRequest.Builder> updateContentRequest)
            throws ValidationException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return updateContent(UpdateContentRequest.builder().applyMutation(updateContentRequest).build());
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     * @return Result of the UpdateKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(
            UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL.
     * Include a single variable in <code>&#36{variable}</code> format; this interpolated by Amazon Q in Connect using
     * ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can
     * set the template URI to
     * <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*&#36{Id}*&#47;view</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKnowledgeBaseTemplateUriRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateKnowledgeBaseTemplateUriRequest#builder()}
     * </p>
     *
     * @param updateKnowledgeBaseTemplateUriRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateKnowledgeBaseTemplateUri operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateKnowledgeBaseTemplateUri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateKnowledgeBaseTemplateUri"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(
            Consumer<UpdateKnowledgeBaseTemplateUriRequest.Builder> updateKnowledgeBaseTemplateUriRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest.builder()
                .applyMutation(updateKnowledgeBaseTemplateUriRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     *
     * @param updateQuickResponseRequest
     * @return Result of the UpdateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateQuickResponseResponse updateQuickResponse(UpdateQuickResponseRequest updateQuickResponseRequest)
            throws ConflictException, ValidationException, AccessDeniedException, PreconditionFailedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q in Connect quick response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuickResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQuickResponseRequest#builder()}
     * </p>
     *
     * @param updateQuickResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateQuickResponseRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQuickResponse operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. For example,
     *         if you're using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a
     *         conflicting resource (usually with the same name) is being created or mutated.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws PreconditionFailedException
     *         The provided <code>revisionId</code> does not match, indicating the content has been modified since it
     *         was last read.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateQuickResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateQuickResponse" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateQuickResponseResponse updateQuickResponse(
            Consumer<UpdateQuickResponseRequest.Builder> updateQuickResponseRequest) throws ConflictException,
            ValidationException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, QConnectException {
        return updateQuickResponse(UpdateQuickResponseRequest.builder().applyMutation(updateQuickResponseRequest).build());
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     *
     * @param updateSessionRequest
     * @return Result of the UpdateSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSessionResponse updateSession(UpdateSessionRequest updateSessionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect
     * updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateSessionRequest.Builder} to create a request.
     * @return Result of the UpdateSession operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSessionResponse updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     *
     * @param updateSessionDataRequest
     * @return Result of the UpdateSessionData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSessionDataResponse updateSessionData(UpdateSessionDataRequest updateSessionDataRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data stored on an Amazon Q in Connect Session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionDataRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSessionDataRequest#builder()}
     * </p>
     *
     * @param updateSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qconnect.model.UpdateSessionDataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSessionData operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by a service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QConnectClient.UpdateSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/UpdateSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSessionDataResponse updateSessionData(Consumer<UpdateSessionDataRequest.Builder> updateSessionDataRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, QConnectException {
        return updateSessionData(UpdateSessionDataRequest.builder().applyMutation(updateSessionDataRequest).build());
    }

    /**
     * Create a {@link QConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QConnectClient}.
     */
    static QConnectClientBuilder builder() {
        return new DefaultQConnectClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default QConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
