/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type that specifies the AI Agent ID configuration data when mapping an AI Agents to be used for an AI Agent type on
 * a session or assistant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIAgentConfigurationData implements SdkPojo, Serializable,
        ToCopyableBuilder<AIAgentConfigurationData.Builder, AIAgentConfigurationData> {
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentId").getter(getter(AIAgentConfigurationData::aiAgentId)).setter(setter(Builder::aiAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aiAgentId;

    private AIAgentConfigurationData(BuilderImpl builder) {
        this.aiAgentId = builder.aiAgentId;
    }

    /**
     * <p>
     * The ID of the AI Agent to be configured.
     * </p>
     * 
     * @return The ID of the AI Agent to be configured.
     */
    public final String aiAgentId() {
        return aiAgentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIAgentConfigurationData)) {
            return false;
        }
        AIAgentConfigurationData other = (AIAgentConfigurationData) obj;
        return Objects.equals(aiAgentId(), other.aiAgentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIAgentConfigurationData").add("AiAgentId", aiAgentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentId":
            return Optional.ofNullable(clazz.cast(aiAgentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIAgentConfigurationData, T> g) {
        return obj -> g.apply((AIAgentConfigurationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIAgentConfigurationData> {
        /**
         * <p>
         * The ID of the AI Agent to be configured.
         * </p>
         * 
         * @param aiAgentId
         *        The ID of the AI Agent to be configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentId(String aiAgentId);
    }

    static final class BuilderImpl implements Builder {
        private String aiAgentId;

        private BuilderImpl() {
        }

        private BuilderImpl(AIAgentConfigurationData model) {
            aiAgentId(model.aiAgentId);
        }

        public final String getAiAgentId() {
            return aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        @Override
        public AIAgentConfigurationData build() {
            return new AIAgentConfigurationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
