/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the AI Agent version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIAgentVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AIAgentVersionSummary.Builder, AIAgentVersionSummary> {
    private static final SdkField<AIAgentSummary> AI_AGENT_SUMMARY_FIELD = SdkField
            .<AIAgentSummary> builder(MarshallingType.SDK_POJO).memberName("aiAgentSummary")
            .getter(getter(AIAgentVersionSummary::aiAgentSummary)).setter(setter(Builder::aiAgentSummary))
            .constructor(AIAgentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentSummary").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(AIAgentVersionSummary::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_SUMMARY_FIELD,
            VERSION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AIAgentSummary aiAgentSummary;

    private final Long versionNumber;

    private AIAgentVersionSummary(BuilderImpl builder) {
        this.aiAgentSummary = builder.aiAgentSummary;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The data for the summary of the AI Agent version.
     * </p>
     * 
     * @return The data for the summary of the AI Agent version.
     */
    public final AIAgentSummary aiAgentSummary() {
        return aiAgentSummary;
    }

    /**
     * <p>
     * The version number for this AI Agent version.
     * </p>
     * 
     * @return The version number for this AI Agent version.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIAgentVersionSummary)) {
            return false;
        }
        AIAgentVersionSummary other = (AIAgentVersionSummary) obj;
        return Objects.equals(aiAgentSummary(), other.aiAgentSummary()) && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIAgentVersionSummary").add("AiAgentSummary", aiAgentSummary())
                .add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentSummary":
            return Optional.ofNullable(clazz.cast(aiAgentSummary()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIAgentVersionSummary, T> g) {
        return obj -> g.apply((AIAgentVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIAgentVersionSummary> {
        /**
         * <p>
         * The data for the summary of the AI Agent version.
         * </p>
         * 
         * @param aiAgentSummary
         *        The data for the summary of the AI Agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentSummary(AIAgentSummary aiAgentSummary);

        /**
         * <p>
         * The data for the summary of the AI Agent version.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentSummary.Builder} avoiding the need
         * to create one manually via {@link AIAgentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #aiAgentSummary(AIAgentSummary)}.
         * 
         * @param aiAgentSummary
         *        a consumer that will call methods on {@link AIAgentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiAgentSummary(AIAgentSummary)
         */
        default Builder aiAgentSummary(Consumer<AIAgentSummary.Builder> aiAgentSummary) {
            return aiAgentSummary(AIAgentSummary.builder().applyMutation(aiAgentSummary).build());
        }

        /**
         * <p>
         * The version number for this AI Agent version.
         * </p>
         * 
         * @param versionNumber
         *        The version number for this AI Agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl implements Builder {
        private AIAgentSummary aiAgentSummary;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AIAgentVersionSummary model) {
            aiAgentSummary(model.aiAgentSummary);
            versionNumber(model.versionNumber);
        }

        public final AIAgentSummary.Builder getAiAgentSummary() {
            return aiAgentSummary != null ? aiAgentSummary.toBuilder() : null;
        }

        public final void setAiAgentSummary(AIAgentSummary.BuilderImpl aiAgentSummary) {
            this.aiAgentSummary = aiAgentSummary != null ? aiAgentSummary.build() : null;
        }

        @Override
        public final Builder aiAgentSummary(AIAgentSummary aiAgentSummary) {
            this.aiAgentSummary = aiAgentSummary;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public AIAgentVersionSummary build() {
            return new AIAgentVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
