/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data for the AI Prompt
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIPromptData implements SdkPojo, Serializable, ToCopyableBuilder<AIPromptData.Builder, AIPromptData> {
    private static final SdkField<String> AI_PROMPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptArn").getter(getter(AIPromptData::aiPromptArn)).setter(setter(Builder::aiPromptArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptArn").build()).build();

    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptId").getter(getter(AIPromptData::aiPromptId)).setter(setter(Builder::aiPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptId").build()).build();

    private static final SdkField<String> API_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiFormat").getter(getter(AIPromptData::apiFormatAsString)).setter(setter(Builder::apiFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiFormat").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AIPromptData::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AIPromptData::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AIPromptData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(AIPromptData::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTime").getter(getter(AIPromptData::modifiedTime)).setter(setter(Builder::modifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AIPromptData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("origin")
            .getter(getter(AIPromptData::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AIPromptData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AIPromptData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<AIPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(AIPromptData::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(AIPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(AIPromptData::templateTypeAsString)).setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AIPromptData::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(AIPromptData::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_ARN_FIELD,
            AI_PROMPT_ID_FIELD, API_FORMAT_FIELD, ASSISTANT_ARN_FIELD, ASSISTANT_ID_FIELD, DESCRIPTION_FIELD, MODEL_ID_FIELD,
            MODIFIED_TIME_FIELD, NAME_FIELD, ORIGIN_FIELD, STATUS_FIELD, TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD,
            TEMPLATE_TYPE_FIELD, TYPE_FIELD, VISIBILITY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aiPromptArn;

    private final String aiPromptId;

    private final String apiFormat;

    private final String assistantArn;

    private final String assistantId;

    private final String description;

    private final String modelId;

    private final Instant modifiedTime;

    private final String name;

    private final String origin;

    private final String status;

    private final Map<String, String> tags;

    private final AIPromptTemplateConfiguration templateConfiguration;

    private final String templateType;

    private final String type;

    private final String visibilityStatus;

    private AIPromptData(BuilderImpl builder) {
        this.aiPromptArn = builder.aiPromptArn;
        this.aiPromptId = builder.aiPromptId;
        this.apiFormat = builder.apiFormat;
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.description = builder.description;
        this.modelId = builder.modelId;
        this.modifiedTime = builder.modifiedTime;
        this.name = builder.name;
        this.origin = builder.origin;
        this.status = builder.status;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.templateType = builder.templateType;
        this.type = builder.type;
        this.visibilityStatus = builder.visibilityStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AI Prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AI Prompt.
     */
    public final String aiPromptArn() {
        return aiPromptArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI prompt.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI prompt.
     */
    public final String aiPromptId() {
        return aiPromptId;
    }

    /**
     * <p>
     * The API format used for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API format used for this AI Prompt.
     * @see AIPromptAPIFormat
     */
    public final AIPromptAPIFormat apiFormat() {
        return AIPromptAPIFormat.fromValue(apiFormat);
    }

    /**
     * <p>
     * The API format used for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API format used for this AI Prompt.
     * @see AIPromptAPIFormat
     */
    public final String apiFormatAsString() {
        return apiFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The description of the AI Prompt.
     * </p>
     * 
     * @return The description of the AI Prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the model used for this AI Prompt. Model Ids supported are:
     * <code>CLAUDE_3_HAIKU_20240307_V1</code>.
     * </p>
     * 
     * @return The identifier of the model used for this AI Prompt. Model Ids supported are:
     *         <code>CLAUDE_3_HAIKU_20240307_V1</code>.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The time the AI Prompt was last modified.
     * </p>
     * 
     * @return The time the AI Prompt was last modified.
     */
    public final Instant modifiedTime() {
        return modifiedTime;
    }

    /**
     * <p>
     * The name of the AI Prompt
     * </p>
     * 
     * @return The name of the AI Prompt
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     *         <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * @see Origin
     */
    public final Origin origin() {
        return Origin.fromValue(origin);
    }

    /**
     * <p>
     * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
     *         <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
     * @see Origin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Prompt.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Prompt.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration of the prompt template for this AI Prompt.
     * </p>
     * 
     * @return The configuration of the prompt template for this AI Prompt.
     */
    public final AIPromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final AIPromptTemplateType templateType() {
        return AIPromptTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final AIPromptType type() {
        return AIPromptType.fromValue(type);
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(apiFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIPromptData)) {
            return false;
        }
        AIPromptData other = (AIPromptData) obj;
        return Objects.equals(aiPromptArn(), other.aiPromptArn()) && Objects.equals(aiPromptId(), other.aiPromptId())
                && Objects.equals(apiFormatAsString(), other.apiFormatAsString())
                && Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(description(), other.description()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(modifiedTime(), other.modifiedTime()) && Objects.equals(name(), other.name())
                && Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIPromptData").add("AiPromptArn", aiPromptArn()).add("AiPromptId", aiPromptId())
                .add("ApiFormat", apiFormatAsString()).add("AssistantArn", assistantArn()).add("AssistantId", assistantId())
                .add("Description", description()).add("ModelId", modelId()).add("ModifiedTime", modifiedTime())
                .add("Name", name()).add("Origin", originAsString()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("TemplateConfiguration", templateConfiguration())
                .add("TemplateType", templateTypeAsString()).add("Type", typeAsString())
                .add("VisibilityStatus", visibilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiPromptArn":
            return Optional.ofNullable(clazz.cast(aiPromptArn()));
        case "aiPromptId":
            return Optional.ofNullable(clazz.cast(aiPromptId()));
        case "apiFormat":
            return Optional.ofNullable(clazz.cast(apiFormatAsString()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modifiedTime":
            return Optional.ofNullable(clazz.cast(modifiedTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIPromptData, T> g) {
        return obj -> g.apply((AIPromptData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIPromptData> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AI Prompt.
         * </p>
         * 
         * @param aiPromptArn
         *        The Amazon Resource Name (ARN) of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptArn(String aiPromptArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param aiPromptId
         *        The identifier of the Amazon Q in Connect AI prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptId(String aiPromptId);

        /**
         * <p>
         * The API format used for this AI Prompt.
         * </p>
         * 
         * @param apiFormat
         *        The API format used for this AI Prompt.
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(String apiFormat);

        /**
         * <p>
         * The API format used for this AI Prompt.
         * </p>
         * 
         * @param apiFormat
         *        The API format used for this AI Prompt.
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(AIPromptAPIFormat apiFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The description of the AI Prompt.
         * </p>
         * 
         * @param description
         *        The description of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the model used for this AI Prompt. Model Ids supported are:
         * <code>CLAUDE_3_HAIKU_20240307_V1</code>.
         * </p>
         * 
         * @param modelId
         *        The identifier of the model used for this AI Prompt. Model Ids supported are:
         *        <code>CLAUDE_3_HAIKU_20240307_V1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The time the AI Prompt was last modified.
         * </p>
         * 
         * @param modifiedTime
         *        The time the AI Prompt was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTime(Instant modifiedTime);

        /**
         * <p>
         * The name of the AI Prompt
         * </p>
         * 
         * @param name
         *        The name of the AI Prompt
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * </p>
         * 
         * @param origin
         *        The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         *        <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(String origin);

        /**
         * <p>
         * The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         * <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * </p>
         * 
         * @param origin
         *        The origin of the AI Prompt. <code>SYSTEM</code> for a default AI Prompt created by Q in Connect or
         *        <code>CUSTOMER</code> for an AI Prompt created by calling AI Prompt creation APIs.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(Origin origin);

        /**
         * <p>
         * The status of the AI Prompt.
         * </p>
         * 
         * @param status
         *        The status of the AI Prompt.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the AI Prompt.
         * </p>
         * 
         * @param status
         *        The status of the AI Prompt.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration of the prompt template for this AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(AIPromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link AIPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(AIPromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(AIPromptTemplateType templateType);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(AIPromptType type);

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);
    }

    static final class BuilderImpl implements Builder {
        private String aiPromptArn;

        private String aiPromptId;

        private String apiFormat;

        private String assistantArn;

        private String assistantId;

        private String description;

        private String modelId;

        private Instant modifiedTime;

        private String name;

        private String origin;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AIPromptTemplateConfiguration templateConfiguration;

        private String templateType;

        private String type;

        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AIPromptData model) {
            aiPromptArn(model.aiPromptArn);
            aiPromptId(model.aiPromptId);
            apiFormat(model.apiFormat);
            assistantArn(model.assistantArn);
            assistantId(model.assistantId);
            description(model.description);
            modelId(model.modelId);
            modifiedTime(model.modifiedTime);
            name(model.name);
            origin(model.origin);
            status(model.status);
            tags(model.tags);
            templateConfiguration(model.templateConfiguration);
            templateType(model.templateType);
            type(model.type);
            visibilityStatus(model.visibilityStatus);
        }

        public final String getAiPromptArn() {
            return aiPromptArn;
        }

        public final void setAiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
        }

        @Override
        public final Builder aiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
            return this;
        }

        public final String getAiPromptId() {
            return aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getApiFormat() {
            return apiFormat;
        }

        public final void setApiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
        }

        @Override
        public final Builder apiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        @Override
        public final Builder apiFormat(AIPromptAPIFormat apiFormat) {
            this.apiFormat(apiFormat == null ? null : apiFormat.toString());
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final Instant getModifiedTime() {
            return modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(AIPromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIPromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        @Override
        public AIPromptData build() {
            return new AIPromptData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
