/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A typed union that specifies the configuration for a prompt template based on its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIPromptTemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AIPromptTemplateConfiguration.Builder, AIPromptTemplateConfiguration> {
    private static final SdkField<TextFullAIPromptEditTemplateConfiguration> TEXT_FULL_AI_PROMPT_EDIT_TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TextFullAIPromptEditTemplateConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("textFullAIPromptEditTemplateConfiguration")
            .getter(getter(AIPromptTemplateConfiguration::textFullAIPromptEditTemplateConfiguration))
            .setter(setter(Builder::textFullAIPromptEditTemplateConfiguration))
            .constructor(TextFullAIPromptEditTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("textFullAIPromptEditTemplateConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEXT_FULL_AI_PROMPT_EDIT_TEMPLATE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration;

    private final Type type;

    private AIPromptTemplateConfiguration(BuilderImpl builder) {
        this.textFullAIPromptEditTemplateConfiguration = builder.textFullAIPromptEditTemplateConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration for a prompt template that supports full textual prompt configuration using a YAML prompt.
     * </p>
     * 
     * @return The configuration for a prompt template that supports full textual prompt configuration using a YAML
     *         prompt.
     */
    public final TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration() {
        return textFullAIPromptEditTemplateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textFullAIPromptEditTemplateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIPromptTemplateConfiguration)) {
            return false;
        }
        AIPromptTemplateConfiguration other = (AIPromptTemplateConfiguration) obj;
        return Objects.equals(textFullAIPromptEditTemplateConfiguration(), other.textFullAIPromptEditTemplateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIPromptTemplateConfiguration")
                .add("TextFullAIPromptEditTemplateConfiguration", textFullAIPromptEditTemplateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textFullAIPromptEditTemplateConfiguration":
            return Optional.ofNullable(clazz.cast(textFullAIPromptEditTemplateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #textFullAIPromptEditTemplateConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * The configuration for a prompt template that supports full textual prompt configuration using a YAML prompt.
     * </p>
     * 
     * @param textFullAIPromptEditTemplateConfiguration
     *        The configuration for a prompt template that supports full textual prompt configuration using a YAML
     *        prompt.
     */
    public static AIPromptTemplateConfiguration fromTextFullAIPromptEditTemplateConfiguration(
            TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration) {
        return builder().textFullAIPromptEditTemplateConfiguration(textFullAIPromptEditTemplateConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #textFullAIPromptEditTemplateConfiguration()} initialized to the
     * given value.
     *
     * <p>
     * The configuration for a prompt template that supports full textual prompt configuration using a YAML prompt.
     * </p>
     * 
     * @param textFullAIPromptEditTemplateConfiguration
     *        The configuration for a prompt template that supports full textual prompt configuration using a YAML
     *        prompt.
     */
    public static AIPromptTemplateConfiguration fromTextFullAIPromptEditTemplateConfiguration(
            Consumer<TextFullAIPromptEditTemplateConfiguration.Builder> textFullAIPromptEditTemplateConfiguration) {
        TextFullAIPromptEditTemplateConfiguration.Builder builder = TextFullAIPromptEditTemplateConfiguration.builder();
        textFullAIPromptEditTemplateConfiguration.accept(builder);
        return fromTextFullAIPromptEditTemplateConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIPromptTemplateConfiguration, T> g) {
        return obj -> g.apply((AIPromptTemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIPromptTemplateConfiguration> {
        /**
         * <p>
         * The configuration for a prompt template that supports full textual prompt configuration using a YAML prompt.
         * </p>
         * 
         * @param textFullAIPromptEditTemplateConfiguration
         *        The configuration for a prompt template that supports full textual prompt configuration using a YAML
         *        prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textFullAIPromptEditTemplateConfiguration(
                TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration);

        /**
         * <p>
         * The configuration for a prompt template that supports full textual prompt configuration using a YAML prompt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TextFullAIPromptEditTemplateConfiguration.Builder} avoiding the need to create one manually via
         * {@link TextFullAIPromptEditTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextFullAIPromptEditTemplateConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #textFullAIPromptEditTemplateConfiguration(TextFullAIPromptEditTemplateConfiguration)}.
         * 
         * @param textFullAIPromptEditTemplateConfiguration
         *        a consumer that will call methods on {@link TextFullAIPromptEditTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textFullAIPromptEditTemplateConfiguration(TextFullAIPromptEditTemplateConfiguration)
         */
        default Builder textFullAIPromptEditTemplateConfiguration(
                Consumer<TextFullAIPromptEditTemplateConfiguration.Builder> textFullAIPromptEditTemplateConfiguration) {
            return textFullAIPromptEditTemplateConfiguration(TextFullAIPromptEditTemplateConfiguration.builder()
                    .applyMutation(textFullAIPromptEditTemplateConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AIPromptTemplateConfiguration model) {
            textFullAIPromptEditTemplateConfiguration(model.textFullAIPromptEditTemplateConfiguration);
        }

        public final TextFullAIPromptEditTemplateConfiguration.Builder getTextFullAIPromptEditTemplateConfiguration() {
            return textFullAIPromptEditTemplateConfiguration != null ? textFullAIPromptEditTemplateConfiguration.toBuilder()
                    : null;
        }

        public final void setTextFullAIPromptEditTemplateConfiguration(
                TextFullAIPromptEditTemplateConfiguration.BuilderImpl textFullAIPromptEditTemplateConfiguration) {
            Object oldValue = this.textFullAIPromptEditTemplateConfiguration;
            this.textFullAIPromptEditTemplateConfiguration = textFullAIPromptEditTemplateConfiguration != null ? textFullAIPromptEditTemplateConfiguration
                    .build() : null;
            handleUnionValueChange(Type.TEXT_FULL_AI_PROMPT_EDIT_TEMPLATE_CONFIGURATION, oldValue,
                    this.textFullAIPromptEditTemplateConfiguration);
        }

        @Override
        public final Builder textFullAIPromptEditTemplateConfiguration(
                TextFullAIPromptEditTemplateConfiguration textFullAIPromptEditTemplateConfiguration) {
            Object oldValue = this.textFullAIPromptEditTemplateConfiguration;
            this.textFullAIPromptEditTemplateConfiguration = textFullAIPromptEditTemplateConfiguration;
            handleUnionValueChange(Type.TEXT_FULL_AI_PROMPT_EDIT_TEMPLATE_CONFIGURATION, oldValue,
                    this.textFullAIPromptEditTemplateConfiguration);
            return this;
        }

        @Override
        public AIPromptTemplateConfiguration build() {
            return new AIPromptTemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AIPromptTemplateConfiguration#type()
     */
    public enum Type {
        TEXT_FULL_AI_PROMPT_EDIT_TEMPLATE_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
