/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the <code>ANSWER_RECOMMENDATION</code> AI Agent type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnswerRecommendationAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnswerRecommendationAIAgentConfiguration.Builder, AnswerRecommendationAIAgentConfiguration> {
    private static final SdkField<String> ANSWER_GENERATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("answerGenerationAIPromptId")
            .getter(getter(AnswerRecommendationAIAgentConfiguration::answerGenerationAIPromptId))
            .setter(setter(Builder::answerGenerationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("answerGenerationAIPromptId").build())
            .build();

    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField
            .<List<AssociationConfiguration>> builder(MarshallingType.LIST)
            .memberName("associationConfigurations")
            .getter(getter(AnswerRecommendationAIAgentConfiguration::associationConfigurations))
            .setter(setter(Builder::associationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INTENT_LABELING_GENERATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("intentLabelingGenerationAIPromptId")
            .getter(getter(AnswerRecommendationAIAgentConfiguration::intentLabelingGenerationAIPromptId))
            .setter(setter(Builder::intentLabelingGenerationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentLabelingGenerationAIPromptId")
                    .build()).build();

    private static final SdkField<String> QUERY_REFORMULATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("queryReformulationAIPromptId")
            .getter(getter(AnswerRecommendationAIAgentConfiguration::queryReformulationAIPromptId))
            .setter(setter(Builder::queryReformulationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryReformulationAIPromptId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANSWER_GENERATION_AI_PROMPT_ID_FIELD, ASSOCIATION_CONFIGURATIONS_FIELD,
            INTENT_LABELING_GENERATION_AI_PROMPT_ID_FIELD, QUERY_REFORMULATION_AI_PROMPT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String answerGenerationAIPromptId;

    private final List<AssociationConfiguration> associationConfigurations;

    private final String intentLabelingGenerationAIPromptId;

    private final String queryReformulationAIPromptId;

    private AnswerRecommendationAIAgentConfiguration(BuilderImpl builder) {
        this.answerGenerationAIPromptId = builder.answerGenerationAIPromptId;
        this.associationConfigurations = builder.associationConfigurations;
        this.intentLabelingGenerationAIPromptId = builder.intentLabelingGenerationAIPromptId;
        this.queryReformulationAIPromptId = builder.queryReformulationAIPromptId;
    }

    /**
     * <p>
     * The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
     * Agent.
     * </p>
     * 
     * @return The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code>
     *         AI Agent.
     */
    public final String answerGenerationAIPromptId() {
        return answerGenerationAIPromptId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociationConfigurations() {
        return associationConfigurations != null && !(associationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The association configurations for overriding behavior on this AI Agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationConfigurations} method.
     * </p>
     * 
     * @return The association configurations for overriding behavior on this AI Agent.
     */
    public final List<AssociationConfiguration> associationConfigurations() {
        return associationConfigurations;
    }

    /**
     * <p>
     * The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
     * </p>
     * 
     * @return The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
     *         Agent.
     */
    public final String intentLabelingGenerationAIPromptId() {
        return intentLabelingGenerationAIPromptId;
    }

    /**
     * <p>
     * The AI Prompt identifier for the Query Reformulation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
     * Agent.
     * </p>
     * 
     * @return The AI Prompt identifier for the Query Reformulation prompt used by the
     *         <code>ANSWER_RECOMMENDATION</code> AI Agent.
     */
    public final String queryReformulationAIPromptId() {
        return queryReformulationAIPromptId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(answerGenerationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationConfigurations() ? associationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intentLabelingGenerationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(queryReformulationAIPromptId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnswerRecommendationAIAgentConfiguration)) {
            return false;
        }
        AnswerRecommendationAIAgentConfiguration other = (AnswerRecommendationAIAgentConfiguration) obj;
        return Objects.equals(answerGenerationAIPromptId(), other.answerGenerationAIPromptId())
                && hasAssociationConfigurations() == other.hasAssociationConfigurations()
                && Objects.equals(associationConfigurations(), other.associationConfigurations())
                && Objects.equals(intentLabelingGenerationAIPromptId(), other.intentLabelingGenerationAIPromptId())
                && Objects.equals(queryReformulationAIPromptId(), other.queryReformulationAIPromptId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnswerRecommendationAIAgentConfiguration")
                .add("AnswerGenerationAIPromptId", answerGenerationAIPromptId())
                .add("AssociationConfigurations", hasAssociationConfigurations() ? associationConfigurations() : null)
                .add("IntentLabelingGenerationAIPromptId", intentLabelingGenerationAIPromptId())
                .add("QueryReformulationAIPromptId", queryReformulationAIPromptId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "answerGenerationAIPromptId":
            return Optional.ofNullable(clazz.cast(answerGenerationAIPromptId()));
        case "associationConfigurations":
            return Optional.ofNullable(clazz.cast(associationConfigurations()));
        case "intentLabelingGenerationAIPromptId":
            return Optional.ofNullable(clazz.cast(intentLabelingGenerationAIPromptId()));
        case "queryReformulationAIPromptId":
            return Optional.ofNullable(clazz.cast(queryReformulationAIPromptId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnswerRecommendationAIAgentConfiguration, T> g) {
        return obj -> g.apply((AnswerRecommendationAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnswerRecommendationAIAgentConfiguration> {
        /**
         * <p>
         * The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
         * Agent.
         * </p>
         * 
         * @param answerGenerationAIPromptId
         *        The AI Prompt identifier for the Answer Generation prompt used by the
         *        <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerGenerationAIPromptId(String answerGenerationAIPromptId);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * 
         * @param associationConfigurations
         *        The association configurations for overriding behavior on this AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * 
         * @param associationConfigurations
         *        The association configurations for overriding behavior on this AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(AssociationConfiguration... associationConfigurations);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #associationConfigurations(List<AssociationConfiguration>)}.
         * 
         * @param associationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationConfigurations(java.util.Collection<AssociationConfiguration>)
         */
        Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations);

        /**
         * <p>
         * The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
         * Agent.
         * </p>
         * 
         * @param intentLabelingGenerationAIPromptId
         *        The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code>
         *        AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentLabelingGenerationAIPromptId(String intentLabelingGenerationAIPromptId);

        /**
         * <p>
         * The AI Prompt identifier for the Query Reformulation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI
         * Agent.
         * </p>
         * 
         * @param queryReformulationAIPromptId
         *        The AI Prompt identifier for the Query Reformulation prompt used by the
         *        <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryReformulationAIPromptId(String queryReformulationAIPromptId);
    }

    static final class BuilderImpl implements Builder {
        private String answerGenerationAIPromptId;

        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String intentLabelingGenerationAIPromptId;

        private String queryReformulationAIPromptId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnswerRecommendationAIAgentConfiguration model) {
            answerGenerationAIPromptId(model.answerGenerationAIPromptId);
            associationConfigurations(model.associationConfigurations);
            intentLabelingGenerationAIPromptId(model.intentLabelingGenerationAIPromptId);
            queryReformulationAIPromptId(model.queryReformulationAIPromptId);
        }

        public final String getAnswerGenerationAIPromptId() {
            return answerGenerationAIPromptId;
        }

        public final void setAnswerGenerationAIPromptId(String answerGenerationAIPromptId) {
            this.answerGenerationAIPromptId = answerGenerationAIPromptId;
        }

        @Override
        public final Builder answerGenerationAIPromptId(String answerGenerationAIPromptId) {
            this.answerGenerationAIPromptId = answerGenerationAIPromptId;
            return this;
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier
                    .copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration... associationConfigurations) {
            associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations) {
            associationConfigurations(Stream.of(associationConfigurations)
                    .map(c -> AssociationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIntentLabelingGenerationAIPromptId() {
            return intentLabelingGenerationAIPromptId;
        }

        public final void setIntentLabelingGenerationAIPromptId(String intentLabelingGenerationAIPromptId) {
            this.intentLabelingGenerationAIPromptId = intentLabelingGenerationAIPromptId;
        }

        @Override
        public final Builder intentLabelingGenerationAIPromptId(String intentLabelingGenerationAIPromptId) {
            this.intentLabelingGenerationAIPromptId = intentLabelingGenerationAIPromptId;
            return this;
        }

        public final String getQueryReformulationAIPromptId() {
            return queryReformulationAIPromptId;
        }

        public final void setQueryReformulationAIPromptId(String queryReformulationAIPromptId) {
            this.queryReformulationAIPromptId = queryReformulationAIPromptId;
        }

        @Override
        public final Builder queryReformulationAIPromptId(String queryReformulationAIPromptId) {
            this.queryReformulationAIPromptId = queryReformulationAIPromptId;
            return this;
        }

        @Override
        public AnswerRecommendationAIAgentConfiguration build() {
            return new AnswerRecommendationAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
