/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an Amazon Q in Connect Assistant Association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationConfiguration.Builder, AssociationConfiguration> {
    private static final SdkField<AssociationConfigurationData> ASSOCIATION_CONFIGURATION_DATA_FIELD = SdkField
            .<AssociationConfigurationData> builder(MarshallingType.SDK_POJO)
            .memberName("associationConfigurationData")
            .getter(getter(AssociationConfiguration::associationConfigurationData))
            .setter(setter(Builder::associationConfigurationData))
            .constructor(AssociationConfigurationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurationData")
                    .build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(AssociationConfiguration::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(AssociationConfiguration::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATION_CONFIGURATION_DATA_FIELD, ASSOCIATION_ID_FIELD, ASSOCIATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssociationConfigurationData associationConfigurationData;

    private final String associationId;

    private final String associationType;

    private AssociationConfiguration(BuilderImpl builder) {
        this.associationConfigurationData = builder.associationConfigurationData;
        this.associationId = builder.associationId;
        this.associationType = builder.associationType;
    }

    /**
     * <p>
     * The data of the configuration for an Amazon Q in Connect Assistant Association.
     * </p>
     * 
     * @return The data of the configuration for an Amazon Q in Connect Assistant Association.
     */
    public final AssociationConfigurationData associationConfigurationData() {
        return associationConfigurationData;
    }

    /**
     * <p>
     * The identifier of the association for this Association Configuration.
     * </p>
     * 
     * @return The identifier of the association for this Association Configuration.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The type of the association for this Association Configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AIAgentAssociationConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of the association for this Association Configuration.
     * @see AIAgentAssociationConfigurationType
     */
    public final AIAgentAssociationConfigurationType associationType() {
        return AIAgentAssociationConfigurationType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of the association for this Association Configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AIAgentAssociationConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of the association for this Association Configuration.
     * @see AIAgentAssociationConfigurationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationConfigurationData());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationConfiguration)) {
            return false;
        }
        AssociationConfiguration other = (AssociationConfiguration) obj;
        return Objects.equals(associationConfigurationData(), other.associationConfigurationData())
                && Objects.equals(associationId(), other.associationId())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationConfiguration").add("AssociationConfigurationData", associationConfigurationData())
                .add("AssociationId", associationId()).add("AssociationType", associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationConfigurationData":
            return Optional.ofNullable(clazz.cast(associationConfigurationData()));
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationConfiguration, T> g) {
        return obj -> g.apply((AssociationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationConfiguration> {
        /**
         * <p>
         * The data of the configuration for an Amazon Q in Connect Assistant Association.
         * </p>
         * 
         * @param associationConfigurationData
         *        The data of the configuration for an Amazon Q in Connect Assistant Association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurationData(AssociationConfigurationData associationConfigurationData);

        /**
         * <p>
         * The data of the configuration for an Amazon Q in Connect Assistant Association.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationConfigurationData.Builder}
         * avoiding the need to create one manually via {@link AssociationConfigurationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociationConfigurationData.Builder#build()} is called
         * immediately and its result is passed to {@link #associationConfigurationData(AssociationConfigurationData)}.
         * 
         * @param associationConfigurationData
         *        a consumer that will call methods on {@link AssociationConfigurationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationConfigurationData(AssociationConfigurationData)
         */
        default Builder associationConfigurationData(Consumer<AssociationConfigurationData.Builder> associationConfigurationData) {
            return associationConfigurationData(AssociationConfigurationData.builder()
                    .applyMutation(associationConfigurationData).build());
        }

        /**
         * <p>
         * The identifier of the association for this Association Configuration.
         * </p>
         * 
         * @param associationId
         *        The identifier of the association for this Association Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The type of the association for this Association Configuration.
         * </p>
         * 
         * @param associationType
         *        The type of the association for this Association Configuration.
         * @see AIAgentAssociationConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentAssociationConfigurationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of the association for this Association Configuration.
         * </p>
         * 
         * @param associationType
         *        The type of the association for this Association Configuration.
         * @see AIAgentAssociationConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentAssociationConfigurationType
         */
        Builder associationType(AIAgentAssociationConfigurationType associationType);
    }

    static final class BuilderImpl implements Builder {
        private AssociationConfigurationData associationConfigurationData;

        private String associationId;

        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationConfiguration model) {
            associationConfigurationData(model.associationConfigurationData);
            associationId(model.associationId);
            associationType(model.associationType);
        }

        public final AssociationConfigurationData.Builder getAssociationConfigurationData() {
            return associationConfigurationData != null ? associationConfigurationData.toBuilder() : null;
        }

        public final void setAssociationConfigurationData(AssociationConfigurationData.BuilderImpl associationConfigurationData) {
            this.associationConfigurationData = associationConfigurationData != null ? associationConfigurationData.build()
                    : null;
        }

        @Override
        public final Builder associationConfigurationData(AssociationConfigurationData associationConfigurationData) {
            this.associationConfigurationData = associationConfigurationData;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AIAgentAssociationConfigurationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        @Override
        public AssociationConfiguration build() {
            return new AssociationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
