/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reference information about the content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentReference implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentReference.Builder, ContentReference> {
    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentArn").getter(getter(ContentReference::contentArn)).setter(setter(Builder::contentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()).build();

    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(ContentReference::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(ContentReference::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ContentReference::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceType").getter(getter(ContentReference::referenceTypeAsString))
            .setter(setter(Builder::referenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceURL").getter(getter(ContentReference::sourceURL)).setter(setter(Builder::sourceURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ARN_FIELD,
            CONTENT_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, REFERENCE_TYPE_FIELD, SOURCE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentArn;

    private final String contentId;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String referenceType;

    private final String sourceURL;

    private ContentReference(BuilderImpl builder) {
        this.contentArn = builder.contentArn;
        this.contentId = builder.contentId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.referenceType = builder.referenceType;
        this.sourceURL = builder.sourceURL;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the content.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the content.
     */
    public final String contentArn() {
        return contentArn;
    }

    /**
     * <p>
     * The identifier of the content.
     * </p>
     * 
     * @return The identifier of the content.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The type of reference content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return The type of reference content.
     * @see ReferenceType
     */
    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(referenceType);
    }

    /**
     * <p>
     * The type of reference content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return The type of reference content.
     * @see ReferenceType
     */
    public final String referenceTypeAsString() {
        return referenceType;
    }

    /**
     * <p>
     * The web URL of the source content.
     * </p>
     * 
     * @return The web URL of the source content.
     */
    public final String sourceURL() {
        return sourceURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentReference)) {
            return false;
        }
        ContentReference other = (ContentReference) obj;
        return Objects.equals(contentArn(), other.contentArn()) && Objects.equals(contentId(), other.contentId())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(referenceTypeAsString(), other.referenceTypeAsString())
                && Objects.equals(sourceURL(), other.sourceURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentReference").add("ContentArn", contentArn()).add("ContentId", contentId())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("ReferenceType", referenceTypeAsString()).add("SourceURL", sourceURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentArn":
            return Optional.ofNullable(clazz.cast(contentArn()));
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "referenceType":
            return Optional.ofNullable(clazz.cast(referenceTypeAsString()));
        case "sourceURL":
            return Optional.ofNullable(clazz.cast(sourceURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentReference, T> g) {
        return obj -> g.apply((ContentReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentReference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the content.
         * </p>
         * 
         * @param contentArn
         *        The Amazon Resource Name (ARN) of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentArn(String contentArn);

        /**
         * <p>
         * The identifier of the content.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The type of reference content.
         * </p>
         * 
         * @param referenceType
         *        The type of reference content.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(String referenceType);

        /**
         * <p>
         * The type of reference content.
         * </p>
         * 
         * @param referenceType
         *        The type of reference content.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(ReferenceType referenceType);

        /**
         * <p>
         * The web URL of the source content.
         * </p>
         * 
         * @param sourceURL
         *        The web URL of the source content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceURL(String sourceURL);
    }

    static final class BuilderImpl implements Builder {
        private String contentArn;

        private String contentId;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String referenceType;

        private String sourceURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentReference model) {
            contentArn(model.contentArn);
            contentId(model.contentId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            referenceType(model.referenceType);
            sourceURL(model.sourceURL);
        }

        public final String getContentArn() {
            return contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getReferenceType() {
            return referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final String getSourceURL() {
            return sourceURL;
        }

        public final void setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
        }

        @Override
        public final Builder sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        @Override
        public ContentReference build() {
            return new ContentReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
