/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSessionRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateSessionRequest.Builder, CreateSessionRequest> {
    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<Map<String, AIAgentConfigurationData>> builder(MarshallingType.MAP)
            .memberName("aiAgentConfiguration")
            .getter(getter(CreateSessionRequest::aiAgentConfigurationAsStrings))
            .setter(setter(Builder::aiAgentConfigurationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AIAgentConfigurationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIAgentConfigurationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(CreateSessionRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSessionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(CreateSessionRequest::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSessionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_CONFIGURATION_FIELD,
            ASSISTANT_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAG_FILTER_FIELD, TAGS_FIELD));

    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;

    private final String assistantId;

    private final String clientToken;

    private final String description;

    private final String name;

    private final TagFilter tagFilter;

    private final Map<String, String> tags;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.tagFilter = builder.tagFilter;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(aiAgentConfiguration);
    }

    /**
     * For responses, this returns true if the service returned a value for the AiAgentConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAiAgentConfiguration() {
        return aiAgentConfiguration != null && !(aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return aiAgentConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the session.
     * </p>
     * 
     * @return The name of the session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions.
     * </p>
     * 
     * @return An object that can be used to specify Tag conditions.
     */
    public final TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest) obj;
        return hasAiAgentConfiguration() == other.hasAiAgentConfiguration()
                && Objects.equals(aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings())
                && Objects.equals(assistantId(), other.assistantId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(tagFilter(), other.tagFilter()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSessionRequest")
                .add("AiAgentConfiguration", hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null)
                .add("AssistantId", assistantId()).add("ClientToken", clientToken()).add("Description", description())
                .add("Name", name()).add("TagFilter", tagFilter()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentConfiguration":
            return Optional.ofNullable(clazz.cast(aiAgentConfigurationAsStrings()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSessionRequest> {
        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the session.
         * </p>
         * 
         * @param name
         *        The name of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * 
         * @param tagFilter
         *        An object that can be used to specify Tag conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String assistantId;

        private String clientToken;

        private String description;

        private String name;

        private TagFilter tagFilter;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            assistantId(model.assistantId);
            clientToken(model.clientToken);
            description(model.description);
            name(model.name);
            tagFilter(model.tagFilter);
            tags(model.tags);
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier
                    .copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
