/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataDetails implements SdkPojo, Serializable, ToCopyableBuilder<DataDetails.Builder, DataDetails> {
    private static final SdkField<ContentDataDetails> CONTENT_DATA_FIELD = SdkField
            .<ContentDataDetails> builder(MarshallingType.SDK_POJO).memberName("contentData")
            .getter(getter(DataDetails::contentData)).setter(setter(Builder::contentData))
            .constructor(ContentDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentData").build()).build();

    private static final SdkField<GenerativeDataDetails> GENERATIVE_DATA_FIELD = SdkField
            .<GenerativeDataDetails> builder(MarshallingType.SDK_POJO).memberName("generativeData")
            .getter(getter(DataDetails::generativeData)).setter(setter(Builder::generativeData))
            .constructor(GenerativeDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeData").build()).build();

    private static final SdkField<IntentDetectedDataDetails> INTENT_DETECTED_DATA_FIELD = SdkField
            .<IntentDetectedDataDetails> builder(MarshallingType.SDK_POJO).memberName("intentDetectedData")
            .getter(getter(DataDetails::intentDetectedData)).setter(setter(Builder::intentDetectedData))
            .constructor(IntentDetectedDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentDetectedData").build())
            .build();

    private static final SdkField<SourceContentDataDetails> SOURCE_CONTENT_DATA_FIELD = SdkField
            .<SourceContentDataDetails> builder(MarshallingType.SDK_POJO).memberName("sourceContentData")
            .getter(getter(DataDetails::sourceContentData)).setter(setter(Builder::sourceContentData))
            .constructor(SourceContentDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContentData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_DATA_FIELD,
            GENERATIVE_DATA_FIELD, INTENT_DETECTED_DATA_FIELD, SOURCE_CONTENT_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContentDataDetails contentData;

    private final GenerativeDataDetails generativeData;

    private final IntentDetectedDataDetails intentDetectedData;

    private final SourceContentDataDetails sourceContentData;

    private final Type type;

    private DataDetails(BuilderImpl builder) {
        this.contentData = builder.contentData;
        this.generativeData = builder.generativeData;
        this.intentDetectedData = builder.intentDetectedData;
        this.sourceContentData = builder.sourceContentData;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @return Details about the content data.
     */
    public final ContentDataDetails contentData() {
        return contentData;
    }

    /**
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @return Details about the generative data.
     */
    public final GenerativeDataDetails generativeData() {
        return generativeData;
    }

    /**
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @return Details about the intent data.
     */
    public final IntentDetectedDataDetails intentDetectedData() {
        return intentDetectedData;
    }

    /**
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @return Details about the content data.
     */
    public final SourceContentDataDetails sourceContentData() {
        return sourceContentData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentData());
        hashCode = 31 * hashCode + Objects.hashCode(generativeData());
        hashCode = 31 * hashCode + Objects.hashCode(intentDetectedData());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContentData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDetails)) {
            return false;
        }
        DataDetails other = (DataDetails) obj;
        return Objects.equals(contentData(), other.contentData()) && Objects.equals(generativeData(), other.generativeData())
                && Objects.equals(intentDetectedData(), other.intentDetectedData())
                && Objects.equals(sourceContentData(), other.sourceContentData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataDetails").add("ContentData", contentData()).add("GenerativeData", generativeData())
                .add("IntentDetectedData", intentDetectedData()).add("SourceContentData", sourceContentData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentData":
            return Optional.ofNullable(clazz.cast(contentData()));
        case "generativeData":
            return Optional.ofNullable(clazz.cast(generativeData()));
        case "intentDetectedData":
            return Optional.ofNullable(clazz.cast(intentDetectedData()));
        case "sourceContentData":
            return Optional.ofNullable(clazz.cast(sourceContentData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param contentData
     *        Details about the content data.
     */
    public static DataDetails fromContentData(ContentDataDetails contentData) {
        return builder().contentData(contentData).build();
    }

    /**
     * Create an instance of this class with {@link #contentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param contentData
     *        Details about the content data.
     */
    public static DataDetails fromContentData(Consumer<ContentDataDetails.Builder> contentData) {
        ContentDataDetails.Builder builder = ContentDataDetails.builder();
        contentData.accept(builder);
        return fromContentData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #generativeData()} initialized to the given value.
     *
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @param generativeData
     *        Details about the generative data.
     */
    public static DataDetails fromGenerativeData(GenerativeDataDetails generativeData) {
        return builder().generativeData(generativeData).build();
    }

    /**
     * Create an instance of this class with {@link #generativeData()} initialized to the given value.
     *
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @param generativeData
     *        Details about the generative data.
     */
    public static DataDetails fromGenerativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
        GenerativeDataDetails.Builder builder = GenerativeDataDetails.builder();
        generativeData.accept(builder);
        return fromGenerativeData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #intentDetectedData()} initialized to the given value.
     *
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @param intentDetectedData
     *        Details about the intent data.
     */
    public static DataDetails fromIntentDetectedData(IntentDetectedDataDetails intentDetectedData) {
        return builder().intentDetectedData(intentDetectedData).build();
    }

    /**
     * Create an instance of this class with {@link #intentDetectedData()} initialized to the given value.
     *
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @param intentDetectedData
     *        Details about the intent data.
     */
    public static DataDetails fromIntentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
        IntentDetectedDataDetails.Builder builder = IntentDetectedDataDetails.builder();
        intentDetectedData.accept(builder);
        return fromIntentDetectedData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sourceContentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param sourceContentData
     *        Details about the content data.
     */
    public static DataDetails fromSourceContentData(SourceContentDataDetails sourceContentData) {
        return builder().sourceContentData(sourceContentData).build();
    }

    /**
     * Create an instance of this class with {@link #sourceContentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param sourceContentData
     *        Details about the content data.
     */
    public static DataDetails fromSourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
        SourceContentDataDetails.Builder builder = SourceContentDataDetails.builder();
        sourceContentData.accept(builder);
        return fromSourceContentData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataDetails, T> g) {
        return obj -> g.apply((DataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataDetails> {
        /**
         * <p>
         * Details about the content data.
         * </p>
         * 
         * @param contentData
         *        Details about the content data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentData(ContentDataDetails contentData);

        /**
         * <p>
         * Details about the content data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentDataDetails.Builder} avoiding the
         * need to create one manually via {@link ContentDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentDataDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #contentData(ContentDataDetails)}.
         * 
         * @param contentData
         *        a consumer that will call methods on {@link ContentDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentData(ContentDataDetails)
         */
        default Builder contentData(Consumer<ContentDataDetails.Builder> contentData) {
            return contentData(ContentDataDetails.builder().applyMutation(contentData).build());
        }

        /**
         * <p>
         * Details about the generative data.
         * </p>
         * 
         * @param generativeData
         *        Details about the generative data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeData(GenerativeDataDetails generativeData);

        /**
         * <p>
         * Details about the generative data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeDataDetails.Builder} avoiding
         * the need to create one manually via {@link GenerativeDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeDataDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeData(GenerativeDataDetails)}.
         * 
         * @param generativeData
         *        a consumer that will call methods on {@link GenerativeDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeData(GenerativeDataDetails)
         */
        default Builder generativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
            return generativeData(GenerativeDataDetails.builder().applyMutation(generativeData).build());
        }

        /**
         * <p>
         * Details about the intent data.
         * </p>
         * 
         * @param intentDetectedData
         *        Details about the intent data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentDetectedData(IntentDetectedDataDetails intentDetectedData);

        /**
         * <p>
         * Details about the intent data.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentDetectedDataDetails.Builder}
         * avoiding the need to create one manually via {@link IntentDetectedDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentDetectedDataDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #intentDetectedData(IntentDetectedDataDetails)}.
         * 
         * @param intentDetectedData
         *        a consumer that will call methods on {@link IntentDetectedDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentDetectedData(IntentDetectedDataDetails)
         */
        default Builder intentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
            return intentDetectedData(IntentDetectedDataDetails.builder().applyMutation(intentDetectedData).build());
        }

        /**
         * <p>
         * Details about the content data.
         * </p>
         * 
         * @param sourceContentData
         *        Details about the content data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContentData(SourceContentDataDetails sourceContentData);

        /**
         * <p>
         * Details about the content data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceContentDataDetails.Builder}
         * avoiding the need to create one manually via {@link SourceContentDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceContentDataDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceContentData(SourceContentDataDetails)}.
         * 
         * @param sourceContentData
         *        a consumer that will call methods on {@link SourceContentDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceContentData(SourceContentDataDetails)
         */
        default Builder sourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
            return sourceContentData(SourceContentDataDetails.builder().applyMutation(sourceContentData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentDataDetails contentData;

        private GenerativeDataDetails generativeData;

        private IntentDetectedDataDetails intentDetectedData;

        private SourceContentDataDetails sourceContentData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDetails model) {
            contentData(model.contentData);
            generativeData(model.generativeData);
            intentDetectedData(model.intentDetectedData);
            sourceContentData(model.sourceContentData);
        }

        public final ContentDataDetails.Builder getContentData() {
            return contentData != null ? contentData.toBuilder() : null;
        }

        public final void setContentData(ContentDataDetails.BuilderImpl contentData) {
            Object oldValue = this.contentData;
            this.contentData = contentData != null ? contentData.build() : null;
            handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
        }

        @Override
        public final Builder contentData(ContentDataDetails contentData) {
            Object oldValue = this.contentData;
            this.contentData = contentData;
            handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
            return this;
        }

        public final GenerativeDataDetails.Builder getGenerativeData() {
            return generativeData != null ? generativeData.toBuilder() : null;
        }

        public final void setGenerativeData(GenerativeDataDetails.BuilderImpl generativeData) {
            Object oldValue = this.generativeData;
            this.generativeData = generativeData != null ? generativeData.build() : null;
            handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
        }

        @Override
        public final Builder generativeData(GenerativeDataDetails generativeData) {
            Object oldValue = this.generativeData;
            this.generativeData = generativeData;
            handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
            return this;
        }

        public final IntentDetectedDataDetails.Builder getIntentDetectedData() {
            return intentDetectedData != null ? intentDetectedData.toBuilder() : null;
        }

        public final void setIntentDetectedData(IntentDetectedDataDetails.BuilderImpl intentDetectedData) {
            Object oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData != null ? intentDetectedData.build() : null;
            handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
        }

        @Override
        public final Builder intentDetectedData(IntentDetectedDataDetails intentDetectedData) {
            Object oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData;
            handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
            return this;
        }

        public final SourceContentDataDetails.Builder getSourceContentData() {
            return sourceContentData != null ? sourceContentData.toBuilder() : null;
        }

        public final void setSourceContentData(SourceContentDataDetails.BuilderImpl sourceContentData) {
            Object oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData != null ? sourceContentData.build() : null;
            handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
        }

        @Override
        public final Builder sourceContentData(SourceContentDataDetails sourceContentData) {
            Object oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData;
            handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
            return this;
        }

        @Override
        public DataDetails build() {
            return new DataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataDetails#type()
     */
    public enum Type {
        CONTENT_DATA,

        GENERATIVE_DATA,

        INTENT_DETECTED_DATA,

        SOURCE_CONTENT_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
