/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAiPromptVersionsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListAiPromptVersionsResponse.Builder, ListAiPromptVersionsResponse> {
    private static final SdkField<List<AIPromptVersionSummary>> AI_PROMPT_VERSION_SUMMARIES_FIELD = SdkField
            .<List<AIPromptVersionSummary>> builder(MarshallingType.LIST)
            .memberName("aiPromptVersionSummaries")
            .getter(getter(ListAiPromptVersionsResponse::aiPromptVersionSummaries))
            .setter(setter(Builder::aiPromptVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AIPromptVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIPromptVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAiPromptVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AI_PROMPT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AIPromptVersionSummary> aiPromptVersionSummaries;

    private final String nextToken;

    private ListAiPromptVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.aiPromptVersionSummaries = builder.aiPromptVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AiPromptVersionSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAiPromptVersionSummaries() {
        return aiPromptVersionSummaries != null && !(aiPromptVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the AI Prompt versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiPromptVersionSummaries} method.
     * </p>
     * 
     * @return The summaries of the AI Prompt versions.
     */
    public final List<AIPromptVersionSummary> aiPromptVersionSummaries() {
        return aiPromptVersionSummaries;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAiPromptVersionSummaries() ? aiPromptVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiPromptVersionsResponse)) {
            return false;
        }
        ListAiPromptVersionsResponse other = (ListAiPromptVersionsResponse) obj;
        return hasAiPromptVersionSummaries() == other.hasAiPromptVersionSummaries()
                && Objects.equals(aiPromptVersionSummaries(), other.aiPromptVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAiPromptVersionsResponse")
                .add("AiPromptVersionSummaries", hasAiPromptVersionSummaries() ? aiPromptVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiPromptVersionSummaries":
            return Optional.ofNullable(clazz.cast(aiPromptVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAiPromptVersionsResponse, T> g) {
        return obj -> g.apply((ListAiPromptVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAiPromptVersionsResponse> {
        /**
         * <p>
         * The summaries of the AI Prompt versions.
         * </p>
         * 
         * @param aiPromptVersionSummaries
         *        The summaries of the AI Prompt versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptVersionSummaries(Collection<AIPromptVersionSummary> aiPromptVersionSummaries);

        /**
         * <p>
         * The summaries of the AI Prompt versions.
         * </p>
         * 
         * @param aiPromptVersionSummaries
         *        The summaries of the AI Prompt versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptVersionSummaries(AIPromptVersionSummary... aiPromptVersionSummaries);

        /**
         * <p>
         * The summaries of the AI Prompt versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #aiPromptVersionSummaries(List<AIPromptVersionSummary>)}.
         * 
         * @param aiPromptVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiPromptVersionSummaries(java.util.Collection<AIPromptVersionSummary>)
         */
        Builder aiPromptVersionSummaries(Consumer<AIPromptVersionSummary.Builder>... aiPromptVersionSummaries);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<AIPromptVersionSummary> aiPromptVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiPromptVersionsResponse model) {
            super(model);
            aiPromptVersionSummaries(model.aiPromptVersionSummaries);
            nextToken(model.nextToken);
        }

        public final List<AIPromptVersionSummary.Builder> getAiPromptVersionSummaries() {
            List<AIPromptVersionSummary.Builder> result = AIPromptVersionSummariesListCopier
                    .copyToBuilder(this.aiPromptVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiPromptVersionSummaries(Collection<AIPromptVersionSummary.BuilderImpl> aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries = AIPromptVersionSummariesListCopier.copyFromBuilder(aiPromptVersionSummaries);
        }

        @Override
        public final Builder aiPromptVersionSummaries(Collection<AIPromptVersionSummary> aiPromptVersionSummaries) {
            this.aiPromptVersionSummaries = AIPromptVersionSummariesListCopier.copy(aiPromptVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptVersionSummaries(AIPromptVersionSummary... aiPromptVersionSummaries) {
            aiPromptVersionSummaries(Arrays.asList(aiPromptVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiPromptVersionSummaries(Consumer<AIPromptVersionSummary.Builder>... aiPromptVersionSummaries) {
            aiPromptVersionSummaries(Stream.of(aiPromptVersionSummaries)
                    .map(c -> AIPromptVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiPromptVersionsResponse build() {
            return new ListAiPromptVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
