/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for parsing document contents. By default, the service converts the contents of each document into text
 * before splitting it into chunks. To improve processing of PDF files with tables and images, you can configure the
 * data source to convert the pages of text into images and use a model to describe the contents of each page.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParsingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParsingConfiguration.Builder, ParsingConfiguration> {
    private static final SdkField<BedrockFoundationModelConfigurationForParsing> BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockFoundationModelConfigurationForParsing> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockFoundationModelConfiguration")
            .getter(getter(ParsingConfiguration::bedrockFoundationModelConfiguration))
            .setter(setter(Builder::bedrockFoundationModelConfiguration))
            .constructor(BedrockFoundationModelConfigurationForParsing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bedrockFoundationModelConfiguration").build()).build();

    private static final SdkField<String> PARSING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parsingStrategy").getter(getter(ParsingConfiguration::parsingStrategyAsString))
            .setter(setter(Builder::parsingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD, PARSING_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration;

    private final String parsingStrategy;

    private ParsingConfiguration(BuilderImpl builder) {
        this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
        this.parsingStrategy = builder.parsingStrategy;
    }

    /**
     * <p>
     * Settings for a foundation model used to parse documents for a data source.
     * </p>
     * 
     * @return Settings for a foundation model used to parse documents for a data source.
     */
    public final BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration() {
        return bedrockFoundationModelConfiguration;
    }

    /**
     * <p>
     * The parsing strategy for the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingStrategy}
     * will return {@link ParsingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingStrategyAsString}.
     * </p>
     * 
     * @return The parsing strategy for the data source.
     * @see ParsingStrategy
     */
    public final ParsingStrategy parsingStrategy() {
        return ParsingStrategy.fromValue(parsingStrategy);
    }

    /**
     * <p>
     * The parsing strategy for the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingStrategy}
     * will return {@link ParsingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingStrategyAsString}.
     * </p>
     * 
     * @return The parsing strategy for the data source.
     * @see ParsingStrategy
     */
    public final String parsingStrategyAsString() {
        return parsingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockFoundationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parsingStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsingConfiguration)) {
            return false;
        }
        ParsingConfiguration other = (ParsingConfiguration) obj;
        return Objects.equals(bedrockFoundationModelConfiguration(), other.bedrockFoundationModelConfiguration())
                && Objects.equals(parsingStrategyAsString(), other.parsingStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParsingConfiguration")
                .add("BedrockFoundationModelConfiguration", bedrockFoundationModelConfiguration())
                .add("ParsingStrategy", parsingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockFoundationModelConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockFoundationModelConfiguration()));
        case "parsingStrategy":
            return Optional.ofNullable(clazz.cast(parsingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParsingConfiguration, T> g) {
        return obj -> g.apply((ParsingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParsingConfiguration> {
        /**
         * <p>
         * Settings for a foundation model used to parse documents for a data source.
         * </p>
         * 
         * @param bedrockFoundationModelConfiguration
         *        Settings for a foundation model used to parse documents for a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockFoundationModelConfiguration(
                BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration);

        /**
         * <p>
         * Settings for a foundation model used to parse documents for a data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockFoundationModelConfigurationForParsing.Builder} avoiding the need to create one manually via
         * {@link BedrockFoundationModelConfigurationForParsing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockFoundationModelConfigurationForParsing.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing)}.
         * 
         * @param bedrockFoundationModelConfiguration
         *        a consumer that will call methods on {@link BedrockFoundationModelConfigurationForParsing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing)
         */
        default Builder bedrockFoundationModelConfiguration(
                Consumer<BedrockFoundationModelConfigurationForParsing.Builder> bedrockFoundationModelConfiguration) {
            return bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationForParsing.builder()
                    .applyMutation(bedrockFoundationModelConfiguration).build());
        }

        /**
         * <p>
         * The parsing strategy for the data source.
         * </p>
         * 
         * @param parsingStrategy
         *        The parsing strategy for the data source.
         * @see ParsingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingStrategy
         */
        Builder parsingStrategy(String parsingStrategy);

        /**
         * <p>
         * The parsing strategy for the data source.
         * </p>
         * 
         * @param parsingStrategy
         *        The parsing strategy for the data source.
         * @see ParsingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingStrategy
         */
        Builder parsingStrategy(ParsingStrategy parsingStrategy);
    }

    static final class BuilderImpl implements Builder {
        private BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration;

        private String parsingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsingConfiguration model) {
            bedrockFoundationModelConfiguration(model.bedrockFoundationModelConfiguration);
            parsingStrategy(model.parsingStrategy);
        }

        public final BedrockFoundationModelConfigurationForParsing.Builder getBedrockFoundationModelConfiguration() {
            return bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockFoundationModelConfiguration(
                BedrockFoundationModelConfigurationForParsing.BuilderImpl bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockFoundationModelConfiguration(
                BedrockFoundationModelConfigurationForParsing bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
            return this;
        }

        public final String getParsingStrategy() {
            return parsingStrategy;
        }

        public final void setParsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
        }

        @Override
        public final Builder parsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
            return this;
        }

        @Override
        public final Builder parsingStrategy(ParsingStrategy parsingStrategy) {
            this.parsingStrategy(parsingStrategy == null ? null : parsingStrategy.toString());
            return this;
        }

        @Override
        public ParsingConfiguration build() {
            return new ParsingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
