/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAiPromptRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateAiPromptRequest.Builder, UpdateAiPromptRequest> {
    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptId").getter(getter(UpdateAiPromptRequest::aiPromptId)).setter(setter(Builder::aiPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiPromptId").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(UpdateAiPromptRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAiPromptRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAiPromptRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<AIPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(UpdateAiPromptRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(AIPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(UpdateAiPromptRequest::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_ID_FIELD,
            ASSISTANT_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, TEMPLATE_CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD));

    private final String aiPromptId;

    private final String assistantId;

    private final String clientToken;

    private final String description;

    private final AIPromptTemplateConfiguration templateConfiguration;

    private final String visibilityStatus;

    private UpdateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.aiPromptId = builder.aiPromptId;
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.templateConfiguration = builder.templateConfiguration;
        this.visibilityStatus = builder.visibilityStatus;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI Prompt.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI Prompt.
     */
    public final String aiPromptId() {
        return aiPromptId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the AWS SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/https:/aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"
     * >Making retries safe with idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the AWS SDK populates this field. For more information about idempotency, see <a href=
     *         "http://aws.amazon.com/https:/aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"
     *         >Making retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the Amazon Q in Connect AI Prompt.
     * </p>
     * 
     * @return The description of the Amazon Q in Connect AI Prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration of the prompt template for this AI Prompt.
     * </p>
     * 
     * @return The configuration of the prompt template for this AI Prompt.
     */
    public final AIPromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI prompt.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI prompt.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiPromptRequest)) {
            return false;
        }
        UpdateAiPromptRequest other = (UpdateAiPromptRequest) obj;
        return Objects.equals(aiPromptId(), other.aiPromptId()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAiPromptRequest").add("AiPromptId", aiPromptId()).add("AssistantId", assistantId())
                .add("ClientToken", clientToken()).add("Description", description())
                .add("TemplateConfiguration", templateConfiguration()).add("VisibilityStatus", visibilityStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiPromptId":
            return Optional.ofNullable(clazz.cast(aiPromptId()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiPromptRequest, T> g) {
        return obj -> g.apply((UpdateAiPromptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAiPromptRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI Prompt.
         * </p>
         * 
         * @param aiPromptId
         *        The identifier of the Amazon Q in Connect AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptId(String aiPromptId);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the AWS SDK populates this field. For more information about idempotency, see <a href=
         * "http://aws.amazon.com/https:/aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"
         * >Making retries safe with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the AWS SDK populates this field. For more information about idempotency, see <a href=
         *        "http://aws.amazon.com/https:/aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"
         *        >Making retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the Amazon Q in Connect AI Prompt.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Q in Connect AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration of the prompt template for this AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(AIPromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link AIPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(AIPromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String aiPromptId;

        private String assistantId;

        private String clientToken;

        private String description;

        private AIPromptTemplateConfiguration templateConfiguration;

        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiPromptRequest model) {
            super(model);
            aiPromptId(model.aiPromptId);
            assistantId(model.assistantId);
            clientToken(model.clientToken);
            description(model.description);
            templateConfiguration(model.templateConfiguration);
            visibilityStatus(model.visibilityStatus);
        }

        public final String getAiPromptId() {
            return aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiPromptRequest build() {
            return new UpdateAiPromptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
