/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssistantAiAgentRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateAssistantAiAgentRequest.Builder, UpdateAssistantAiAgentRequest> {
    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentType").getter(getter(UpdateAssistantAiAgentRequest::aiAgentTypeAsString))
            .setter(setter(Builder::aiAgentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentType").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(UpdateAssistantAiAgentRequest::assistantId))
            .setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<AIAgentConfigurationData> CONFIGURATION_FIELD = SdkField
            .<AIAgentConfigurationData> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateAssistantAiAgentRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AIAgentConfigurationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_TYPE_FIELD,
            ASSISTANT_ID_FIELD, CONFIGURATION_FIELD));

    private final String aiAgentType;

    private final String assistantId;

    private final AIAgentConfigurationData configuration;

    private UpdateAssistantAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.aiAgentType = builder.aiAgentType;
        this.assistantId = builder.assistantId;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(aiAgentType);
    }

    /**
     * <p>
     * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final String aiAgentTypeAsString() {
        return aiAgentType;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * 
     * @return The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     */
    public final AIAgentConfigurationData configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssistantAiAgentRequest)) {
            return false;
        }
        UpdateAssistantAiAgentRequest other = (UpdateAssistantAiAgentRequest) obj;
        return Objects.equals(aiAgentTypeAsString(), other.aiAgentTypeAsString())
                && Objects.equals(assistantId(), other.assistantId()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssistantAiAgentRequest").add("AiAgentType", aiAgentTypeAsString())
                .add("AssistantId", assistantId()).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgentType":
            return Optional.ofNullable(clazz.cast(aiAgentTypeAsString()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssistantAiAgentRequest, T> g) {
        return obj -> g.apply((UpdateAssistantAiAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssistantAiAgentRequest> {
        /**
         * <p>
         * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(String aiAgentType);

        /**
         * <p>
         * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(AIAgentType aiAgentType);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param configuration
         *        The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect
         *        Assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AIAgentConfigurationData configuration);

        /**
         * <p>
         * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentConfigurationData.Builder}
         * avoiding the need to create one manually via {@link AIAgentConfigurationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentConfigurationData.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AIAgentConfigurationData)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AIAgentConfigurationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AIAgentConfigurationData)
         */
        default Builder configuration(Consumer<AIAgentConfigurationData.Builder> configuration) {
            return configuration(AIAgentConfigurationData.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String aiAgentType;

        private String assistantId;

        private AIAgentConfigurationData configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssistantAiAgentRequest model) {
            super(model);
            aiAgentType(model.aiAgentType);
            assistantId(model.assistantId);
            configuration(model.configuration);
        }

        public final String getAiAgentType() {
            return aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final AIAgentConfigurationData.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfigurationData.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfigurationData configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssistantAiAgentRequest build() {
            return new UpdateAssistantAiAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
