/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIPromptAPIFormat;
import software.amazon.awssdk.services.qconnect.model.AIPromptTemplateType;
import software.amazon.awssdk.services.qconnect.model.AIPromptType;
import software.amazon.awssdk.services.qconnect.model.Origin;
import software.amazon.awssdk.services.qconnect.model.Status;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIPromptSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIPromptSummary> {
    private static final SdkField<String> AI_PROMPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiPromptArn").getter(AIPromptSummary.getter(AIPromptSummary::aiPromptArn)).setter(AIPromptSummary.setter(Builder::aiPromptArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptArn").build()}).build();
    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiPromptId").getter(AIPromptSummary.getter(AIPromptSummary::aiPromptId)).setter(AIPromptSummary.setter(Builder::aiPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPromptId").build()}).build();
    private static final SdkField<String> API_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiFormat").getter(AIPromptSummary.getter(AIPromptSummary::apiFormatAsString)).setter(AIPromptSummary.setter(Builder::apiFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiFormat").build()}).build();
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AIPromptSummary.getter(AIPromptSummary::assistantArn)).setter(AIPromptSummary.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AIPromptSummary.getter(AIPromptSummary::assistantId)).setter(AIPromptSummary.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AIPromptSummary.getter(AIPromptSummary::description)).setter(AIPromptSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(AIPromptSummary.getter(AIPromptSummary::modelId)).setter(AIPromptSummary.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTime").getter(AIPromptSummary.getter(AIPromptSummary::modifiedTime)).setter(AIPromptSummary.setter(Builder::modifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AIPromptSummary.getter(AIPromptSummary::name)).setter(AIPromptSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("origin").getter(AIPromptSummary.getter(AIPromptSummary::originAsString)).setter(AIPromptSummary.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AIPromptSummary.getter(AIPromptSummary::statusAsString)).setter(AIPromptSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AIPromptSummary.getter(AIPromptSummary::tags)).setter(AIPromptSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(AIPromptSummary.getter(AIPromptSummary::templateTypeAsString)).setter(AIPromptSummary.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AIPromptSummary.getter(AIPromptSummary::typeAsString)).setter(AIPromptSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(AIPromptSummary.getter(AIPromptSummary::visibilityStatusAsString)).setter(AIPromptSummary.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_ARN_FIELD, AI_PROMPT_ID_FIELD, API_FORMAT_FIELD, ASSISTANT_ARN_FIELD, ASSISTANT_ID_FIELD, DESCRIPTION_FIELD, MODEL_ID_FIELD, MODIFIED_TIME_FIELD, NAME_FIELD, ORIGIN_FIELD, STATUS_FIELD, TAGS_FIELD, TEMPLATE_TYPE_FIELD, TYPE_FIELD, VISIBILITY_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aiPromptArn;
    private final String aiPromptId;
    private final String apiFormat;
    private final String assistantArn;
    private final String assistantId;
    private final String description;
    private final String modelId;
    private final Instant modifiedTime;
    private final String name;
    private final String origin;
    private final String status;
    private final Map<String, String> tags;
    private final String templateType;
    private final String type;
    private final String visibilityStatus;

    private AIPromptSummary(BuilderImpl builder) {
        this.aiPromptArn = builder.aiPromptArn;
        this.aiPromptId = builder.aiPromptId;
        this.apiFormat = builder.apiFormat;
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.description = builder.description;
        this.modelId = builder.modelId;
        this.modifiedTime = builder.modifiedTime;
        this.name = builder.name;
        this.origin = builder.origin;
        this.status = builder.status;
        this.tags = builder.tags;
        this.templateType = builder.templateType;
        this.type = builder.type;
        this.visibilityStatus = builder.visibilityStatus;
    }

    public final String aiPromptArn() {
        return this.aiPromptArn;
    }

    public final String aiPromptId() {
        return this.aiPromptId;
    }

    public final AIPromptAPIFormat apiFormat() {
        return AIPromptAPIFormat.fromValue(this.apiFormat);
    }

    public final String apiFormatAsString() {
        return this.apiFormat;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String description() {
        return this.description;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final Instant modifiedTime() {
        return this.modifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AIPromptTemplateType templateType() {
        return AIPromptTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final AIPromptType type() {
        return AIPromptType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aiPromptArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIPromptSummary)) {
            return false;
        }
        AIPromptSummary other = (AIPromptSummary)obj;
        return Objects.equals(this.aiPromptArn(), other.aiPromptArn()) && Objects.equals(this.aiPromptId(), other.aiPromptId()) && Objects.equals(this.apiFormatAsString(), other.apiFormatAsString()) && Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modifiedTime(), other.modifiedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AIPromptSummary").add("AiPromptArn", (Object)this.aiPromptArn()).add("AiPromptId", (Object)this.aiPromptId()).add("ApiFormat", (Object)this.apiFormatAsString()).add("AssistantArn", (Object)this.assistantArn()).add("AssistantId", (Object)this.assistantId()).add("Description", (Object)this.description()).add("ModelId", (Object)this.modelId()).add("ModifiedTime", (Object)this.modifiedTime()).add("Name", (Object)this.name()).add("Origin", (Object)this.originAsString()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateType", (Object)this.templateTypeAsString()).add("Type", (Object)this.typeAsString()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiPromptArn": {
                return Optional.ofNullable(clazz.cast(this.aiPromptArn()));
            }
            case "aiPromptId": {
                return Optional.ofNullable(clazz.cast(this.aiPromptId()));
            }
            case "apiFormat": {
                return Optional.ofNullable(clazz.cast(this.apiFormatAsString()));
            }
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modifiedTime": {
                return Optional.ofNullable(clazz.cast(this.modifiedTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIPromptSummary, T> g) {
        return obj -> g.apply((AIPromptSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aiPromptArn;
        private String aiPromptId;
        private String apiFormat;
        private String assistantArn;
        private String assistantId;
        private String description;
        private String modelId;
        private Instant modifiedTime;
        private String name;
        private String origin;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateType;
        private String type;
        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AIPromptSummary model) {
            this.aiPromptArn(model.aiPromptArn);
            this.aiPromptId(model.aiPromptId);
            this.apiFormat(model.apiFormat);
            this.assistantArn(model.assistantArn);
            this.assistantId(model.assistantId);
            this.description(model.description);
            this.modelId(model.modelId);
            this.modifiedTime(model.modifiedTime);
            this.name(model.name);
            this.origin(model.origin);
            this.status(model.status);
            this.tags(model.tags);
            this.templateType(model.templateType);
            this.type(model.type);
            this.visibilityStatus(model.visibilityStatus);
        }

        public final String getAiPromptArn() {
            return this.aiPromptArn;
        }

        public final void setAiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
        }

        @Override
        public final Builder aiPromptArn(String aiPromptArn) {
            this.aiPromptArn = aiPromptArn;
            return this;
        }

        public final String getAiPromptId() {
            return this.aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getApiFormat() {
            return this.apiFormat;
        }

        public final void setApiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
        }

        @Override
        public final Builder apiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        @Override
        public final Builder apiFormat(AIPromptAPIFormat apiFormat) {
            this.apiFormat(apiFormat == null ? null : apiFormat.toString());
            return this;
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final Instant getModifiedTime() {
            return this.modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(AIPromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIPromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public AIPromptSummary build() {
            return new AIPromptSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIPromptSummary> {
        public Builder aiPromptArn(String var1);

        public Builder aiPromptId(String var1);

        public Builder apiFormat(String var1);

        public Builder apiFormat(AIPromptAPIFormat var1);

        public Builder assistantArn(String var1);

        public Builder assistantId(String var1);

        public Builder description(String var1);

        public Builder modelId(String var1);

        public Builder modifiedTime(Instant var1);

        public Builder name(String var1);

        public Builder origin(String var1);

        public Builder origin(Origin var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateType(String var1);

        public Builder templateType(AIPromptTemplateType var1);

        public Builder type(String var1);

        public Builder type(AIPromptType var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);
    }
}

