/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AIPromptType {
    ANSWER_GENERATION("ANSWER_GENERATION"),
    INTENT_LABELING_GENERATION("INTENT_LABELING_GENERATION"),
    QUERY_REFORMULATION("QUERY_REFORMULATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AIPromptType> VALUE_MAP;
    private final String value;

    private AIPromptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AIPromptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AIPromptType> knownValues() {
        EnumSet<AIPromptType> knownValues = EnumSet.allOf(AIPromptType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AIPromptType.class, AIPromptType::toString);
    }
}

