/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ContentFeedbackData;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFeedbackRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, PutFeedbackRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::assistantId)).setter(PutFeedbackRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<ContentFeedbackData> CONTENT_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentFeedback").getter(PutFeedbackRequest.getter(PutFeedbackRequest::contentFeedback)).setter(PutFeedbackRequest.setter(Builder::contentFeedback)).constructor(ContentFeedbackData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentFeedback").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::targetId)).setter(PutFeedbackRequest.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(PutFeedbackRequest.getter(PutFeedbackRequest::targetTypeAsString)).setter(PutFeedbackRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, CONTENT_FEEDBACK_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assistantId", ASSISTANT_ID_FIELD);
            this.put("contentFeedback", CONTENT_FEEDBACK_FIELD);
            this.put("targetId", TARGET_ID_FIELD);
            this.put("targetType", TARGET_TYPE_FIELD);
        }
    });
    private final String assistantId;
    private final ContentFeedbackData contentFeedback;
    private final String targetId;
    private final String targetType;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.contentFeedback = builder.contentFeedback;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final ContentFeedbackData contentFeedback() {
        return this.contentFeedback;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.contentFeedback(), other.contentFeedback()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutFeedbackRequest").add("AssistantId", (Object)this.assistantId()).add("ContentFeedback", (Object)this.contentFeedback()).add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "contentFeedback": {
                return Optional.ofNullable(clazz.cast(this.contentFeedback()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private ContentFeedbackData contentFeedback;
        private String targetId;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.contentFeedback(model.contentFeedback);
            this.targetId(model.targetId);
            this.targetType(model.targetType);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final ContentFeedbackData.Builder getContentFeedback() {
            return this.contentFeedback != null ? this.contentFeedback.toBuilder() : null;
        }

        public final void setContentFeedback(ContentFeedbackData.BuilderImpl contentFeedback) {
            this.contentFeedback = contentFeedback != null ? contentFeedback.build() : null;
        }

        @Override
        public final Builder contentFeedback(ContentFeedbackData contentFeedback) {
            this.contentFeedback = contentFeedback;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFeedbackRequest> {
        public Builder assistantId(String var1);

        public Builder contentFeedback(ContentFeedbackData var1);

        default public Builder contentFeedback(Consumer<ContentFeedbackData.Builder> contentFeedback) {
            return this.contentFeedback((ContentFeedbackData)((ContentFeedbackData.Builder)ContentFeedbackData.builder().applyMutation(contentFeedback)).build());
        }

        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

