/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.KnowledgeBaseType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.RenderingConfiguration;
import software.amazon.awssdk.services.qconnect.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.qconnect.model.SourceConfiguration;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VectorIngestionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKnowledgeBaseRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::clientToken)).setter(CreateKnowledgeBaseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::description)).setter(CreateKnowledgeBaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseType").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::knowledgeBaseTypeAsString)).setter(CreateKnowledgeBaseRequest.setter(Builder::knowledgeBaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::name)).setter(CreateKnowledgeBaseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderingConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::renderingConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::renderingConfiguration)).constructor(RenderingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::serverSideEncryptionConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::sourceConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::tags)).setter(CreateKnowledgeBaseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorIngestionConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::vectorIngestionConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::vectorIngestionConfiguration)).constructor(VectorIngestionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, NAME_FIELD, RENDERING_CONFIGURATION_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD, TAGS_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("knowledgeBaseType", KNOWLEDGE_BASE_TYPE_FIELD);
            this.put("name", NAME_FIELD);
            this.put("renderingConfiguration", RENDERING_CONFIGURATION_FIELD);
            this.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
            this.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        }
    });
    private final String clientToken;
    private final String description;
    private final String knowledgeBaseType;
    private final String name;
    private final RenderingConfiguration renderingConfiguration;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final SourceConfiguration sourceConfiguration;
    private final Map<String, String> tags;
    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private CreateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.name = builder.name;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.tags = builder.tags;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(this.knowledgeBaseType);
    }

    public final String knowledgeBaseTypeAsString() {
        return this.knowledgeBaseType;
    }

    public final String name() {
        return this.name;
    }

    public final RenderingConfiguration renderingConfiguration() {
        return this.renderingConfiguration;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return this.vectorIngestionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIngestionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKnowledgeBaseRequest)) {
            return false;
        }
        CreateKnowledgeBaseRequest other = (CreateKnowledgeBaseRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.renderingConfiguration(), other.renderingConfiguration()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vectorIngestionConfiguration(), other.vectorIngestionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKnowledgeBaseRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("KnowledgeBaseType", (Object)this.knowledgeBaseTypeAsString()).add("Name", (Object)this.name()).add("RenderingConfiguration", (Object)this.renderingConfiguration()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("VectorIngestionConfiguration", (Object)this.vectorIngestionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseType": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "renderingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.renderingConfiguration()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vectorIngestionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorIngestionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((CreateKnowledgeBaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String knowledgeBaseType;
        private String name;
        private RenderingConfiguration renderingConfiguration;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private SourceConfiguration sourceConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKnowledgeBaseRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.knowledgeBaseType(model.knowledgeBaseType);
            this.name(model.name);
            this.renderingConfiguration(model.renderingConfiguration);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.sourceConfiguration(model.sourceConfiguration);
            this.tags(model.tags);
            this.vectorIngestionConfiguration(model.vectorIngestionConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return this.knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return this.renderingConfiguration != null ? this.renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build() : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKnowledgeBaseRequest build() {
            return new CreateKnowledgeBaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder knowledgeBaseType(String var1);

        public Builder knowledgeBaseType(KnowledgeBaseType var1);

        public Builder name(String var1);

        public Builder renderingConfiguration(RenderingConfiguration var1);

        default public Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return this.renderingConfiguration((RenderingConfiguration)((RenderingConfiguration.Builder)RenderingConfiguration.builder().applyMutation(renderingConfiguration)).build());
        }

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder vectorIngestionConfiguration(VectorIngestionConfiguration var1);

        default public Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return this.vectorIngestionConfiguration((VectorIngestionConfiguration)((VectorIngestionConfiguration.Builder)VectorIngestionConfiguration.builder().applyMutation(vectorIngestionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

