/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.FilterField;
import software.amazon.awssdk.services.qconnect.model.FilterOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("field").getter(Filter.getter(Filter::fieldAsString)).setter(Filter.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(Filter.getter(Filter::operatorAsString)).setter(Filter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(Filter.getter(Filter::value)).setter(Filter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, OPERATOR_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("field", FIELD_FIELD);
            this.put("operator", OPERATOR_FIELD);
            this.put("value", VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String field;
    private final String operator;
    private final String value;

    private Filter(BuilderImpl builder) {
        this.field = builder.field;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    public final FilterField field() {
        return FilterField.fromValue(this.field);
    }

    public final String fieldAsString() {
        return this.field;
    }

    public final FilterOperator operator() {
        return FilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.fieldAsString(), other.fieldAsString()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("Field", (Object)this.fieldAsString()).add("Operator", (Object)this.operatorAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "field": {
                return Optional.ofNullable(clazz.cast(this.fieldAsString()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private String operator;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.field(model.field);
            this.operator(model.operator);
            this.value(model.value);
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(FilterField field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(FilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder field(String var1);

        public Builder field(FilterField var1);

        public Builder operator(String var1);

        public Builder operator(FilterOperator var1);

        public Builder value(String var1);
    }
}

