/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AgentAttributes;
import software.amazon.awssdk.services.qconnect.model.CustomAttributesCopier;
import software.amazon.awssdk.services.qconnect.model.CustomerProfileAttributes;
import software.amazon.awssdk.services.qconnect.model.SystemAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateAttributes> {
    private static final SdkField<AgentAttributes> AGENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::agentAttributes)).setter(MessageTemplateAttributes.setter(Builder::agentAttributes)).constructor(AgentAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAttributes").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::customAttributes)).setter(MessageTemplateAttributes.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CustomerProfileAttributes> CUSTOMER_PROFILE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerProfileAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::customerProfileAttributes)).setter(MessageTemplateAttributes.setter(Builder::customerProfileAttributes)).constructor(CustomerProfileAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfileAttributes").build()}).build();
    private static final SdkField<SystemAttributes> SYSTEM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("systemAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::systemAttributes)).setter(MessageTemplateAttributes.setter(Builder::systemAttributes)).constructor(SystemAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ATTRIBUTES_FIELD, CUSTOM_ATTRIBUTES_FIELD, CUSTOMER_PROFILE_ATTRIBUTES_FIELD, SYSTEM_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentAttributes", AGENT_ATTRIBUTES_FIELD);
            this.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
            this.put("customerProfileAttributes", CUSTOMER_PROFILE_ATTRIBUTES_FIELD);
            this.put("systemAttributes", SYSTEM_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AgentAttributes agentAttributes;
    private final Map<String, String> customAttributes;
    private final CustomerProfileAttributes customerProfileAttributes;
    private final SystemAttributes systemAttributes;

    private MessageTemplateAttributes(BuilderImpl builder) {
        this.agentAttributes = builder.agentAttributes;
        this.customAttributes = builder.customAttributes;
        this.customerProfileAttributes = builder.customerProfileAttributes;
        this.systemAttributes = builder.systemAttributes;
    }

    public final AgentAttributes agentAttributes() {
        return this.agentAttributes;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customAttributes() {
        return this.customAttributes;
    }

    public final CustomerProfileAttributes customerProfileAttributes() {
        return this.customerProfileAttributes;
    }

    public final SystemAttributes systemAttributes() {
        return this.systemAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProfileAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateAttributes)) {
            return false;
        }
        MessageTemplateAttributes other = (MessageTemplateAttributes)obj;
        return Objects.equals(this.agentAttributes(), other.agentAttributes()) && this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.customerProfileAttributes(), other.customerProfileAttributes()) && Objects.equals(this.systemAttributes(), other.systemAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateAttributes").add("AgentAttributes", (Object)this.agentAttributes()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomerProfileAttributes", (Object)this.customerProfileAttributes()).add("SystemAttributes", (Object)this.systemAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentAttributes": {
                return Optional.ofNullable(clazz.cast(this.agentAttributes()));
            }
            case "customAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "customerProfileAttributes": {
                return Optional.ofNullable(clazz.cast(this.customerProfileAttributes()));
            }
            case "systemAttributes": {
                return Optional.ofNullable(clazz.cast(this.systemAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateAttributes, T> g) {
        return obj -> g.apply((MessageTemplateAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AgentAttributes agentAttributes;
        private Map<String, String> customAttributes = DefaultSdkAutoConstructMap.getInstance();
        private CustomerProfileAttributes customerProfileAttributes;
        private SystemAttributes systemAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateAttributes model) {
            this.agentAttributes(model.agentAttributes);
            this.customAttributes(model.customAttributes);
            this.customerProfileAttributes(model.customerProfileAttributes);
            this.systemAttributes(model.systemAttributes);
        }

        public final AgentAttributes.Builder getAgentAttributes() {
            return this.agentAttributes != null ? this.agentAttributes.toBuilder() : null;
        }

        public final void setAgentAttributes(AgentAttributes.BuilderImpl agentAttributes) {
            this.agentAttributes = agentAttributes != null ? agentAttributes.build() : null;
        }

        @Override
        public final Builder agentAttributes(AgentAttributes agentAttributes) {
            this.agentAttributes = agentAttributes;
            return this;
        }

        public final Map<String, String> getCustomAttributes() {
            if (this.customAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customAttributes;
        }

        public final void setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
        }

        @Override
        public final Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
            return this;
        }

        public final CustomerProfileAttributes.Builder getCustomerProfileAttributes() {
            return this.customerProfileAttributes != null ? this.customerProfileAttributes.toBuilder() : null;
        }

        public final void setCustomerProfileAttributes(CustomerProfileAttributes.BuilderImpl customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes != null ? customerProfileAttributes.build() : null;
        }

        @Override
        public final Builder customerProfileAttributes(CustomerProfileAttributes customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
            return this;
        }

        public final SystemAttributes.Builder getSystemAttributes() {
            return this.systemAttributes != null ? this.systemAttributes.toBuilder() : null;
        }

        public final void setSystemAttributes(SystemAttributes.BuilderImpl systemAttributes) {
            this.systemAttributes = systemAttributes != null ? systemAttributes.build() : null;
        }

        @Override
        public final Builder systemAttributes(SystemAttributes systemAttributes) {
            this.systemAttributes = systemAttributes;
            return this;
        }

        public MessageTemplateAttributes build() {
            return new MessageTemplateAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateAttributes> {
        public Builder agentAttributes(AgentAttributes var1);

        default public Builder agentAttributes(Consumer<AgentAttributes.Builder> agentAttributes) {
            return this.agentAttributes((AgentAttributes)((AgentAttributes.Builder)AgentAttributes.builder().applyMutation(agentAttributes)).build());
        }

        public Builder customAttributes(Map<String, String> var1);

        public Builder customerProfileAttributes(CustomerProfileAttributes var1);

        default public Builder customerProfileAttributes(Consumer<CustomerProfileAttributes.Builder> customerProfileAttributes) {
            return this.customerProfileAttributes((CustomerProfileAttributes)((CustomerProfileAttributes.Builder)CustomerProfileAttributes.builder().applyMutation(customerProfileAttributes)).build());
        }

        public Builder systemAttributes(SystemAttributes var1);

        default public Builder systemAttributes(Consumer<SystemAttributes.Builder> systemAttributes) {
            return this.systemAttributes((SystemAttributes)((SystemAttributes.Builder)SystemAttributes.builder().applyMutation(systemAttributes)).build());
        }
    }
}

