/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelSubtype;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateSummary> {
    private static final SdkField<Long> ACTIVE_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeVersionNumber").getter(MessageTemplateSummary.getter(MessageTemplateSummary::activeVersionNumber)).setter(MessageTemplateSummary.setter(Builder::activeVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeVersionNumber").build()}).build();
    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelSubtype").getter(MessageTemplateSummary.getter(MessageTemplateSummary::channelSubtypeAsString)).setter(MessageTemplateSummary.setter(Builder::channelSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(MessageTemplateSummary.getter(MessageTemplateSummary::createdTime)).setter(MessageTemplateSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(MessageTemplateSummary.getter(MessageTemplateSummary::description)).setter(MessageTemplateSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(MessageTemplateSummary.getter(MessageTemplateSummary::knowledgeBaseArn)).setter(MessageTemplateSummary.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(MessageTemplateSummary.getter(MessageTemplateSummary::knowledgeBaseId)).setter(MessageTemplateSummary.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(MessageTemplateSummary.getter(MessageTemplateSummary::lastModifiedBy)).setter(MessageTemplateSummary.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(MessageTemplateSummary.getter(MessageTemplateSummary::lastModifiedTime)).setter(MessageTemplateSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateArn").getter(MessageTemplateSummary.getter(MessageTemplateSummary::messageTemplateArn)).setter(MessageTemplateSummary.setter(Builder::messageTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateId").getter(MessageTemplateSummary.getter(MessageTemplateSummary::messageTemplateId)).setter(MessageTemplateSummary.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MessageTemplateSummary.getter(MessageTemplateSummary::name)).setter(MessageTemplateSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(MessageTemplateSummary.getter(MessageTemplateSummary::tags)).setter(MessageTemplateSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_VERSION_NUMBER_FIELD, CHANNEL_SUBTYPE_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, MESSAGE_TEMPLATE_ARN_FIELD, MESSAGE_TEMPLATE_ID_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("activeVersionNumber", ACTIVE_VERSION_NUMBER_FIELD);
            this.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
            this.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long activeVersionNumber;
    private final String channelSubtype;
    private final Instant createdTime;
    private final String description;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final String messageTemplateArn;
    private final String messageTemplateId;
    private final String name;
    private final Map<String, String> tags;

    private MessageTemplateSummary(BuilderImpl builder) {
        this.activeVersionNumber = builder.activeVersionNumber;
        this.channelSubtype = builder.channelSubtype;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateId = builder.messageTemplateId;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final Long activeVersionNumber() {
        return this.activeVersionNumber;
    }

    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(this.channelSubtype);
    }

    public final String channelSubtypeAsString() {
        return this.channelSubtype;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String messageTemplateArn() {
        return this.messageTemplateArn;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateSummary)) {
            return false;
        }
        MessageTemplateSummary other = (MessageTemplateSummary)obj;
        return Objects.equals(this.activeVersionNumber(), other.activeVersionNumber()) && Objects.equals(this.channelSubtypeAsString(), other.channelSubtypeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.messageTemplateArn(), other.messageTemplateArn()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateSummary").add("ActiveVersionNumber", (Object)this.activeVersionNumber()).add("ChannelSubtype", (Object)this.channelSubtypeAsString()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MessageTemplateArn", (Object)this.messageTemplateArn()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.activeVersionNumber()));
            }
            case "channelSubtype": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeAsString()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "messageTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateArn()));
            }
            case "messageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateSummary, T> g) {
        return obj -> g.apply((MessageTemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long activeVersionNumber;
        private String channelSubtype;
        private Instant createdTime;
        private String description;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private String messageTemplateArn;
        private String messageTemplateId;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateSummary model) {
            this.activeVersionNumber(model.activeVersionNumber);
            this.channelSubtype(model.channelSubtype);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.messageTemplateArn(model.messageTemplateArn);
            this.messageTemplateId(model.messageTemplateId);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final Long getActiveVersionNumber() {
            return this.activeVersionNumber;
        }

        public final void setActiveVersionNumber(Long activeVersionNumber) {
            this.activeVersionNumber = activeVersionNumber;
        }

        @Override
        public final Builder activeVersionNumber(Long activeVersionNumber) {
            this.activeVersionNumber = activeVersionNumber;
            return this;
        }

        public final String getChannelSubtype() {
            return this.channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getMessageTemplateArn() {
            return this.messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public MessageTemplateSummary build() {
            return new MessageTemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateSummary> {
        public Builder activeVersionNumber(Long var1);

        public Builder channelSubtype(String var1);

        public Builder channelSubtype(ChannelSubtype var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder messageTemplateArn(String var1);

        public Builder messageTemplateId(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

