/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.IntentInputData;
import software.amazon.awssdk.services.qconnect.model.QueryTextInputData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryInputData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryInputData> {
    private static final SdkField<IntentInputData> INTENT_INPUT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentInputData").getter(QueryInputData.getter(QueryInputData::intentInputData)).setter(QueryInputData.setter(Builder::intentInputData)).constructor(IntentInputData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentInputData").build()}).build();
    private static final SdkField<QueryTextInputData> QUERY_TEXT_INPUT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryTextInputData").getter(QueryInputData.getter(QueryInputData::queryTextInputData)).setter(QueryInputData.setter(Builder::queryTextInputData)).constructor(QueryTextInputData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTextInputData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_INPUT_DATA_FIELD, QUERY_TEXT_INPUT_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("intentInputData", INTENT_INPUT_DATA_FIELD);
            this.put("queryTextInputData", QUERY_TEXT_INPUT_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IntentInputData intentInputData;
    private final QueryTextInputData queryTextInputData;
    private final Type type;

    private QueryInputData(BuilderImpl builder) {
        this.intentInputData = builder.intentInputData;
        this.queryTextInputData = builder.queryTextInputData;
        this.type = builder.type;
    }

    public final IntentInputData intentInputData() {
        return this.intentInputData;
    }

    public final QueryTextInputData queryTextInputData() {
        return this.queryTextInputData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentInputData());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryTextInputData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInputData)) {
            return false;
        }
        QueryInputData other = (QueryInputData)obj;
        return Objects.equals(this.intentInputData(), other.intentInputData()) && Objects.equals(this.queryTextInputData(), other.queryTextInputData());
    }

    public final String toString() {
        return ToString.builder((String)"QueryInputData").add("IntentInputData", (Object)this.intentInputData()).add("QueryTextInputData", (Object)this.queryTextInputData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentInputData": {
                return Optional.ofNullable(clazz.cast(this.intentInputData()));
            }
            case "queryTextInputData": {
                return Optional.ofNullable(clazz.cast(this.queryTextInputData()));
            }
        }
        return Optional.empty();
    }

    public static QueryInputData fromIntentInputData(IntentInputData intentInputData) {
        return (QueryInputData)QueryInputData.builder().intentInputData(intentInputData).build();
    }

    public static QueryInputData fromIntentInputData(Consumer<IntentInputData.Builder> intentInputData) {
        IntentInputData.Builder builder = IntentInputData.builder();
        intentInputData.accept(builder);
        return QueryInputData.fromIntentInputData((IntentInputData)builder.build());
    }

    public static QueryInputData fromQueryTextInputData(QueryTextInputData queryTextInputData) {
        return (QueryInputData)QueryInputData.builder().queryTextInputData(queryTextInputData).build();
    }

    public static QueryInputData fromQueryTextInputData(Consumer<QueryTextInputData.Builder> queryTextInputData) {
        QueryTextInputData.Builder builder = QueryTextInputData.builder();
        queryTextInputData.accept(builder);
        return QueryInputData.fromQueryTextInputData((QueryTextInputData)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryInputData, T> g) {
        return obj -> g.apply((QueryInputData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTENT_INPUT_DATA,
        QUERY_TEXT_INPUT_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IntentInputData intentInputData;
        private QueryTextInputData queryTextInputData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInputData model) {
            this.intentInputData(model.intentInputData);
            this.queryTextInputData(model.queryTextInputData);
        }

        public final IntentInputData.Builder getIntentInputData() {
            return this.intentInputData != null ? this.intentInputData.toBuilder() : null;
        }

        public final void setIntentInputData(IntentInputData.BuilderImpl intentInputData) {
            IntentInputData oldValue = this.intentInputData;
            this.intentInputData = intentInputData != null ? intentInputData.build() : null;
            this.handleUnionValueChange(Type.INTENT_INPUT_DATA, oldValue, this.intentInputData);
        }

        @Override
        public final Builder intentInputData(IntentInputData intentInputData) {
            IntentInputData oldValue = this.intentInputData;
            this.intentInputData = intentInputData;
            this.handleUnionValueChange(Type.INTENT_INPUT_DATA, oldValue, this.intentInputData);
            return this;
        }

        public final QueryTextInputData.Builder getQueryTextInputData() {
            return this.queryTextInputData != null ? this.queryTextInputData.toBuilder() : null;
        }

        public final void setQueryTextInputData(QueryTextInputData.BuilderImpl queryTextInputData) {
            QueryTextInputData oldValue = this.queryTextInputData;
            this.queryTextInputData = queryTextInputData != null ? queryTextInputData.build() : null;
            this.handleUnionValueChange(Type.QUERY_TEXT_INPUT_DATA, oldValue, this.queryTextInputData);
        }

        @Override
        public final Builder queryTextInputData(QueryTextInputData queryTextInputData) {
            QueryTextInputData oldValue = this.queryTextInputData;
            this.queryTextInputData = queryTextInputData;
            this.handleUnionValueChange(Type.QUERY_TEXT_INPUT_DATA, oldValue, this.queryTextInputData);
            return this;
        }

        public QueryInputData build() {
            return new QueryInputData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryInputData> {
        public Builder intentInputData(IntentInputData var1);

        default public Builder intentInputData(Consumer<IntentInputData.Builder> intentInputData) {
            return this.intentInputData((IntentInputData)((IntentInputData.Builder)IntentInputData.builder().applyMutation(intentInputData)).build());
        }

        public Builder queryTextInputData(QueryTextInputData var1);

        default public Builder queryTextInputData(Consumer<QueryTextInputData.Builder> queryTextInputData) {
            return this.queryTextInputData((QueryTextInputData)((QueryTextInputData.Builder)QueryTextInputData.builder().applyMutation(queryTextInputData)).build());
        }
    }
}

