/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterType;
import software.amazon.awssdk.services.qconnect.model.GuardrailFilterStrength;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentFilterConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentFilterConfig> {
    private static final SdkField<String> INPUT_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputStrength").getter(GuardrailContentFilterConfig.getter(GuardrailContentFilterConfig::inputStrengthAsString)).setter(GuardrailContentFilterConfig.setter(Builder::inputStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputStrength").build()}).build();
    private static final SdkField<String> OUTPUT_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputStrength").getter(GuardrailContentFilterConfig.getter(GuardrailContentFilterConfig::outputStrengthAsString)).setter(GuardrailContentFilterConfig.setter(Builder::outputStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputStrength").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailContentFilterConfig.getter(GuardrailContentFilterConfig::typeAsString)).setter(GuardrailContentFilterConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_STRENGTH_FIELD, OUTPUT_STRENGTH_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputStrength", INPUT_STRENGTH_FIELD);
            this.put("outputStrength", OUTPUT_STRENGTH_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String inputStrength;
    private final String outputStrength;
    private final String type;

    private GuardrailContentFilterConfig(BuilderImpl builder) {
        this.inputStrength = builder.inputStrength;
        this.outputStrength = builder.outputStrength;
        this.type = builder.type;
    }

    public final GuardrailFilterStrength inputStrength() {
        return GuardrailFilterStrength.fromValue(this.inputStrength);
    }

    public final String inputStrengthAsString() {
        return this.inputStrength;
    }

    public final GuardrailFilterStrength outputStrength() {
        return GuardrailFilterStrength.fromValue(this.outputStrength);
    }

    public final String outputStrengthAsString() {
        return this.outputStrength;
    }

    public final GuardrailContentFilterType type() {
        return GuardrailContentFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFilterConfig)) {
            return false;
        }
        GuardrailContentFilterConfig other = (GuardrailContentFilterConfig)obj;
        return Objects.equals(this.inputStrengthAsString(), other.inputStrengthAsString()) && Objects.equals(this.outputStrengthAsString(), other.outputStrengthAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentFilterConfig").add("InputStrength", (Object)(this.inputStrengthAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputStrength", (Object)(this.outputStrengthAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.typeAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputStrength": {
                return Optional.ofNullable(clazz.cast(this.inputStrengthAsString()));
            }
            case "outputStrength": {
                return Optional.ofNullable(clazz.cast(this.outputStrengthAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFilterConfig, T> g) {
        return obj -> g.apply((GuardrailContentFilterConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputStrength;
        private String outputStrength;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFilterConfig model) {
            this.inputStrength(model.inputStrength);
            this.outputStrength(model.outputStrength);
            this.type(model.type);
        }

        public final String getInputStrength() {
            return this.inputStrength;
        }

        public final void setInputStrength(String inputStrength) {
            this.inputStrength = inputStrength;
        }

        @Override
        public final Builder inputStrength(String inputStrength) {
            this.inputStrength = inputStrength;
            return this;
        }

        @Override
        public final Builder inputStrength(GuardrailFilterStrength inputStrength) {
            this.inputStrength(inputStrength == null ? null : inputStrength.toString());
            return this;
        }

        public final String getOutputStrength() {
            return this.outputStrength;
        }

        public final void setOutputStrength(String outputStrength) {
            this.outputStrength = outputStrength;
        }

        @Override
        public final Builder outputStrength(String outputStrength) {
            this.outputStrength = outputStrength;
            return this;
        }

        @Override
        public final Builder outputStrength(GuardrailFilterStrength outputStrength) {
            this.outputStrength(outputStrength == null ? null : outputStrength.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContentFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public GuardrailContentFilterConfig build() {
            return new GuardrailContentFilterConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentFilterConfig> {
        public Builder inputStrength(String var1);

        public Builder inputStrength(GuardrailFilterStrength var1);

        public Builder outputStrength(String var1);

        public Builder outputStrength(GuardrailFilterStrength var1);

        public Builder type(String var1);

        public Builder type(GuardrailContentFilterType var1);
    }
}

