/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.QuickResponseFilterOperator;
import software.amazon.awssdk.services.qconnect.model.QuickResponseFilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickResponseFilterField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickResponseFilterField> {
    private static final SdkField<Boolean> INCLUDE_NO_EXISTENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeNoExistence").getter(QuickResponseFilterField.getter(QuickResponseFilterField::includeNoExistence)).setter(QuickResponseFilterField.setter(Builder::includeNoExistence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeNoExistence").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(QuickResponseFilterField.getter(QuickResponseFilterField::name)).setter(QuickResponseFilterField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(QuickResponseFilterField.getter(QuickResponseFilterField::operatorAsString)).setter(QuickResponseFilterField.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(QuickResponseFilterField.getter(QuickResponseFilterField::values)).setter(QuickResponseFilterField.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_NO_EXISTENCE_FIELD, NAME_FIELD, OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("includeNoExistence", INCLUDE_NO_EXISTENCE_FIELD);
            this.put("name", NAME_FIELD);
            this.put("operator", OPERATOR_FIELD);
            this.put("values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean includeNoExistence;
    private final String name;
    private final String operator;
    private final List<String> values;

    private QuickResponseFilterField(BuilderImpl builder) {
        this.includeNoExistence = builder.includeNoExistence;
        this.name = builder.name;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final Boolean includeNoExistence() {
        return this.includeNoExistence;
    }

    public final String name() {
        return this.name;
    }

    public final QuickResponseFilterOperator operator() {
        return QuickResponseFilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNoExistence());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseFilterField)) {
            return false;
        }
        QuickResponseFilterField other = (QuickResponseFilterField)obj;
        return Objects.equals(this.includeNoExistence(), other.includeNoExistence()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"QuickResponseFilterField").add("IncludeNoExistence", (Object)this.includeNoExistence()).add("Name", (Object)this.name()).add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeNoExistence": {
                return Optional.ofNullable(clazz.cast(this.includeNoExistence()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseFilterField, T> g) {
        return obj -> g.apply((QuickResponseFilterField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean includeNoExistence;
        private String name;
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseFilterField model) {
            this.includeNoExistence(model.includeNoExistence);
            this.name(model.name);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final Boolean getIncludeNoExistence() {
            return this.includeNoExistence;
        }

        public final void setIncludeNoExistence(Boolean includeNoExistence) {
            this.includeNoExistence = includeNoExistence;
        }

        @Override
        public final Builder includeNoExistence(Boolean includeNoExistence) {
            this.includeNoExistence = includeNoExistence;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(QuickResponseFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = QuickResponseFilterValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = QuickResponseFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public QuickResponseFilterField build() {
            return new QuickResponseFilterField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickResponseFilterField> {
        public Builder includeNoExistence(Boolean var1);

        public Builder name(String var1);

        public Builder operator(String var1);

        public Builder operator(QuickResponseFilterOperator var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

