/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageTemplateAttributeType {
    SYSTEM("SYSTEM"),
    AGENT("AGENT"),
    CUSTOMER_PROFILE("CUSTOMER_PROFILE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageTemplateAttributeType> VALUE_MAP;
    private final String value;

    private MessageTemplateAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageTemplateAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageTemplateAttributeType> knownValues() {
        EnumSet<MessageTemplateAttributeType> knownValues = EnumSet.allOf(MessageTemplateAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageTemplateAttributeType.class, MessageTemplateAttributeType::toString);
    }
}

