/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIAgentAssociationConfigurationType;
import software.amazon.awssdk.services.qconnect.model.AssociationConfigurationData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationConfiguration> {
    private static final SdkField<AssociationConfigurationData> ASSOCIATION_CONFIGURATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("associationConfigurationData").getter(AssociationConfiguration.getter(AssociationConfiguration::associationConfigurationData)).setter(AssociationConfiguration.setter(Builder::associationConfigurationData)).constructor(AssociationConfigurationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurationData").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(AssociationConfiguration.getter(AssociationConfiguration::associationId)).setter(AssociationConfiguration.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(AssociationConfiguration.getter(AssociationConfiguration::associationTypeAsString)).setter(AssociationConfiguration.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_CONFIGURATION_DATA_FIELD, ASSOCIATION_ID_FIELD, ASSOCIATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssociationConfigurationData associationConfigurationData;
    private final String associationId;
    private final String associationType;

    private AssociationConfiguration(BuilderImpl builder) {
        this.associationConfigurationData = builder.associationConfigurationData;
        this.associationId = builder.associationId;
        this.associationType = builder.associationType;
    }

    public final AssociationConfigurationData associationConfigurationData() {
        return this.associationConfigurationData;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final AIAgentAssociationConfigurationType associationType() {
        return AIAgentAssociationConfigurationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationConfigurationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationConfiguration)) {
            return false;
        }
        AssociationConfiguration other = (AssociationConfiguration)obj;
        return Objects.equals(this.associationConfigurationData(), other.associationConfigurationData()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationConfiguration").add("AssociationConfigurationData", (Object)this.associationConfigurationData()).add("AssociationId", (Object)this.associationId()).add("AssociationType", (Object)this.associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationConfigurationData": {
                return Optional.ofNullable(clazz.cast(this.associationConfigurationData()));
            }
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associationConfigurationData", ASSOCIATION_CONFIGURATION_DATA_FIELD);
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationConfiguration, T> g) {
        return obj -> g.apply((AssociationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssociationConfigurationData associationConfigurationData;
        private String associationId;
        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationConfiguration model) {
            this.associationConfigurationData(model.associationConfigurationData);
            this.associationId(model.associationId);
            this.associationType(model.associationType);
        }

        public final AssociationConfigurationData.Builder getAssociationConfigurationData() {
            return this.associationConfigurationData != null ? this.associationConfigurationData.toBuilder() : null;
        }

        public final void setAssociationConfigurationData(AssociationConfigurationData.BuilderImpl associationConfigurationData) {
            this.associationConfigurationData = associationConfigurationData != null ? associationConfigurationData.build() : null;
        }

        @Override
        public final Builder associationConfigurationData(AssociationConfigurationData associationConfigurationData) {
            this.associationConfigurationData = associationConfigurationData;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AIAgentAssociationConfigurationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public AssociationConfiguration build() {
            return new AssociationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationConfiguration> {
        public Builder associationConfigurationData(AssociationConfigurationData var1);

        default public Builder associationConfigurationData(Consumer<AssociationConfigurationData.Builder> associationConfigurationData) {
            return this.associationConfigurationData((AssociationConfigurationData)((AssociationConfigurationData.Builder)AssociationConfigurationData.builder().applyMutation(associationConfigurationData)).build());
        }

        public Builder associationId(String var1);

        public Builder associationType(String var1);

        public Builder associationType(AIAgentAssociationConfigurationType var1);
    }
}

