/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.GuardrailContentFilterConfig;
import software.amazon.awssdk.services.qconnect.model.GuardrailContentFiltersConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIGuardrailContentPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIGuardrailContentPolicyConfig> {
    private static final SdkField<List<GuardrailContentFilterConfig>> FILTERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filtersConfig").getter(AIGuardrailContentPolicyConfig.getter(AIGuardrailContentPolicyConfig::filtersConfig)).setter(AIGuardrailContentPolicyConfig.setter(Builder::filtersConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filtersConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailContentFilterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIGuardrailContentPolicyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailContentFilterConfig> filtersConfig;

    private AIGuardrailContentPolicyConfig(BuilderImpl builder) {
        this.filtersConfig = builder.filtersConfig;
    }

    public final boolean hasFiltersConfig() {
        return this.filtersConfig != null && !(this.filtersConfig instanceof SdkAutoConstructList);
    }

    public final List<GuardrailContentFilterConfig> filtersConfig() {
        return this.filtersConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiltersConfig() ? this.filtersConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailContentPolicyConfig)) {
            return false;
        }
        AIGuardrailContentPolicyConfig other = (AIGuardrailContentPolicyConfig)obj;
        return this.hasFiltersConfig() == other.hasFiltersConfig() && Objects.equals(this.filtersConfig(), other.filtersConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AIGuardrailContentPolicyConfig").add("FiltersConfig", this.hasFiltersConfig() ? this.filtersConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filtersConfig": {
                return Optional.ofNullable(clazz.cast(this.filtersConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<GuardrailContentFilterConfig>>> map = new HashMap<String, SdkField<List<GuardrailContentFilterConfig>>>();
        map.put("filtersConfig", FILTERS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailContentPolicyConfig, T> g) {
        return obj -> g.apply((AIGuardrailContentPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailContentFilterConfig> filtersConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailContentPolicyConfig model) {
            this.filtersConfig(model.filtersConfig);
        }

        public final List<GuardrailContentFilterConfig.Builder> getFiltersConfig() {
            List<GuardrailContentFilterConfig.Builder> result = GuardrailContentFiltersConfigCopier.copyToBuilder(this.filtersConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiltersConfig(Collection<GuardrailContentFilterConfig.BuilderImpl> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copyFromBuilder(filtersConfig);
        }

        @Override
        public final Builder filtersConfig(Collection<GuardrailContentFilterConfig> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copy(filtersConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(GuardrailContentFilterConfig ... filtersConfig) {
            this.filtersConfig(Arrays.asList(filtersConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder> ... filtersConfig) {
            this.filtersConfig(Stream.of(filtersConfig).map(c -> (GuardrailContentFilterConfig)((GuardrailContentFilterConfig.Builder)GuardrailContentFilterConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AIGuardrailContentPolicyConfig build() {
            return new AIGuardrailContentPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIGuardrailContentPolicyConfig> {
        public Builder filtersConfig(Collection<GuardrailContentFilterConfig> var1);

        public Builder filtersConfig(GuardrailContentFilterConfig ... var1);

        public Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder> ... var1);
    }
}

