/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data for the AI Guardrail
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIGuardrailData implements SdkPojo, Serializable, ToCopyableBuilder<AIGuardrailData.Builder, AIGuardrailData> {
    private static final SdkField<String> AI_GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiGuardrailArn").getter(getter(AIGuardrailData::aiGuardrailArn)).setter(setter(Builder::aiGuardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailArn").build()).build();

    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiGuardrailId").getter(getter(AIGuardrailData::aiGuardrailId)).setter(setter(Builder::aiGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AIGuardrailData::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AIGuardrailData::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedInputMessaging").getter(getter(AIGuardrailData::blockedInputMessaging))
            .setter(setter(Builder::blockedInputMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build())
            .build();

    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedOutputsMessaging").getter(getter(AIGuardrailData::blockedOutputsMessaging))
            .setter(setter(Builder::blockedOutputsMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build())
            .build();

    private static final SdkField<AIGuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailContentPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("contentPolicyConfig")
            .getter(getter(AIGuardrailData::contentPolicyConfig)).setter(setter(Builder::contentPolicyConfig))
            .constructor(AIGuardrailContentPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build())
            .build();

    private static final SdkField<AIGuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailContextualGroundingPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("contextualGroundingPolicyConfig")
            .getter(getter(AIGuardrailData::contextualGroundingPolicyConfig))
            .setter(setter(Builder::contextualGroundingPolicyConfig))
            .constructor(AIGuardrailContextualGroundingPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AIGuardrailData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTime").getter(getter(AIGuardrailData::modifiedTime)).setter(setter(Builder::modifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AIGuardrailData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AIGuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailSensitiveInformationPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sensitiveInformationPolicyConfig")
            .getter(getter(AIGuardrailData::sensitiveInformationPolicyConfig))
            .setter(setter(Builder::sensitiveInformationPolicyConfig))
            .constructor(AIGuardrailSensitiveInformationPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AIGuardrailData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AIGuardrailData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AIGuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailTopicPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("topicPolicyConfig")
            .getter(getter(AIGuardrailData::topicPolicyConfig)).setter(setter(Builder::topicPolicyConfig))
            .constructor(AIGuardrailTopicPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(AIGuardrailData::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<AIGuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailWordPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("wordPolicyConfig")
            .getter(getter(AIGuardrailData::wordPolicyConfig)).setter(setter(Builder::wordPolicyConfig))
            .constructor(AIGuardrailWordPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_ARN_FIELD,
            AI_GUARDRAIL_ID_FIELD, ASSISTANT_ARN_FIELD, ASSISTANT_ID_FIELD, BLOCKED_INPUT_MESSAGING_FIELD,
            BLOCKED_OUTPUTS_MESSAGING_FIELD, CONTENT_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD,
            DESCRIPTION_FIELD, MODIFIED_TIME_FIELD, NAME_FIELD, SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, STATUS_FIELD,
            TAGS_FIELD, TOPIC_POLICY_CONFIG_FIELD, VISIBILITY_STATUS_FIELD, WORD_POLICY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aiGuardrailArn;

    private final String aiGuardrailId;

    private final String assistantArn;

    private final String assistantId;

    private final String blockedInputMessaging;

    private final String blockedOutputsMessaging;

    private final AIGuardrailContentPolicyConfig contentPolicyConfig;

    private final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

    private final String description;

    private final Instant modifiedTime;

    private final String name;

    private final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

    private final String status;

    private final Map<String, String> tags;

    private final AIGuardrailTopicPolicyConfig topicPolicyConfig;

    private final String visibilityStatus;

    private final AIGuardrailWordPolicyConfig wordPolicyConfig;

    private AIGuardrailData(BuilderImpl builder) {
        this.aiGuardrailArn = builder.aiGuardrailArn;
        this.aiGuardrailId = builder.aiGuardrailId;
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.description = builder.description;
        this.modifiedTime = builder.modifiedTime;
        this.name = builder.name;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.status = builder.status;
        this.tags = builder.tags;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.visibilityStatus = builder.visibilityStatus;
        this.wordPolicyConfig = builder.wordPolicyConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AI Guardrail.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AI Guardrail.
     */
    public final String aiGuardrailArn() {
        return aiGuardrailArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI Guardrail.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI Guardrail.
     */
    public final String aiGuardrailId() {
        return aiGuardrailId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The message to return when the AI Guardrail blocks a prompt.
     * </p>
     * 
     * @return The message to return when the AI Guardrail blocks a prompt.
     */
    public final String blockedInputMessaging() {
        return blockedInputMessaging;
    }

    /**
     * <p>
     * The message to return when the AI Guardrail blocks a model response.
     * </p>
     * 
     * @return The message to return when the AI Guardrail blocks a model response.
     */
    public final String blockedOutputsMessaging() {
        return blockedOutputsMessaging;
    }

    /**
     * <p>
     * Contains details about how to handle harmful content.
     * </p>
     * 
     * @return Contains details about how to handle harmful content.
     */
    public final AIGuardrailContentPolicyConfig contentPolicyConfig() {
        return contentPolicyConfig;
    }

    /**
     * <p>
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     * </p>
     * 
     * @return The policy configuration details for the AI Guardrail's contextual grounding policy.
     */
    public final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return contextualGroundingPolicyConfig;
    }

    /**
     * <p>
     * A description of the AI Guardrail.
     * </p>
     * 
     * @return A description of the AI Guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time the AI Guardrail was last modified.
     * </p>
     * 
     * @return The time the AI Guardrail was last modified.
     */
    public final Instant modifiedTime() {
        return modifiedTime;
    }

    /**
     * <p>
     * The name of the AI Guardrail.
     * </p>
     * 
     * @return The name of the AI Guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     * </p>
     * 
     * @return Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     */
    public final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return sensitiveInformationPolicyConfig;
    }

    /**
     * <p>
     * The status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Guardrail.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Guardrail.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains details about topics that the AI Guardrail should identify and deny.
     * </p>
     * 
     * @return Contains details about topics that the AI Guardrail should identify and deny.
     */
    public final AIGuardrailTopicPolicyConfig topicPolicyConfig() {
        return topicPolicyConfig;
    }

    /**
     * <p>
     * The visibility status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Guardrail.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Guardrail.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * <p>
     * Contains details about the word policy to configured for the AI Guardrail.
     * </p>
     * 
     * @return Contains details about the word policy to configured for the AI Guardrail.
     */
    public final AIGuardrailWordPolicyConfig wordPolicyConfig() {
        return wordPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailData)) {
            return false;
        }
        AIGuardrailData other = (AIGuardrailData) obj;
        return Objects.equals(aiGuardrailArn(), other.aiGuardrailArn()) && Objects.equals(aiGuardrailId(), other.aiGuardrailId())
                && Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(blockedInputMessaging(), other.blockedInputMessaging())
                && Objects.equals(blockedOutputsMessaging(), other.blockedOutputsMessaging())
                && Objects.equals(contentPolicyConfig(), other.contentPolicyConfig())
                && Objects.equals(contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig())
                && Objects.equals(description(), other.description()) && Objects.equals(modifiedTime(), other.modifiedTime())
                && Objects.equals(name(), other.name())
                && Objects.equals(sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(topicPolicyConfig(), other.topicPolicyConfig())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString())
                && Objects.equals(wordPolicyConfig(), other.wordPolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIGuardrailData").add("AiGuardrailArn", aiGuardrailArn()).add("AiGuardrailId", aiGuardrailId())
                .add("AssistantArn", assistantArn()).add("AssistantId", assistantId())
                .add("BlockedInputMessaging", blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedOutputsMessaging", blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentPolicyConfig", contentPolicyConfig())
                .add("ContextualGroundingPolicyConfig", contextualGroundingPolicyConfig())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModifiedTime", modifiedTime()).add("Name", name())
                .add("SensitiveInformationPolicyConfig", sensitiveInformationPolicyConfig()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("TopicPolicyConfig", topicPolicyConfig())
                .add("VisibilityStatus", visibilityStatusAsString()).add("WordPolicyConfig", wordPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrailArn":
            return Optional.ofNullable(clazz.cast(aiGuardrailArn()));
        case "aiGuardrailId":
            return Optional.ofNullable(clazz.cast(aiGuardrailId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "blockedInputMessaging":
            return Optional.ofNullable(clazz.cast(blockedInputMessaging()));
        case "blockedOutputsMessaging":
            return Optional.ofNullable(clazz.cast(blockedOutputsMessaging()));
        case "contentPolicyConfig":
            return Optional.ofNullable(clazz.cast(contentPolicyConfig()));
        case "contextualGroundingPolicyConfig":
            return Optional.ofNullable(clazz.cast(contextualGroundingPolicyConfig()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modifiedTime":
            return Optional.ofNullable(clazz.cast(modifiedTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sensitiveInformationPolicyConfig":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicyConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "topicPolicyConfig":
            return Optional.ofNullable(clazz.cast(topicPolicyConfig()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "wordPolicyConfig":
            return Optional.ofNullable(clazz.cast(wordPolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrailArn", AI_GUARDRAIL_ARN_FIELD);
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailData, T> g) {
        return obj -> g.apply((AIGuardrailData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIGuardrailData> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AI Guardrail.
         * </p>
         * 
         * @param aiGuardrailArn
         *        The Amazon Resource Name (ARN) of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailArn(String aiGuardrailArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI Guardrail.
         * </p>
         * 
         * @param aiGuardrailId
         *        The identifier of the Amazon Q in Connect AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailId(String aiGuardrailId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The message to return when the AI Guardrail blocks a prompt.
         * </p>
         * 
         * @param blockedInputMessaging
         *        The message to return when the AI Guardrail blocks a prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedInputMessaging(String blockedInputMessaging);

        /**
         * <p>
         * The message to return when the AI Guardrail blocks a model response.
         * </p>
         * 
         * @param blockedOutputsMessaging
         *        The message to return when the AI Guardrail blocks a model response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedOutputsMessaging(String blockedOutputsMessaging);

        /**
         * <p>
         * Contains details about how to handle harmful content.
         * </p>
         * 
         * @param contentPolicyConfig
         *        Contains details about how to handle harmful content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig);

        /**
         * <p>
         * Contains details about how to handle harmful content.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailContentPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailContentPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailContentPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #contentPolicyConfig(AIGuardrailContentPolicyConfig)}.
         * 
         * @param contentPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailContentPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentPolicyConfig(AIGuardrailContentPolicyConfig)
         */
        default Builder contentPolicyConfig(Consumer<AIGuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return contentPolicyConfig(AIGuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig).build());
        }

        /**
         * <p>
         * The policy configuration details for the AI Guardrail's contextual grounding policy.
         * </p>
         * 
         * @param contextualGroundingPolicyConfig
         *        The policy configuration details for the AI Guardrail's contextual grounding policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig);

        /**
         * <p>
         * The policy configuration details for the AI Guardrail's contextual grounding policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AIGuardrailContextualGroundingPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link AIGuardrailContextualGroundingPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailContextualGroundingPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig)}.
         * 
         * @param contextualGroundingPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailContextualGroundingPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig)
         */
        default Builder contextualGroundingPolicyConfig(
                Consumer<AIGuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig.builder()
                    .applyMutation(contextualGroundingPolicyConfig).build());
        }

        /**
         * <p>
         * A description of the AI Guardrail.
         * </p>
         * 
         * @param description
         *        A description of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time the AI Guardrail was last modified.
         * </p>
         * 
         * @param modifiedTime
         *        The time the AI Guardrail was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTime(Instant modifiedTime);

        /**
         * <p>
         * The name of the AI Guardrail.
         * </p>
         * 
         * @param name
         *        The name of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicyConfig
         *        Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig);

        /**
         * <p>
         * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AIGuardrailSensitiveInformationPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link AIGuardrailSensitiveInformationPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailSensitiveInformationPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig)}.
         * 
         * @param sensitiveInformationPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailSensitiveInformationPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig)
         */
        default Builder sensitiveInformationPolicyConfig(
                Consumer<AIGuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig.builder()
                    .applyMutation(sensitiveInformationPolicyConfig).build());
        }

        /**
         * <p>
         * The status of the AI Guardrail.
         * </p>
         * 
         * @param status
         *        The status of the AI Guardrail.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the AI Guardrail.
         * </p>
         * 
         * @param status
         *        The status of the AI Guardrail.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Contains details about topics that the AI Guardrail should identify and deny.
         * </p>
         * 
         * @param topicPolicyConfig
         *        Contains details about topics that the AI Guardrail should identify and deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig);

        /**
         * <p>
         * Contains details about topics that the AI Guardrail should identify and deny.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailTopicPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailTopicPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailTopicPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #topicPolicyConfig(AIGuardrailTopicPolicyConfig)}.
         * 
         * @param topicPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailTopicPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPolicyConfig(AIGuardrailTopicPolicyConfig)
         */
        default Builder topicPolicyConfig(Consumer<AIGuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return topicPolicyConfig(AIGuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig).build());
        }

        /**
         * <p>
         * The visibility status of the AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * Contains details about the word policy to configured for the AI Guardrail.
         * </p>
         * 
         * @param wordPolicyConfig
         *        Contains details about the word policy to configured for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig);

        /**
         * <p>
         * Contains details about the word policy to configured for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailWordPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailWordPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailWordPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #wordPolicyConfig(AIGuardrailWordPolicyConfig)}.
         * 
         * @param wordPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailWordPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordPolicyConfig(AIGuardrailWordPolicyConfig)
         */
        default Builder wordPolicyConfig(Consumer<AIGuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return wordPolicyConfig(AIGuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String aiGuardrailArn;

        private String aiGuardrailId;

        private String assistantArn;

        private String assistantId;

        private String blockedInputMessaging;

        private String blockedOutputsMessaging;

        private AIGuardrailContentPolicyConfig contentPolicyConfig;

        private AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

        private String description;

        private Instant modifiedTime;

        private String name;

        private AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AIGuardrailTopicPolicyConfig topicPolicyConfig;

        private String visibilityStatus;

        private AIGuardrailWordPolicyConfig wordPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailData model) {
            aiGuardrailArn(model.aiGuardrailArn);
            aiGuardrailId(model.aiGuardrailId);
            assistantArn(model.assistantArn);
            assistantId(model.assistantId);
            blockedInputMessaging(model.blockedInputMessaging);
            blockedOutputsMessaging(model.blockedOutputsMessaging);
            contentPolicyConfig(model.contentPolicyConfig);
            contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            description(model.description);
            modifiedTime(model.modifiedTime);
            name(model.name);
            sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            status(model.status);
            tags(model.tags);
            topicPolicyConfig(model.topicPolicyConfig);
            visibilityStatus(model.visibilityStatus);
            wordPolicyConfig(model.wordPolicyConfig);
        }

        public final String getAiGuardrailArn() {
            return aiGuardrailArn;
        }

        public final void setAiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
        }

        @Override
        public final Builder aiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
            return this;
        }

        public final String getAiGuardrailId() {
            return aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final AIGuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return contentPolicyConfig != null ? contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(AIGuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final AIGuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(
                AIGuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(
                AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getModifiedTime() {
            return modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AIGuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(
                AIGuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(
                AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AIGuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return topicPolicyConfig != null ? topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(AIGuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIGuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return wordPolicyConfig != null ? wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(AIGuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        @Override
        public AIGuardrailData build() {
            return new AIGuardrailData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
