/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the AI Guardrail version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIGuardrailVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AIGuardrailVersionSummary.Builder, AIGuardrailVersionSummary> {
    private static final SdkField<AIGuardrailSummary> AI_GUARDRAIL_SUMMARY_FIELD = SdkField
            .<AIGuardrailSummary> builder(MarshallingType.SDK_POJO).memberName("aiGuardrailSummary")
            .getter(getter(AIGuardrailVersionSummary::aiGuardrailSummary)).setter(setter(Builder::aiGuardrailSummary))
            .constructor(AIGuardrailSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailSummary").build())
            .build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(AIGuardrailVersionSummary::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_SUMMARY_FIELD,
            VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AIGuardrailSummary aiGuardrailSummary;

    private final Long versionNumber;

    private AIGuardrailVersionSummary(BuilderImpl builder) {
        this.aiGuardrailSummary = builder.aiGuardrailSummary;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The data for the summary of the AI Guardrail version.
     * </p>
     * 
     * @return The data for the summary of the AI Guardrail version.
     */
    public final AIGuardrailSummary aiGuardrailSummary() {
        return aiGuardrailSummary;
    }

    /**
     * <p>
     * The version number for this AI Guardrail version.
     * </p>
     * 
     * @return The version number for this AI Guardrail version.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailSummary());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailVersionSummary)) {
            return false;
        }
        AIGuardrailVersionSummary other = (AIGuardrailVersionSummary) obj;
        return Objects.equals(aiGuardrailSummary(), other.aiGuardrailSummary())
                && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIGuardrailVersionSummary").add("AiGuardrailSummary", aiGuardrailSummary())
                .add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrailSummary":
            return Optional.ofNullable(clazz.cast(aiGuardrailSummary()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrailSummary", AI_GUARDRAIL_SUMMARY_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailVersionSummary, T> g) {
        return obj -> g.apply((AIGuardrailVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIGuardrailVersionSummary> {
        /**
         * <p>
         * The data for the summary of the AI Guardrail version.
         * </p>
         * 
         * @param aiGuardrailSummary
         *        The data for the summary of the AI Guardrail version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailSummary(AIGuardrailSummary aiGuardrailSummary);

        /**
         * <p>
         * The data for the summary of the AI Guardrail version.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailSummary.Builder} avoiding the
         * need to create one manually via {@link AIGuardrailSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #aiGuardrailSummary(AIGuardrailSummary)}.
         * 
         * @param aiGuardrailSummary
         *        a consumer that will call methods on {@link AIGuardrailSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiGuardrailSummary(AIGuardrailSummary)
         */
        default Builder aiGuardrailSummary(Consumer<AIGuardrailSummary.Builder> aiGuardrailSummary) {
            return aiGuardrailSummary(AIGuardrailSummary.builder().applyMutation(aiGuardrailSummary).build());
        }

        /**
         * <p>
         * The version number for this AI Guardrail version.
         * </p>
         * 
         * @param versionNumber
         *        The version number for this AI Guardrail version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl implements Builder {
        private AIGuardrailSummary aiGuardrailSummary;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailVersionSummary model) {
            aiGuardrailSummary(model.aiGuardrailSummary);
            versionNumber(model.versionNumber);
        }

        public final AIGuardrailSummary.Builder getAiGuardrailSummary() {
            return aiGuardrailSummary != null ? aiGuardrailSummary.toBuilder() : null;
        }

        public final void setAiGuardrailSummary(AIGuardrailSummary.BuilderImpl aiGuardrailSummary) {
            this.aiGuardrailSummary = aiGuardrailSummary != null ? aiGuardrailSummary.build() : null;
        }

        @Override
        public final Builder aiGuardrailSummary(AIGuardrailSummary aiGuardrailSummary) {
            this.aiGuardrailSummary = aiGuardrailSummary;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public AIGuardrailVersionSummary build() {
            return new AIGuardrailVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
