/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about where the text with a citation begins and ends in the generated output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CitationSpan implements SdkPojo, Serializable, ToCopyableBuilder<CitationSpan.Builder, CitationSpan> {
    private static final SdkField<Integer> BEGIN_OFFSET_INCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("beginOffsetInclusive").getter(getter(CitationSpan::beginOffsetInclusive))
            .setter(setter(Builder::beginOffsetInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beginOffsetInclusive").build())
            .build();

    private static final SdkField<Integer> END_OFFSET_EXCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endOffsetExclusive").getter(getter(CitationSpan::endOffsetExclusive))
            .setter(setter(Builder::endOffsetExclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOffsetExclusive").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_INCLUSIVE_FIELD,
            END_OFFSET_EXCLUSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer beginOffsetInclusive;

    private final Integer endOffsetExclusive;

    private CitationSpan(BuilderImpl builder) {
        this.beginOffsetInclusive = builder.beginOffsetInclusive;
        this.endOffsetExclusive = builder.endOffsetExclusive;
    }

    /**
     * <p>
     * Where the text with a citation starts in the generated output.
     * </p>
     * 
     * @return Where the text with a citation starts in the generated output.
     */
    public final Integer beginOffsetInclusive() {
        return beginOffsetInclusive;
    }

    /**
     * <p>
     * Where the text with a citation ends in the generated output.
     * </p>
     * 
     * @return Where the text with a citation ends in the generated output.
     */
    public final Integer endOffsetExclusive() {
        return endOffsetExclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetExclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationSpan)) {
            return false;
        }
        CitationSpan other = (CitationSpan) obj;
        return Objects.equals(beginOffsetInclusive(), other.beginOffsetInclusive())
                && Objects.equals(endOffsetExclusive(), other.endOffsetExclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CitationSpan").add("BeginOffsetInclusive", beginOffsetInclusive())
                .add("EndOffsetExclusive", endOffsetExclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beginOffsetInclusive":
            return Optional.ofNullable(clazz.cast(beginOffsetInclusive()));
        case "endOffsetExclusive":
            return Optional.ofNullable(clazz.cast(endOffsetExclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("beginOffsetInclusive", BEGIN_OFFSET_INCLUSIVE_FIELD);
        map.put("endOffsetExclusive", END_OFFSET_EXCLUSIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationSpan, T> g) {
        return obj -> g.apply((CitationSpan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CitationSpan> {
        /**
         * <p>
         * Where the text with a citation starts in the generated output.
         * </p>
         * 
         * @param beginOffsetInclusive
         *        Where the text with a citation starts in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetInclusive(Integer beginOffsetInclusive);

        /**
         * <p>
         * Where the text with a citation ends in the generated output.
         * </p>
         * 
         * @param endOffsetExclusive
         *        Where the text with a citation ends in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetExclusive(Integer endOffsetExclusive);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffsetInclusive;

        private Integer endOffsetExclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(CitationSpan model) {
            beginOffsetInclusive(model.beginOffsetInclusive);
            endOffsetExclusive(model.endOffsetExclusive);
        }

        public final Integer getBeginOffsetInclusive() {
            return beginOffsetInclusive;
        }

        public final void setBeginOffsetInclusive(Integer beginOffsetInclusive) {
            this.beginOffsetInclusive = beginOffsetInclusive;
        }

        @Override
        public final Builder beginOffsetInclusive(Integer beginOffsetInclusive) {
            this.beginOffsetInclusive = beginOffsetInclusive;
            return this;
        }

        public final Integer getEndOffsetExclusive() {
            return endOffsetExclusive;
        }

        public final void setEndOffsetExclusive(Integer endOffsetExclusive) {
            this.endOffsetExclusive = endOffsetExclusive;
        }

        @Override
        public final Builder endOffsetExclusive(Integer endOffsetExclusive) {
            this.endOffsetExclusive = endOffsetExclusive;
            return this;
        }

        @Override
        public CitationSpan build() {
            return new CitationSpan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
