/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAiGuardrailResponse extends QConnectResponse implements
        ToCopyableBuilder<CreateAiGuardrailResponse.Builder, CreateAiGuardrailResponse> {
    private static final SdkField<AIGuardrailData> AI_GUARDRAIL_FIELD = SdkField
            .<AIGuardrailData> builder(MarshallingType.SDK_POJO).memberName("aiGuardrail")
            .getter(getter(CreateAiGuardrailResponse::aiGuardrail)).setter(setter(Builder::aiGuardrail))
            .constructor(AIGuardrailData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AIGuardrailData aiGuardrail;

    private CreateAiGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.aiGuardrail = builder.aiGuardrail;
    }

    /**
     * <p>
     * The data of the AI Guardrail.
     * </p>
     * 
     * @return The data of the AI Guardrail.
     */
    public final AIGuardrailData aiGuardrail() {
        return aiGuardrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiGuardrailResponse)) {
            return false;
        }
        CreateAiGuardrailResponse other = (CreateAiGuardrailResponse) obj;
        return Objects.equals(aiGuardrail(), other.aiGuardrail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAiGuardrailResponse").add("AiGuardrail", aiGuardrail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrail":
            return Optional.ofNullable(clazz.cast(aiGuardrail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrail", AI_GUARDRAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiGuardrailResponse, T> g) {
        return obj -> g.apply((CreateAiGuardrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAiGuardrailResponse> {
        /**
         * <p>
         * The data of the AI Guardrail.
         * </p>
         * 
         * @param aiGuardrail
         *        The data of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrail(AIGuardrailData aiGuardrail);

        /**
         * <p>
         * The data of the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailData.Builder} avoiding the
         * need to create one manually via {@link AIGuardrailData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailData.Builder#build()} is called immediately and its
         * result is passed to {@link #aiGuardrail(AIGuardrailData)}.
         * 
         * @param aiGuardrail
         *        a consumer that will call methods on {@link AIGuardrailData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiGuardrail(AIGuardrailData)
         */
        default Builder aiGuardrail(Consumer<AIGuardrailData.Builder> aiGuardrail) {
            return aiGuardrail(AIGuardrailData.builder().applyMutation(aiGuardrail).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private AIGuardrailData aiGuardrail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiGuardrailResponse model) {
            super(model);
            aiGuardrail(model.aiGuardrail);
        }

        public final AIGuardrailData.Builder getAiGuardrail() {
            return aiGuardrail != null ? aiGuardrail.toBuilder() : null;
        }

        public final void setAiGuardrail(AIGuardrailData.BuilderImpl aiGuardrail) {
            this.aiGuardrail = aiGuardrail != null ? aiGuardrail.build() : null;
        }

        @Override
        public final Builder aiGuardrail(AIGuardrailData aiGuardrail) {
            this.aiGuardrail = aiGuardrail;
            return this;
        }

        @Override
        public CreateAiGuardrailResponse build() {
            return new CreateAiGuardrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
