/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMessageTemplateRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateMessageTemplateRequest.Builder, CreateMessageTemplateRequest> {
    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelSubtype").getter(getter(CreateMessageTemplateRequest::channelSubtypeAsString))
            .setter(setter(Builder::channelSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateMessageTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField
            .<MessageTemplateContentProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(CreateMessageTemplateRequest::content)).setter(setter(Builder::content))
            .constructor(MessageTemplateContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField
            .<MessageTemplateAttributes> builder(MarshallingType.SDK_POJO).memberName("defaultAttributes")
            .getter(getter(CreateMessageTemplateRequest::defaultAttributes)).setter(setter(Builder::defaultAttributes))
            .constructor(MessageTemplateAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateMessageTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(CreateMessageTemplateRequest::groupingConfiguration)).setter(setter(Builder::groupingConfiguration))
            .constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(CreateMessageTemplateRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(CreateMessageTemplateRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMessageTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMessageTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_SUBTYPE_FIELD,
            CLIENT_TOKEN_FIELD, CONTENT_FIELD, DEFAULT_ATTRIBUTES_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD,
            KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelSubtype;

    private final String clientToken;

    private final MessageTemplateContentProvider content;

    private final MessageTemplateAttributes defaultAttributes;

    private final String description;

    private final GroupingConfiguration groupingConfiguration;

    private final String knowledgeBaseId;

    private final String language;

    private final String name;

    private final Map<String, String> tags;

    private CreateMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.channelSubtype = builder.channelSubtype;
        this.clientToken = builder.clientToken;
        this.content = builder.content;
        this.defaultAttributes = builder.defaultAttributes;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(channelSubtype);
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final String channelSubtypeAsString() {
        return channelSubtype;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The content of the message template.
     * </p>
     * 
     * @return The content of the message template.
     */
    public final MessageTemplateContentProvider content() {
        return content;
    }

    /**
     * <p>
     * An object that specifies the default values to use for variables in the message template. This object contains
     * different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The
     * corresponding value defines the default value for that variable.
     * </p>
     * 
     * @return An object that specifies the default values to use for variables in the message template. This object
     *         contains different categories of key-value pairs. Each key defines a variable or placeholder in the
     *         message template. The corresponding value defines the default value for that variable.
     */
    public final MessageTemplateAttributes defaultAttributes() {
        return defaultAttributes;
    }

    /**
     * <p>
     * The description of the message template.
     * </p>
     * 
     * @return The description of the message template.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the GroupingConfiguration property for this object.
     * 
     * @return The value of the GroupingConfiguration property for this object.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written. The supported language codes
     * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
     * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
     * <code>zh_TW</code>
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written. The supported language
     *         codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
     *         <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
     *         <code>zh_CN</code>, <code>zh_TW</code>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateRequest)) {
            return false;
        }
        CreateMessageTemplateRequest other = (CreateMessageTemplateRequest) obj;
        return Objects.equals(channelSubtypeAsString(), other.channelSubtypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(content(), other.content())
                && Objects.equals(defaultAttributes(), other.defaultAttributes())
                && Objects.equals(description(), other.description())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(language(), other.language())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMessageTemplateRequest").add("ChannelSubtype", channelSubtypeAsString())
                .add("ClientToken", clientToken()).add("Content", content()).add("DefaultAttributes", defaultAttributes())
                .add("Description", description()).add("GroupingConfiguration", groupingConfiguration())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Language", language()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelSubtype":
            return Optional.ofNullable(clazz.cast(channelSubtypeAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "defaultAttributes":
            return Optional.ofNullable(clazz.cast(defaultAttributes()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateRequest, T> g) {
        return obj -> g.apply((CreateMessageTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMessageTemplateRequest> {
        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(String channelSubtype);

        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(ChannelSubtype channelSubtype);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * 
         * @param content
         *        The content of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(MessageTemplateContentProvider content);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateContentProvider.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #content(MessageTemplateContentProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link MessageTemplateContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(MessageTemplateContentProvider)
         */
        default Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return content(MessageTemplateContentProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultAttributes
         *        An object that specifies the default values to use for variables in the message template. This object
         *        contains different categories of key-value pairs. Each key defines a variable or placeholder in the
         *        message template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAttributes(MessageTemplateAttributes defaultAttributes);

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateAttributes.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultAttributes(MessageTemplateAttributes)}.
         * 
         * @param defaultAttributes
         *        a consumer that will call methods on {@link MessageTemplateAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAttributes(MessageTemplateAttributes)
         */
        default Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return defaultAttributes(MessageTemplateAttributes.builder().applyMutation(defaultAttributes).build());
        }

        /**
         * <p>
         * The description of the message template.
         * </p>
         * 
         * @param description
         *        The description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * @param groupingConfiguration
         *        The new value for the GroupingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The language code value for the language in which the quick response is written. The supported language codes
         * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
         * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
         * <code>zh_TW</code>
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written. The supported
         *        language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
         *        <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
         *        <code>zh_CN</code>, <code>zh_TW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param name
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String channelSubtype;

        private String clientToken;

        private MessageTemplateContentProvider content;

        private MessageTemplateAttributes defaultAttributes;

        private String description;

        private GroupingConfiguration groupingConfiguration;

        private String knowledgeBaseId;

        private String language;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateRequest model) {
            super(model);
            channelSubtype(model.channelSubtype);
            clientToken(model.clientToken);
            content(model.content);
            defaultAttributes(model.defaultAttributes);
            description(model.description);
            groupingConfiguration(model.groupingConfiguration);
            knowledgeBaseId(model.knowledgeBaseId);
            language(model.language);
            name(model.name);
            tags(model.tags);
        }

        public final String getChannelSubtype() {
            return channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return defaultAttributes != null ? defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMessageTemplateRequest build() {
            return new CreateMessageTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
