/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeactivateMessageTemplateResponse extends QConnectResponse implements
        ToCopyableBuilder<DeactivateMessageTemplateResponse.Builder, DeactivateMessageTemplateResponse> {
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateArn").getter(getter(DeactivateMessageTemplateResponse::messageTemplateArn))
            .setter(setter(Builder::messageTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build())
            .build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(DeactivateMessageTemplateResponse::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(DeactivateMessageTemplateResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_ARN_FIELD,
            MESSAGE_TEMPLATE_ID_FIELD, VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String messageTemplateArn;

    private final String messageTemplateId;

    private final Long versionNumber;

    private DeactivateMessageTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateId = builder.messageTemplateId;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public final String messageTemplateArn() {
        return messageTemplateArn;
    }

    /**
     * <p>
     * The identifier of the message template.
     * </p>
     * 
     * @return The identifier of the message template.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The version number of the message template version that has been deactivated.
     * </p>
     * 
     * @return The version number of the message template version that has been deactivated.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivateMessageTemplateResponse)) {
            return false;
        }
        DeactivateMessageTemplateResponse other = (DeactivateMessageTemplateResponse) obj;
        return Objects.equals(messageTemplateArn(), other.messageTemplateArn())
                && Objects.equals(messageTemplateId(), other.messageTemplateId())
                && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeactivateMessageTemplateResponse").add("MessageTemplateArn", messageTemplateArn())
                .add("MessageTemplateId", messageTemplateId()).add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageTemplateArn":
            return Optional.ofNullable(clazz.cast(messageTemplateArn()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeactivateMessageTemplateResponse, T> g) {
        return obj -> g.apply((DeactivateMessageTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeactivateMessageTemplateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param messageTemplateArn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateArn(String messageTemplateArn);

        /**
         * <p>
         * The identifier of the message template.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The version number of the message template version that has been deactivated.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the message template version that has been deactivated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private String messageTemplateArn;

        private String messageTemplateId;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivateMessageTemplateResponse model) {
            super(model);
            messageTemplateArn(model.messageTemplateArn);
            messageTemplateId(model.messageTemplateId);
            versionNumber(model.versionNumber);
        }

        public final String getMessageTemplateArn() {
            return messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public DeactivateMessageTemplateResponse build() {
            return new DeactivateMessageTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
