/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the message template that applies to the email channel subtype.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMessageTemplateContent implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailMessageTemplateContent.Builder, EmailMessageTemplateContent> {
    private static final SdkField<EmailMessageTemplateContentBody> BODY_FIELD = SdkField
            .<EmailMessageTemplateContentBody> builder(MarshallingType.SDK_POJO).memberName("body")
            .getter(getter(EmailMessageTemplateContent::body)).setter(setter(Builder::body))
            .constructor(EmailMessageTemplateContentBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<List<EmailHeader>> HEADERS_FIELD = SdkField
            .<List<EmailHeader>> builder(MarshallingType.LIST)
            .memberName("headers")
            .getter(getter(EmailMessageTemplateContent::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(EmailMessageTemplateContent::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, HEADERS_FIELD,
            SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EmailMessageTemplateContentBody body;

    private final List<EmailHeader> headers;

    private final String subject;

    private EmailMessageTemplateContent(BuilderImpl builder) {
        this.body = builder.body;
        this.headers = builder.headers;
        this.subject = builder.subject;
    }

    /**
     * <p>
     * The body to use in email messages.
     * </p>
     * 
     * @return The body to use in email messages.
     */
    public final EmailMessageTemplateContentBody body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email headers to include in email messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The email headers to include in email messages.
     */
    public final List<EmailHeader> headers() {
        return headers;
    }

    /**
     * <p>
     * The subject line, or title, to use in email messages.
     * </p>
     * 
     * @return The subject line, or title, to use in email messages.
     */
    public final String subject() {
        return subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessageTemplateContent)) {
            return false;
        }
        EmailMessageTemplateContent other = (EmailMessageTemplateContent) obj;
        return Objects.equals(body(), other.body()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headers(), other.headers()) && Objects.equals(subject(), other.subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailMessageTemplateContent").add("Body", body())
                .add("Headers", hasHeaders() ? headers() : null)
                .add("Subject", subject() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("subject", SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMessageTemplateContent, T> g) {
        return obj -> g.apply((EmailMessageTemplateContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMessageTemplateContent> {
        /**
         * <p>
         * The body to use in email messages.
         * </p>
         * 
         * @param body
         *        The body to use in email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(EmailMessageTemplateContentBody body);

        /**
         * <p>
         * The body to use in email messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMessageTemplateContentBody.Builder}
         * avoiding the need to create one manually via {@link EmailMessageTemplateContentBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMessageTemplateContentBody.Builder#build()} is called
         * immediately and its result is passed to {@link #body(EmailMessageTemplateContentBody)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link EmailMessageTemplateContentBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(EmailMessageTemplateContentBody)
         */
        default Builder body(Consumer<EmailMessageTemplateContentBody.Builder> body) {
            return body(EmailMessageTemplateContentBody.builder().applyMutation(body).build());
        }

        /**
         * <p>
         * The email headers to include in email messages.
         * </p>
         * 
         * @param headers
         *        The email headers to include in email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<EmailHeader> headers);

        /**
         * <p>
         * The email headers to include in email messages.
         * </p>
         * 
         * @param headers
         *        The email headers to include in email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(EmailHeader... headers);

        /**
         * <p>
         * The email headers to include in email messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.EmailHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.EmailHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.EmailHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #headers(List<EmailHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.EmailHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<EmailHeader>)
         */
        Builder headers(Consumer<EmailHeader.Builder>... headers);

        /**
         * <p>
         * The subject line, or title, to use in email messages.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, to use in email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);
    }

    static final class BuilderImpl implements Builder {
        private EmailMessageTemplateContentBody body;

        private List<EmailHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private String subject;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessageTemplateContent model) {
            body(model.body);
            headers(model.headers);
            subject(model.subject);
        }

        public final EmailMessageTemplateContentBody.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(EmailMessageTemplateContentBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(EmailMessageTemplateContentBody body) {
            this.body = body;
            return this;
        }

        public final List<EmailHeader.Builder> getHeaders() {
            List<EmailHeader.Builder> result = EmailHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<EmailHeader.BuilderImpl> headers) {
            this.headers = EmailHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<EmailHeader> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(EmailHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<EmailHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> EmailHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public EmailMessageTemplateContent build() {
            return new EmailMessageTemplateContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
