/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssistantResponse extends QConnectResponse implements
        ToCopyableBuilder<GetAssistantResponse.Builder, GetAssistantResponse> {
    private static final SdkField<AssistantData> ASSISTANT_FIELD = SdkField.<AssistantData> builder(MarshallingType.SDK_POJO)
            .memberName("assistant").getter(getter(GetAssistantResponse::assistant)).setter(setter(Builder::assistant))
            .constructor(AssistantData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AssistantData assistant;

    private GetAssistantResponse(BuilderImpl builder) {
        super(builder);
        this.assistant = builder.assistant;
    }

    /**
     * <p>
     * Information about the assistant.
     * </p>
     * 
     * @return Information about the assistant.
     */
    public final AssistantData assistant() {
        return assistant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssistantResponse)) {
            return false;
        }
        GetAssistantResponse other = (GetAssistantResponse) obj;
        return Objects.equals(assistant(), other.assistant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssistantResponse").add("Assistant", assistant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistant":
            return Optional.ofNullable(clazz.cast(assistant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistant", ASSISTANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssistantResponse, T> g) {
        return obj -> g.apply((GetAssistantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAssistantResponse> {
        /**
         * <p>
         * Information about the assistant.
         * </p>
         * 
         * @param assistant
         *        Information about the assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistant(AssistantData assistant);

        /**
         * <p>
         * Information about the assistant.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssistantData.Builder} avoiding the need
         * to create one manually via {@link AssistantData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssistantData.Builder#build()} is called immediately and its
         * result is passed to {@link #assistant(AssistantData)}.
         * 
         * @param assistant
         *        a consumer that will call methods on {@link AssistantData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assistant(AssistantData)
         */
        default Builder assistant(Consumer<AssistantData.Builder> assistant) {
            return assistant(AssistantData.builder().applyMutation(assistant).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private AssistantData assistant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssistantResponse model) {
            super(model);
            assistant(model.assistant);
        }

        public final AssistantData.Builder getAssistant() {
            return assistant != null ? assistant.toBuilder() : null;
        }

        public final void setAssistant(AssistantData.BuilderImpl assistant) {
            this.assistant = assistant != null ? assistant.build() : null;
        }

        @Override
        public final Builder assistant(AssistantData assistant) {
            this.assistant = assistant;
            return this;
        }

        @Override
        public GetAssistantResponse build() {
            return new GetAssistantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
