/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsResponse extends QConnectResponse implements
        ToCopyableBuilder<GetRecommendationsResponse.Builder, GetRecommendationsResponse> {
    private static final SdkField<List<RecommendationData>> RECOMMENDATIONS_FIELD = SdkField
            .<List<RecommendationData>> builder(MarshallingType.LIST)
            .memberName("recommendations")
            .getter(getter(GetRecommendationsResponse::recommendations))
            .setter(setter(Builder::recommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RecommendationTrigger>> TRIGGERS_FIELD = SdkField
            .<List<RecommendationTrigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(GetRecommendationsResponse::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATIONS_FIELD,
            TRIGGERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RecommendationData> recommendations;

    private final List<RecommendationTrigger> triggers;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendations = builder.recommendations;
        this.triggers = builder.triggers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Recommendations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendations() {
        return recommendations != null && !(recommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendations} method.
     * </p>
     * 
     * @return The recommendations.
     */
    public final List<RecommendationData> recommendations() {
        return recommendations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The triggers corresponding to recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return The triggers corresponding to recommendations.
     */
    public final List<RecommendationTrigger> triggers() {
        return triggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendations() ? recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse) obj;
        return hasRecommendations() == other.hasRecommendations() && Objects.equals(recommendations(), other.recommendations())
                && hasTriggers() == other.hasTriggers() && Objects.equals(triggers(), other.triggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsResponse")
                .add("Recommendations", hasRecommendations() ? recommendations() : null)
                .add("Triggers", hasTriggers() ? triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendations":
            return Optional.ofNullable(clazz.cast(recommendations()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recommendations", RECOMMENDATIONS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRecommendationsResponse> {
        /**
         * <p>
         * The recommendations.
         * </p>
         * 
         * @param recommendations
         *        The recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(Collection<RecommendationData> recommendations);

        /**
         * <p>
         * The recommendations.
         * </p>
         * 
         * @param recommendations
         *        The recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(RecommendationData... recommendations);

        /**
         * <p>
         * The recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RecommendationData.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.RecommendationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RecommendationData.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendations(List<RecommendationData>)}.
         * 
         * @param recommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RecommendationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendations(java.util.Collection<RecommendationData>)
         */
        Builder recommendations(Consumer<RecommendationData.Builder>... recommendations);

        /**
         * <p>
         * The triggers corresponding to recommendations.
         * </p>
         * 
         * @param triggers
         *        The triggers corresponding to recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<RecommendationTrigger> triggers);

        /**
         * <p>
         * The triggers corresponding to recommendations.
         * </p>
         * 
         * @param triggers
         *        The triggers corresponding to recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(RecommendationTrigger... triggers);

        /**
         * <p>
         * The triggers corresponding to recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RecommendationTrigger.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.RecommendationTrigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RecommendationTrigger.Builder#build()} is called
         * immediately and its result is passed to {@link #triggers(List<RecommendationTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RecommendationTrigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(java.util.Collection<RecommendationTrigger>)
         */
        Builder triggers(Consumer<RecommendationTrigger.Builder>... triggers);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<RecommendationData> recommendations = DefaultSdkAutoConstructList.getInstance();

        private List<RecommendationTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            recommendations(model.recommendations);
            triggers(model.triggers);
        }

        public final List<RecommendationData.Builder> getRecommendations() {
            List<RecommendationData.Builder> result = RecommendationListCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<RecommendationData.BuilderImpl> recommendations) {
            this.recommendations = RecommendationListCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<RecommendationData> recommendations) {
            this.recommendations = RecommendationListCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(RecommendationData... recommendations) {
            recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<RecommendationData.Builder>... recommendations) {
            recommendations(Stream.of(recommendations).map(c -> RecommendationData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RecommendationTrigger.Builder> getTriggers() {
            List<RecommendationTrigger.Builder> result = RecommendationTriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<RecommendationTrigger.BuilderImpl> triggers) {
            this.triggers = RecommendationTriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<RecommendationTrigger> triggers) {
            this.triggers = RecommendationTriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(RecommendationTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<RecommendationTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> RecommendationTrigger.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
