/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMessageTemplatesResponse extends QConnectResponse implements
        ToCopyableBuilder<ListMessageTemplatesResponse.Builder, ListMessageTemplatesResponse> {
    private static final SdkField<List<MessageTemplateSummary>> MESSAGE_TEMPLATE_SUMMARIES_FIELD = SdkField
            .<List<MessageTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("messageTemplateSummaries")
            .getter(getter(ListMessageTemplatesResponse::messageTemplateSummaries))
            .setter(setter(Builder::messageTemplateSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMessageTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MESSAGE_TEMPLATE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MessageTemplateSummary> messageTemplateSummaries;

    private final String nextToken;

    private ListMessageTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.messageTemplateSummaries = builder.messageTemplateSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageTemplateSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMessageTemplateSummaries() {
        return messageTemplateSummaries != null && !(messageTemplateSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the message template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageTemplateSummaries} method.
     * </p>
     * 
     * @return Summary information about the message template.
     */
    public final List<MessageTemplateSummary> messageTemplateSummaries() {
        return messageTemplateSummaries;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageTemplateSummaries() ? messageTemplateSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMessageTemplatesResponse)) {
            return false;
        }
        ListMessageTemplatesResponse other = (ListMessageTemplatesResponse) obj;
        return hasMessageTemplateSummaries() == other.hasMessageTemplateSummaries()
                && Objects.equals(messageTemplateSummaries(), other.messageTemplateSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMessageTemplatesResponse")
                .add("MessageTemplateSummaries", hasMessageTemplateSummaries() ? messageTemplateSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageTemplateSummaries":
            return Optional.ofNullable(clazz.cast(messageTemplateSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageTemplateSummaries", MESSAGE_TEMPLATE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMessageTemplatesResponse, T> g) {
        return obj -> g.apply((ListMessageTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMessageTemplatesResponse> {
        /**
         * <p>
         * Summary information about the message template.
         * </p>
         * 
         * @param messageTemplateSummaries
         *        Summary information about the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateSummaries(Collection<MessageTemplateSummary> messageTemplateSummaries);

        /**
         * <p>
         * Summary information about the message template.
         * </p>
         * 
         * @param messageTemplateSummaries
         *        Summary information about the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateSummaries(MessageTemplateSummary... messageTemplateSummaries);

        /**
         * <p>
         * Summary information about the message template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #messageTemplateSummaries(List<MessageTemplateSummary>)}.
         * 
         * @param messageTemplateSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageTemplateSummaries(java.util.Collection<MessageTemplateSummary>)
         */
        Builder messageTemplateSummaries(Consumer<MessageTemplateSummary.Builder>... messageTemplateSummaries);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<MessageTemplateSummary> messageTemplateSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMessageTemplatesResponse model) {
            super(model);
            messageTemplateSummaries(model.messageTemplateSummaries);
            nextToken(model.nextToken);
        }

        public final List<MessageTemplateSummary.Builder> getMessageTemplateSummaries() {
            List<MessageTemplateSummary.Builder> result = MessageTemplateSummaryListCopier
                    .copyToBuilder(this.messageTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageTemplateSummaries(Collection<MessageTemplateSummary.BuilderImpl> messageTemplateSummaries) {
            this.messageTemplateSummaries = MessageTemplateSummaryListCopier.copyFromBuilder(messageTemplateSummaries);
        }

        @Override
        public final Builder messageTemplateSummaries(Collection<MessageTemplateSummary> messageTemplateSummaries) {
            this.messageTemplateSummaries = MessageTemplateSummaryListCopier.copy(messageTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTemplateSummaries(MessageTemplateSummary... messageTemplateSummaries) {
            messageTemplateSummaries(Arrays.asList(messageTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTemplateSummaries(Consumer<MessageTemplateSummary.Builder>... messageTemplateSummaries) {
            messageTemplateSummaries(Stream.of(messageTemplateSummaries)
                    .map(c -> MessageTemplateSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMessageTemplatesResponse build() {
            return new ListMessageTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
