/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MessageListCopier {
    static List<MessageOutput> copy(Collection<? extends MessageOutput> messageListParam) {
        List<MessageOutput> list;
        if (messageListParam == null || messageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MessageOutput> modifiableList = new ArrayList<>(messageListParam.size());
            messageListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MessageOutput> copyFromBuilder(Collection<? extends MessageOutput.Builder> messageListParam) {
        List<MessageOutput> list;
        if (messageListParam == null || messageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MessageOutput> modifiableList = new ArrayList<>(messageListParam.size());
            messageListParam.forEach(entry -> {
                MessageOutput member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MessageOutput.Builder> copyToBuilder(Collection<? extends MessageOutput> messageListParam) {
        List<MessageOutput.Builder> list;
        if (messageListParam == null || messageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MessageOutput.Builder> modifiableList = new ArrayList<>(messageListParam.size());
            messageListParam.forEach(entry -> {
                MessageOutput.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
