/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message template fields to query message templates by. The following is the list of supported field names:
 * </p>
 * <ul>
 * <li>
 * <p>
 * name
 * </p>
 * </li>
 * <li>
 * <p>
 * description
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateQueryField implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateQueryField.Builder, MessageTemplateQueryField> {
    private static final SdkField<Boolean> ALLOW_FUZZINESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowFuzziness").getter(getter(MessageTemplateQueryField::allowFuzziness))
            .setter(setter(Builder::allowFuzziness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowFuzziness").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MessageTemplateQueryField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(MessageTemplateQueryField::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("priority").getter(getter(MessageTemplateQueryField::priorityAsString)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(MessageTemplateQueryField::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FUZZINESS_FIELD,
            NAME_FIELD, OPERATOR_FIELD, PRIORITY_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allowFuzziness;

    private final String name;

    private final String operator;

    private final String priority;

    private final List<String> values;

    private MessageTemplateQueryField(BuilderImpl builder) {
        this.allowFuzziness = builder.allowFuzziness;
        this.name = builder.name;
        this.operator = builder.operator;
        this.priority = builder.priority;
        this.values = builder.values;
    }

    /**
     * <p>
     * Whether the query expects only exact matches on the attribute field values. The results of the query will only
     * include exact matches if this parameter is set to false.
     * </p>
     * 
     * @return Whether the query expects only exact matches on the attribute field values. The results of the query will
     *         only include exact matches if this parameter is set to false.
     */
    public final Boolean allowFuzziness() {
        return allowFuzziness;
    }

    /**
     * <p>
     * The name of the attribute to query the message templates by.
     * </p>
     * 
     * @return The name of the attribute to query the message templates by.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The operator to use for matching attribute field values in the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link MessageTemplateQueryOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for matching attribute field values in the query.
     * @see MessageTemplateQueryOperator
     */
    public final MessageTemplateQueryOperator operator() {
        return MessageTemplateQueryOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to use for matching attribute field values in the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link MessageTemplateQueryOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for matching attribute field values in the query.
     * @see MessageTemplateQueryOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The importance of the attribute field when calculating query result relevancy scores. The value set for this
     * parameter affects the ordering of search results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priority} will
     * return {@link Priority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priorityAsString}.
     * </p>
     * 
     * @return The importance of the attribute field when calculating query result relevancy scores. The value set for
     *         this parameter affects the ordering of search results.
     * @see Priority
     */
    public final Priority priority() {
        return Priority.fromValue(priority);
    }

    /**
     * <p>
     * The importance of the attribute field when calculating query result relevancy scores. The value set for this
     * parameter affects the ordering of search results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priority} will
     * return {@link Priority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priorityAsString}.
     * </p>
     * 
     * @return The importance of the attribute field when calculating query result relevancy scores. The value set for
     *         this parameter affects the ordering of search results.
     * @see Priority
     */
    public final String priorityAsString() {
        return priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of the attribute to query the message templates by.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values of the attribute to query the message templates by.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowFuzziness());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateQueryField)) {
            return false;
        }
        MessageTemplateQueryField other = (MessageTemplateQueryField) obj;
        return Objects.equals(allowFuzziness(), other.allowFuzziness()) && Objects.equals(name(), other.name())
                && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(priorityAsString(), other.priorityAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateQueryField").add("AllowFuzziness", allowFuzziness()).add("Name", name())
                .add("Operator", operatorAsString()).add("Priority", priorityAsString())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowFuzziness":
            return Optional.ofNullable(clazz.cast(allowFuzziness()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priorityAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowFuzziness", ALLOW_FUZZINESS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateQueryField, T> g) {
        return obj -> g.apply((MessageTemplateQueryField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateQueryField> {
        /**
         * <p>
         * Whether the query expects only exact matches on the attribute field values. The results of the query will
         * only include exact matches if this parameter is set to false.
         * </p>
         * 
         * @param allowFuzziness
         *        Whether the query expects only exact matches on the attribute field values. The results of the query
         *        will only include exact matches if this parameter is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowFuzziness(Boolean allowFuzziness);

        /**
         * <p>
         * The name of the attribute to query the message templates by.
         * </p>
         * 
         * @param name
         *        The name of the attribute to query the message templates by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The operator to use for matching attribute field values in the query.
         * </p>
         * 
         * @param operator
         *        The operator to use for matching attribute field values in the query.
         * @see MessageTemplateQueryOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageTemplateQueryOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to use for matching attribute field values in the query.
         * </p>
         * 
         * @param operator
         *        The operator to use for matching attribute field values in the query.
         * @see MessageTemplateQueryOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageTemplateQueryOperator
         */
        Builder operator(MessageTemplateQueryOperator operator);

        /**
         * <p>
         * The importance of the attribute field when calculating query result relevancy scores. The value set for this
         * parameter affects the ordering of search results.
         * </p>
         * 
         * @param priority
         *        The importance of the attribute field when calculating query result relevancy scores. The value set
         *        for this parameter affects the ordering of search results.
         * @see Priority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Priority
         */
        Builder priority(String priority);

        /**
         * <p>
         * The importance of the attribute field when calculating query result relevancy scores. The value set for this
         * parameter affects the ordering of search results.
         * </p>
         * 
         * @param priority
         *        The importance of the attribute field when calculating query result relevancy scores. The value set
         *        for this parameter affects the ordering of search results.
         * @see Priority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Priority
         */
        Builder priority(Priority priority);

        /**
         * <p>
         * The values of the attribute to query the message templates by.
         * </p>
         * 
         * @param values
         *        The values of the attribute to query the message templates by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values of the attribute to query the message templates by.
         * </p>
         * 
         * @param values
         *        The values of the attribute to query the message templates by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowFuzziness;

        private String name;

        private String operator;

        private String priority;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateQueryField model) {
            allowFuzziness(model.allowFuzziness);
            name(model.name);
            operator(model.operator);
            priority(model.priority);
            values(model.values);
        }

        public final Boolean getAllowFuzziness() {
            return allowFuzziness;
        }

        public final void setAllowFuzziness(Boolean allowFuzziness) {
            this.allowFuzziness = allowFuzziness;
        }

        @Override
        public final Builder allowFuzziness(Boolean allowFuzziness) {
            this.allowFuzziness = allowFuzziness;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(MessageTemplateQueryOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getPriority() {
            return priority;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public final Builder priority(Priority priority) {
            this.priority(priority == null ? null : priority.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = MessageTemplateQueryValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = MessageTemplateQueryValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public MessageTemplateQueryField build() {
            return new MessageTemplateQueryField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
