/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input information for the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryInputData implements SdkPojo, Serializable, ToCopyableBuilder<QueryInputData.Builder, QueryInputData> {
    private static final SdkField<IntentInputData> INTENT_INPUT_DATA_FIELD = SdkField
            .<IntentInputData> builder(MarshallingType.SDK_POJO).memberName("intentInputData")
            .getter(getter(QueryInputData::intentInputData)).setter(setter(Builder::intentInputData))
            .constructor(IntentInputData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentInputData").build()).build();

    private static final SdkField<QueryTextInputData> QUERY_TEXT_INPUT_DATA_FIELD = SdkField
            .<QueryTextInputData> builder(MarshallingType.SDK_POJO).memberName("queryTextInputData")
            .getter(getter(QueryInputData::queryTextInputData)).setter(setter(Builder::queryTextInputData))
            .constructor(QueryTextInputData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTextInputData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_INPUT_DATA_FIELD,
            QUERY_TEXT_INPUT_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IntentInputData intentInputData;

    private final QueryTextInputData queryTextInputData;

    private final Type type;

    private QueryInputData(BuilderImpl builder) {
        this.intentInputData = builder.intentInputData;
        this.queryTextInputData = builder.queryTextInputData;
        this.type = builder.type;
    }

    /**
     * <p>
     * Input information for the intent.
     * </p>
     * 
     * @return Input information for the intent.
     */
    public final IntentInputData intentInputData() {
        return intentInputData;
    }

    /**
     * <p>
     * Input information for the query.
     * </p>
     * 
     * @return Input information for the query.
     */
    public final QueryTextInputData queryTextInputData() {
        return queryTextInputData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentInputData());
        hashCode = 31 * hashCode + Objects.hashCode(queryTextInputData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInputData)) {
            return false;
        }
        QueryInputData other = (QueryInputData) obj;
        return Objects.equals(intentInputData(), other.intentInputData())
                && Objects.equals(queryTextInputData(), other.queryTextInputData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryInputData").add("IntentInputData", intentInputData())
                .add("QueryTextInputData", queryTextInputData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentInputData":
            return Optional.ofNullable(clazz.cast(intentInputData()));
        case "queryTextInputData":
            return Optional.ofNullable(clazz.cast(queryTextInputData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #intentInputData()} initialized to the given value.
     *
     * <p>
     * Input information for the intent.
     * </p>
     * 
     * @param intentInputData
     *        Input information for the intent.
     */
    public static QueryInputData fromIntentInputData(IntentInputData intentInputData) {
        return builder().intentInputData(intentInputData).build();
    }

    /**
     * Create an instance of this class with {@link #intentInputData()} initialized to the given value.
     *
     * <p>
     * Input information for the intent.
     * </p>
     * 
     * @param intentInputData
     *        Input information for the intent.
     */
    public static QueryInputData fromIntentInputData(Consumer<IntentInputData.Builder> intentInputData) {
        IntentInputData.Builder builder = IntentInputData.builder();
        intentInputData.accept(builder);
        return fromIntentInputData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #queryTextInputData()} initialized to the given value.
     *
     * <p>
     * Input information for the query.
     * </p>
     * 
     * @param queryTextInputData
     *        Input information for the query.
     */
    public static QueryInputData fromQueryTextInputData(QueryTextInputData queryTextInputData) {
        return builder().queryTextInputData(queryTextInputData).build();
    }

    /**
     * Create an instance of this class with {@link #queryTextInputData()} initialized to the given value.
     *
     * <p>
     * Input information for the query.
     * </p>
     * 
     * @param queryTextInputData
     *        Input information for the query.
     */
    public static QueryInputData fromQueryTextInputData(Consumer<QueryTextInputData.Builder> queryTextInputData) {
        QueryTextInputData.Builder builder = QueryTextInputData.builder();
        queryTextInputData.accept(builder);
        return fromQueryTextInputData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentInputData", INTENT_INPUT_DATA_FIELD);
        map.put("queryTextInputData", QUERY_TEXT_INPUT_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryInputData, T> g) {
        return obj -> g.apply((QueryInputData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryInputData> {
        /**
         * <p>
         * Input information for the intent.
         * </p>
         * 
         * @param intentInputData
         *        Input information for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentInputData(IntentInputData intentInputData);

        /**
         * <p>
         * Input information for the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentInputData.Builder} avoiding the
         * need to create one manually via {@link IntentInputData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentInputData.Builder#build()} is called immediately and its
         * result is passed to {@link #intentInputData(IntentInputData)}.
         * 
         * @param intentInputData
         *        a consumer that will call methods on {@link IntentInputData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentInputData(IntentInputData)
         */
        default Builder intentInputData(Consumer<IntentInputData.Builder> intentInputData) {
            return intentInputData(IntentInputData.builder().applyMutation(intentInputData).build());
        }

        /**
         * <p>
         * Input information for the query.
         * </p>
         * 
         * @param queryTextInputData
         *        Input information for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTextInputData(QueryTextInputData queryTextInputData);

        /**
         * <p>
         * Input information for the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryTextInputData.Builder} avoiding the
         * need to create one manually via {@link QueryTextInputData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryTextInputData.Builder#build()} is called immediately and its
         * result is passed to {@link #queryTextInputData(QueryTextInputData)}.
         * 
         * @param queryTextInputData
         *        a consumer that will call methods on {@link QueryTextInputData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryTextInputData(QueryTextInputData)
         */
        default Builder queryTextInputData(Consumer<QueryTextInputData.Builder> queryTextInputData) {
            return queryTextInputData(QueryTextInputData.builder().applyMutation(queryTextInputData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IntentInputData intentInputData;

        private QueryTextInputData queryTextInputData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInputData model) {
            intentInputData(model.intentInputData);
            queryTextInputData(model.queryTextInputData);
        }

        public final IntentInputData.Builder getIntentInputData() {
            return intentInputData != null ? intentInputData.toBuilder() : null;
        }

        public final void setIntentInputData(IntentInputData.BuilderImpl intentInputData) {
            Object oldValue = this.intentInputData;
            this.intentInputData = intentInputData != null ? intentInputData.build() : null;
            handleUnionValueChange(Type.INTENT_INPUT_DATA, oldValue, this.intentInputData);
        }

        @Override
        public final Builder intentInputData(IntentInputData intentInputData) {
            Object oldValue = this.intentInputData;
            this.intentInputData = intentInputData;
            handleUnionValueChange(Type.INTENT_INPUT_DATA, oldValue, this.intentInputData);
            return this;
        }

        public final QueryTextInputData.Builder getQueryTextInputData() {
            return queryTextInputData != null ? queryTextInputData.toBuilder() : null;
        }

        public final void setQueryTextInputData(QueryTextInputData.BuilderImpl queryTextInputData) {
            Object oldValue = this.queryTextInputData;
            this.queryTextInputData = queryTextInputData != null ? queryTextInputData.build() : null;
            handleUnionValueChange(Type.QUERY_TEXT_INPUT_DATA, oldValue, this.queryTextInputData);
        }

        @Override
        public final Builder queryTextInputData(QueryTextInputData queryTextInputData) {
            Object oldValue = this.queryTextInputData;
            this.queryTextInputData = queryTextInputData;
            handleUnionValueChange(Type.QUERY_TEXT_INPUT_DATA, oldValue, this.queryTextInputData);
            return this;
        }

        @Override
        public QueryInputData build() {
            return new QueryInputData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see QueryInputData#type()
     */
    public enum Type {
        INTENT_INPUT_DATA,

        QUERY_TEXT_INPUT_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
